/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.geom;

import com.badlogic.gdx.math.Vector2;
import org.mini2Dx.core.geom.Circle;
import org.mini2Dx.core.geom.LineSegment;
import org.mini2Dx.core.geom.Parallelogram;
import org.mini2Dx.core.geom.Point;
import org.mini2Dx.core.geom.Polygon;
import org.mini2Dx.core.geom.Shape;
import org.mini2Dx.core.geom.Triangle;
import org.mini2Dx.core.graphics.Graphics;
import org.mini2Dx.core.util.EdgeIterator;

public class Rectangle
extends Shape
implements Parallelogram {
    private static final long serialVersionUID = 4016090439885217620L;
    private static final Vector2[] TMP_VERTICES = new Vector2[]{new Vector2(), new Vector2(), new Vector2(), new Vector2()};
    private static final Rectangle TMP_RECTANGLE = new Rectangle();
    final Polygon polygon;
    private float width;
    private float height;

    public Rectangle() {
        this(0.0f, 0.0f, 1.0f, 1.0f);
    }

    public Rectangle(float x, float y, float width, float height) {
        this.width = width;
        this.height = height;
        this.polygon = new Polygon(this.determineVertices(x, y, width, height));
    }

    public Rectangle(Rectangle rectangle) {
        this.width = rectangle.getWidth();
        this.height = rectangle.getHeight();
        this.polygon = (Polygon)rectangle.polygon.copy();
    }

    @Override
    public Shape copy() {
        return new Rectangle(this);
    }

    private Vector2[] determineVertices(float x, float y, float width, float height) {
        TMP_VERTICES[0].set(x, y);
        TMP_VERTICES[1].set(x + width, y);
        TMP_VERTICES[2].set(x + width, y + height);
        TMP_VERTICES[3].set(x, y + height);
        return TMP_VERTICES;
    }

    @Override
    public boolean contains(float x, float y) {
        return this.polygon.contains(x, y);
    }

    @Override
    public boolean contains(Vector2 point) {
        return this.polygon.contains(point);
    }

    @Override
    public boolean contains(Shape shape) {
        return this.polygon.contains(shape);
    }

    public boolean contains(Parallelogram parallelogram) {
        TMP_RECTANGLE.set(parallelogram.getX(), parallelogram.getY(), parallelogram.getWidth(), parallelogram.getHeight());
        TMP_RECTANGLE.setRotation(parallelogram.getRotation());
        return this.contains(TMP_RECTANGLE);
    }

    public boolean contains(Rectangle rectangle) {
        return this.polygon.contains(rectangle.polygon);
    }

    public boolean contains(Circle circle) {
        return this.polygon.contains(circle.getBoundingBox());
    }

    @Override
    public boolean intersects(Shape shape) {
        return this.polygon.intersects(shape);
    }

    @Override
    public boolean intersectsLineSegment(LineSegment lineSegment) {
        return this.polygon.intersects(lineSegment);
    }

    public boolean intersects(Circle circle) {
        return this.polygon.intersects(circle);
    }

    public boolean intersects(Rectangle rectangle) {
        boolean xAxisOverlaps = true;
        boolean yAxisOverlaps = true;
        if (this.polygon.getMaxX() < rectangle.getMinX()) {
            xAxisOverlaps = false;
        }
        if (rectangle.getMaxX() < this.polygon.getMinX()) {
            xAxisOverlaps = false;
        }
        if (this.polygon.getMaxY() < rectangle.getMinY()) {
            yAxisOverlaps = false;
        }
        if (rectangle.getMaxY() < this.polygon.getMinY()) {
            yAxisOverlaps = false;
        }
        return xAxisOverlaps && yAxisOverlaps;
    }

    public boolean intersects(Parallelogram parallelogram) {
        TMP_RECTANGLE.set(parallelogram.getX(), parallelogram.getY(), parallelogram.getWidth(), parallelogram.getHeight());
        TMP_RECTANGLE.setRotation(parallelogram.getRotation());
        return this.intersects(TMP_RECTANGLE);
    }

    @Override
    public boolean intersects(float x, float y, float width, float height) {
        TMP_RECTANGLE.set(x, y, width, height);
        TMP_RECTANGLE.setRotation(0.0f);
        return this.intersects(TMP_RECTANGLE);
    }

    public boolean intersects(Triangle triangle) {
        return this.polygon.intersects(triangle);
    }

    public boolean intersects(Polygon polygon) {
        return this.polygon.intersects(polygon);
    }

    @Override
    public boolean intersectsLineSegment(Vector2 pointA, Vector2 pointB) {
        return this.polygon.intersectsLineSegment(pointA, pointB);
    }

    @Override
    public boolean intersectsLineSegment(float x1, float y1, float x2, float y2) {
        return this.polygon.intersectsLineSegment(x1, y1, x2, y2);
    }

    public Rectangle intersection(Rectangle rect) {
        if (this.polygon.getRotation() != 0.0f || rect.getRotation() != 0.0f) {
            throw new UnsupportedOperationException("Rectangle.intersection is not implemented to handle rotated rectangles");
        }
        float newX = Math.max(this.getX(), rect.getX());
        float newY = Math.max(this.getY(), rect.getY());
        float newWidth = Math.min(this.getMaxX(), rect.getMaxX()) - newX;
        float newHeight = Math.min(this.getMaxY(), rect.getMaxY()) - newY;
        return new Rectangle(newX, newY, newWidth, newHeight);
    }

    @Override
    public int getNumberOfSides() {
        return 4;
    }

    @Override
    public void draw(Graphics g) {
        this.polygon.draw(g);
    }

    @Override
    public void fill(Graphics g) {
        this.polygon.fill(g);
    }

    public Rectangle lerp(Rectangle target, float alpha) {
        float inverseAlpha = 1.0f - alpha;
        float x = this.getX() * inverseAlpha + target.getX() * alpha;
        float y = this.getY() * inverseAlpha + target.getY() * alpha;
        float width = this.width;
        float height = this.height;
        if (this.getWidth() != target.getWidth()) {
            width = this.getWidth() * inverseAlpha + target.getWidth() * alpha;
        }
        if (this.getHeight() != target.getHeight()) {
            height = this.getHeight() * inverseAlpha + target.getHeight() * alpha;
        }
        if (this.getRotation() != target.getRotation()) {
            float rotation = this.getRotation() * inverseAlpha + target.getRotation() * alpha;
            this.setRotation(rotation);
        }
        this.set(x, y, width, height);
        return this;
    }

    @Override
    public float getDistanceTo(Point point) {
        return this.getDistanceTo(point.getX(), point.getY());
    }

    @Override
    public float getDistanceTo(float x, float y) {
        return this.polygon.getDistanceTo(x, y);
    }

    @Override
    public float getRotation() {
        return this.polygon.getRotation();
    }

    @Override
    public void setRotation(float degrees) {
        this.polygon.setRotation(degrees);
    }

    @Override
    public void rotate(float degrees) {
        this.polygon.rotate(degrees);
    }

    @Override
    public void rotateAround(float centerX, float centerY, float degrees) {
        this.polygon.rotateAround(centerX, centerY, degrees);
    }

    @Override
    public void setRotationAround(Point center, float degrees) {
        this.polygon.setRotationAround(center.x, center.y, degrees);
    }

    @Override
    public void setRotationAround(float centerX, float centerY, float degrees) {
        this.polygon.setRotationAround(centerX, centerY, degrees);
    }

    public Rectangle set(float x, float y, float width, float height) {
        float rotation = this.polygon.getRotation();
        if (rotation != 0.0f) {
            this.polygon.setRotation(-rotation);
        }
        this.polygon.setVertices(this.determineVertices(x, y, width, height));
        if (rotation != 0.0f) {
            this.polygon.setRotation(rotation);
        }
        this.width = width;
        this.height = height;
        return this;
    }

    public void set(Rectangle rectangle) {
        if (this.equals(rectangle)) {
            return;
        }
        this.set(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
        this.setRotation(rectangle.getRotation());
    }

    @Override
    public void set(float x, float y) {
        this.polygon.set(x, y);
    }

    public void set(Vector2 position) {
        this.polygon.set(position.x, position.y);
    }

    @Override
    public float getX() {
        return this.polygon.getX();
    }

    @Override
    public void setX(float x) {
        this.polygon.setX(x);
    }

    @Override
    public float getY() {
        return this.polygon.getY();
    }

    @Override
    public void setY(float y) {
        this.polygon.setY(y);
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    public Rectangle setWidth(float width) {
        float rotation = this.polygon.getRotation();
        this.polygon.setRotation(-rotation);
        this.polygon.setVertices(this.determineVertices(this.getX(), this.getY(), width, this.getHeight()));
        this.polygon.setRotation(rotation);
        this.width = width;
        return this;
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    public Rectangle setHeight(float height) {
        float rotation = this.polygon.getRotation();
        this.polygon.setRotation(-rotation);
        this.polygon.setVertices(this.determineVertices(this.getX(), this.getY(), this.getWidth(), height));
        this.polygon.setRotation(rotation);
        this.height = height;
        return this;
    }

    public Rectangle setSize(float width, float height) {
        float rotation = this.polygon.getRotation();
        this.polygon.setRotation(-rotation);
        this.polygon.setVertices(this.determineVertices(this.getX(), this.getY(), this.getWidth(), height));
        this.polygon.setRotation(rotation);
        this.width = width;
        this.height = height;
        return this;
    }

    public Rectangle setSize(float sizeXY) {
        float rotation = this.polygon.getRotation();
        this.polygon.setRotation(-rotation);
        this.polygon.setVertices(this.determineVertices(this.getX(), this.getY(), sizeXY, sizeXY));
        this.polygon.setRotation(rotation);
        this.width = sizeXY;
        this.height = sizeXY;
        return this;
    }

    @Override
    public void setRadius(float radius) {
        this.polygon.setRadius(radius);
        this.width = this.polygon.getMaxX() - this.polygon.getX();
        this.height = this.polygon.getMaxY() - this.polygon.getY();
    }

    @Override
    public void scale(float scale) {
        this.polygon.scale(scale);
        this.width = this.polygon.getMaxX() - this.polygon.getX();
        this.height = this.polygon.getMaxY() - this.polygon.getY();
    }

    @Override
    public void translate(float translateX, float translateY) {
        this.polygon.translate(translateX, translateY);
    }

    @Override
    public EdgeIterator edgeIterator() {
        return this.polygon.edgeIterator();
    }

    @Override
    public float getCenterX() {
        return this.polygon.getCenterX();
    }

    @Override
    public float getCenterY() {
        return this.polygon.getCenterY();
    }

    @Override
    public void setCenter(float x, float y) {
        this.polygon.setCenter(x, y);
    }

    @Override
    public void setCenterX(float x) {
        this.polygon.setCenterX(x);
    }

    @Override
    public void setCenterY(float y) {
        this.polygon.setCenterY(y);
    }

    @Override
    public float getMinX() {
        return this.polygon.getMinX();
    }

    @Override
    public float getMinY() {
        return this.polygon.getMinY();
    }

    @Override
    public float getMaxX() {
        return this.polygon.getMaxX();
    }

    @Override
    public float getMaxY() {
        return this.polygon.getMaxY();
    }

    public float[] getVertices() {
        return this.polygon.getVertices();
    }

    public String toString() {
        return "Rectangle [rotation=" + this.polygon.getRotation() + ", x=" + this.getX() + ", y=" + this.getY() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + "]";
    }

    @Override
    public boolean isCircle() {
        return false;
    }

    @Override
    public Polygon getPolygon() {
        return this.polygon;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.getX());
        result = 31 * result + Float.floatToIntBits(this.getY());
        result = 31 * result + Float.floatToIntBits(this.height);
        result = 31 * result + Float.floatToIntBits(this.width);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Rectangle other = (Rectangle)obj;
        if (Float.floatToIntBits(this.getX()) != Float.floatToIntBits(other.getX())) {
            return false;
        }
        if (Float.floatToIntBits(this.getY()) != Float.floatToIntBits(other.getY())) {
            return false;
        }
        if (Float.floatToIntBits(this.height) != Float.floatToIntBits(other.height)) {
            return false;
        }
        if (Float.floatToIntBits(this.width) != Float.floatToIntBits(other.width)) {
            return false;
        }
        return Float.floatToIntBits(this.getRotation()) == Float.floatToIntBits(other.getRotation());
    }
}

