/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.geom;

import com.badlogic.gdx.math.Vector2;
import org.mini2Dx.core.geom.LineSegment;
import org.mini2Dx.core.geom.Point;
import org.mini2Dx.core.geom.Polygon;
import org.mini2Dx.core.graphics.Graphics;
import org.mini2Dx.core.util.EdgeIterator;

public abstract class Shape {
    private static final Vector2 TMP_VECTOR = new Vector2();

    public abstract Shape copy();

    public abstract boolean contains(float var1, float var2);

    public abstract boolean contains(Vector2 var1);

    public abstract boolean contains(Shape var1);

    public boolean intersects(LineSegment lineSegment) {
        return this.intersectsLineSegment(lineSegment.getPointA(), lineSegment.getPointB());
    }

    public abstract boolean intersectsLineSegment(Vector2 var1, Vector2 var2);

    public abstract boolean intersectsLineSegment(float var1, float var2, float var3, float var4);

    public abstract boolean intersects(Shape var1);

    public abstract float getDistanceTo(float var1, float var2);

    public float getDistanceTo(Point point) {
        return this.getDistanceTo(point.getX(), point.getY());
    }

    public void add(float x, float y) {
        TMP_VECTOR.set(this.getX(), this.getY());
        TMP_VECTOR.add(x, y);
        this.set(Shape.TMP_VECTOR.x, Shape.TMP_VECTOR.y);
    }

    public void subtract(float x, float y) {
        TMP_VECTOR.set(this.getX(), this.getY());
        TMP_VECTOR.sub(x, y);
        this.set(Shape.TMP_VECTOR.x, Shape.TMP_VECTOR.y);
    }

    public abstract float getRotation();

    public abstract void setRotation(float var1);

    public abstract void setRotationAround(float var1, float var2, float var3);

    public abstract void rotate(float var1);

    public abstract void rotateAround(float var1, float var2, float var3);

    public abstract void draw(Graphics var1);

    public abstract void fill(Graphics var1);

    public abstract float getX();

    public abstract float getY();

    public abstract float getCenterX();

    public abstract float getCenterY();

    public abstract void setCenter(float var1, float var2);

    public abstract void setCenterX(float var1);

    public abstract void setCenterY(float var1);

    public abstract void setX(float var1);

    public abstract void setY(float var1);

    public abstract void set(float var1, float var2);

    public abstract void setRadius(float var1);

    public abstract void scale(float var1);

    public abstract float getMinX();

    public abstract float getMinY();

    public abstract float getMaxX();

    public abstract float getMaxY();

    public abstract void translate(float var1, float var2);

    public abstract int getNumberOfSides();

    public abstract EdgeIterator edgeIterator();

    public abstract boolean isCircle();

    public abstract Polygon getPolygon();

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.getNumberOfSides());
        result = 31 * result + Float.floatToIntBits(this.getX());
        result = 31 * result + Float.floatToIntBits(this.getY());
        result = 31 * result + Float.floatToIntBits(this.getMinX());
        result = 31 * result + Float.floatToIntBits(this.getMinY());
        result = 31 * result + Float.floatToIntBits(this.getMaxX());
        result = 31 * result + Float.floatToIntBits(this.getMaxY());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Shape other = (Shape)obj;
        if (Float.floatToIntBits(this.getNumberOfSides()) != Float.floatToIntBits(other.getNumberOfSides())) {
            return false;
        }
        if (Float.floatToIntBits(this.getX()) != Float.floatToIntBits(other.getX())) {
            return false;
        }
        if (Float.floatToIntBits(this.getY()) != Float.floatToIntBits(other.getY())) {
            return false;
        }
        if (Float.floatToIntBits(this.getMinX()) != Float.floatToIntBits(other.getMinX())) {
            return false;
        }
        if (Float.floatToIntBits(this.getMinY()) != Float.floatToIntBits(other.getMinY())) {
            return false;
        }
        if (Float.floatToIntBits(this.getMaxX()) != Float.floatToIntBits(other.getMaxX())) {
            return false;
        }
        return Float.floatToIntBits(this.getMaxY()) == Float.floatToIntBits(other.getMaxY());
    }
}

