/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.geom;

import com.badlogic.gdx.math.Vector2;
import org.mini2Dx.core.geom.LineSegment;
import org.mini2Dx.core.geom.Polygon;
import org.mini2Dx.core.geom.Rectangle;
import org.mini2Dx.core.geom.Shape;
import org.mini2Dx.core.graphics.Graphics;
import org.mini2Dx.core.util.EdgeIterator;

public class Triangle
extends Shape {
    private static final int TOTAL_SIDES = 3;
    final Polygon polygon;

    public Triangle(Vector2 v1, Vector2 v2, Vector2 v3) {
        this(v1.x, v1.y, v2.x, v2.y, v3.x, v3.y);
    }

    public Triangle(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.polygon = new Polygon(new float[]{x1, y1, x2, y2, x3, y3});
    }

    public Triangle(Triangle triangle) {
        this.polygon = (Polygon)triangle.polygon.copy();
    }

    @Override
    public Shape copy() {
        return new Triangle(this);
    }

    @Override
    public boolean contains(float x, float y) {
        return this.polygon.contains(x, y);
    }

    @Override
    public boolean contains(Vector2 vector2) {
        return this.polygon.contains(vector2.x, vector2.y);
    }

    @Override
    public boolean contains(Shape shape) {
        return this.polygon.contains(shape);
    }

    @Override
    public boolean intersects(Shape shape) {
        return this.polygon.intersects(shape);
    }

    @Override
    public boolean intersects(LineSegment lineSegment) {
        return this.intersectsLineSegment(lineSegment.getPointA(), lineSegment.getPointB());
    }

    @Override
    public boolean intersectsLineSegment(Vector2 pointA, Vector2 pointB) {
        return this.polygon.intersectsLineSegment(pointA, pointB);
    }

    @Override
    public boolean intersectsLineSegment(float x1, float y1, float x2, float y2) {
        return this.polygon.intersectsLineSegment(x1, y1, x2, y2);
    }

    public boolean intersects(Polygon polygon) {
        return polygon.intersects(polygon);
    }

    public boolean intersects(Triangle triangle) {
        return this.polygon.intersects(triangle.polygon);
    }

    public boolean intersects(Rectangle rectangle) {
        return this.polygon.intersects(rectangle);
    }

    @Override
    public void translate(float translateX, float translateY) {
        this.polygon.translate(translateX, translateY);
    }

    @Override
    public void setRotation(float degrees) {
        this.polygon.setRotation(degrees);
    }

    @Override
    public void rotate(float degrees) {
        this.polygon.rotate(degrees);
    }

    @Override
    public int getNumberOfSides() {
        return 3;
    }

    @Override
    public void draw(Graphics g) {
        this.polygon.draw(g);
    }

    @Override
    public void fill(Graphics g) {
        this.polygon.fill(g);
    }

    @Override
    public float getDistanceTo(float x, float y) {
        return this.polygon.getDistanceTo(x, y);
    }

    @Override
    public float getRotation() {
        return this.polygon.getRotation();
    }

    @Override
    public void setRotationAround(float centerX, float centerY, float degrees) {
        this.polygon.setRotationAround(centerX, centerY, degrees);
    }

    @Override
    public void rotateAround(float centerX, float centerY, float degrees) {
        this.polygon.rotateAround(centerX, centerY, degrees);
    }

    @Override
    public float getX() {
        return this.polygon.getX();
    }

    @Override
    public void setX(float x) {
        this.polygon.set(x, this.polygon.getY());
    }

    @Override
    public float getY() {
        return this.polygon.getY();
    }

    @Override
    public void setY(float y) {
        this.polygon.set(this.polygon.getX(), y);
    }

    @Override
    public void set(float x, float y) {
        this.polygon.set(x, y);
    }

    public void setPosition(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.polygon.setVertices(new float[]{x1, y1, x2, y2, x3, y3});
    }

    @Override
    public float getMinX() {
        return this.polygon.getMinX();
    }

    @Override
    public float getMinY() {
        return this.polygon.getMinY();
    }

    @Override
    public float getMaxX() {
        return this.polygon.getMaxX();
    }

    @Override
    public float getMaxY() {
        return this.polygon.getMaxY();
    }

    @Override
    public float getCenterX() {
        return this.polygon.getCenterX();
    }

    @Override
    public float getCenterY() {
        return this.polygon.getCenterY();
    }

    @Override
    public void setCenter(float x, float y) {
        this.polygon.setCenter(x, y);
    }

    @Override
    public void setCenterX(float x) {
        this.polygon.setCenterX(x);
    }

    @Override
    public void setCenterY(float y) {
        this.polygon.setCenterY(y);
    }

    @Override
    public void setRadius(float radius) {
        this.polygon.setRadius(radius);
    }

    @Override
    public EdgeIterator edgeIterator() {
        return this.polygon.edgeIterator();
    }

    @Override
    public boolean isCircle() {
        return false;
    }

    @Override
    public Polygon getPolygon() {
        return this.polygon;
    }

    @Override
    public void scale(float scale) {
        this.polygon.scale(scale);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.polygon == null ? 0 : this.polygon.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Triangle other = (Triangle)obj;
        return !(this.polygon == null ? other.polygon != null : !this.polygon.equals(other.polygon));
    }
}

