/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.graphics;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;

public class GlyphLayout
extends com.badlogic.gdx.graphics.g2d.GlyphLayout {
    private static final GlyphLayout TMP_LAYOUT = new GlyphLayout();

    public GlyphLayout() {
    }

    public GlyphLayout(BitmapFont font, CharSequence str) {
        super(font, str);
    }

    public GlyphLayout(BitmapFont font, CharSequence str, Color color, float targetWidth, int halign, boolean wrap) {
        super(font, str, color, targetWidth, halign, wrap);
    }

    public GlyphLayout(BitmapFont font, CharSequence str, int start, int end, Color color, float targetWidth, int halign, boolean wrap, String truncate) {
        super(font, str, start, end, color, targetWidth, halign, wrap, truncate);
    }

    public static GlyphPosition calculateFirstRenderPositionOfWord(BitmapFont font, String sentence, String word, float targetWidth, int halign, boolean wrap) {
        TMP_LAYOUT.setText(font, sentence, Color.WHITE, targetWidth, halign, wrap);
        GlyphPosition result = TMP_LAYOUT.new GlyphPosition();
        for (int runIndex = 0; runIndex < GlyphLayout.TMP_LAYOUT.runs.size; ++runIndex) {
            int glyphIndex;
            GlyphLayout.GlyphRun run = (GlyphLayout.GlyphRun)GlyphLayout.TMP_LAYOUT.runs.get(runIndex);
            boolean match = false;
            int charIndex = 0;
            for (glyphIndex = 0; glyphIndex < run.glyphs.size; ++glyphIndex) {
                BitmapFont.Glyph glyph = (BitmapFont.Glyph)run.glyphs.get(glyphIndex);
                if (glyph.id == word.charAt(charIndex)) {
                    if (++charIndex < word.length()) continue;
                    match = true;
                    break;
                }
                charIndex = 0;
            }
            if (!match) continue;
            int glyphStartIndex = glyphIndex > 0 ? glyphIndex - (word.length() - 1) : 0;
            float xAdvancesSum = run.xAdvances.get(0);
            for (int i = 0; i < run.glyphs.size && i < glyphStartIndex; ++i) {
                xAdvancesSum += run.xAdvances.get(i + 1);
            }
            result.x = run.x + xAdvancesSum;
            result.y = run.y;
            return result;
        }
        return null;
    }

    public class GlyphPosition {
        public float x;
        public float y;
    }
}

