/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.graphics;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.BitmapFontCache;
import com.badlogic.gdx.graphics.g2d.SpriteCache;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.utils.NinePatchDrawable;
import com.badlogic.gdx.scenes.scene2d.utils.TiledDrawable;
import com.badlogic.gdx.utils.viewport.Viewport;
import org.mini2Dx.core.geom.Rectangle;
import org.mini2Dx.core.geom.Shape;
import org.mini2Dx.core.graphics.Graphics;
import org.mini2Dx.core.graphics.NinePatch;
import org.mini2Dx.core.graphics.ParticleEffect;
import org.mini2Dx.core.graphics.Sprite;
import org.mini2Dx.core.graphics.TextureRegion;

public class HeadlessGraphics
implements Graphics {
    private Color color = Color.WHITE;
    private Color backgroundColor = Color.BLACK;
    private Color tint = null;
    private OrthographicCamera camera = new OrthographicCamera();
    private float translationX = 0.0f;
    private float translationY = 0.0f;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private float rotation = 0.0f;
    private float rotationX = 0.0f;
    private float rotationY = 0.0f;
    private int windowWidth = 0;
    private int windowHeight = 0;
    private int lineHeight = 1;
    private Rectangle clip;

    @Override
    public void preRender(int gameWidth, int gameHeight) {
        this.windowWidth = gameWidth;
        this.windowHeight = gameHeight;
    }

    @Override
    public void postRender() {
        this.resetTransformations();
        this.clearShaderProgram();
        this.clearBlendFunction();
    }

    @Override
    public Stage createStage(Viewport viewport) {
        return null;
    }

    @Override
    public void drawLineSegment(float x1, float y1, float x2, float y2) {
    }

    @Override
    public void drawRect(float x, float y, float width, float height) {
    }

    @Override
    public void fillRect(float x, float y, float width, float height) {
    }

    @Override
    public void drawCircle(float centerX, float centerY, int radius) {
    }

    @Override
    public void drawCircle(float centerX, float centerY, float radius) {
    }

    @Override
    public void fillCircle(float centerX, float centerY, int radius) {
    }

    @Override
    public void fillCircle(float centerX, float centerY, float radius) {
    }

    @Override
    public void drawTriangle(float x1, float y1, float x2, float y2, float x3, float y3) {
    }

    @Override
    public void fillTriangle(float x1, float y1, float x2, float y2, float x3, float y3) {
    }

    @Override
    public void drawPolygon(float[] vertices) {
    }

    @Override
    public void fillPolygon(float[] vertices, short[] triangles) {
    }

    @Override
    public void drawString(String text, float x, float y) {
    }

    @Override
    public void drawString(String text, float x, float y, float targetWidth) {
    }

    @Override
    public void drawString(String text, float x, float y, float targetWidth, int horizontalAlign) {
    }

    @Override
    public void drawTexture(Texture texture, float x, float y) {
    }

    @Override
    public void drawTexture(Texture texture, float x, float y, boolean flipY) {
    }

    @Override
    public void drawTexture(Texture texture, float x, float y, float width, float height) {
    }

    @Override
    public void drawTexture(Texture texture, float x, float y, float width, float height, boolean flipY) {
    }

    @Override
    public void drawTextureRegion(TextureRegion textureRegion, float x, float y) {
    }

    @Override
    public void drawTextureRegion(TextureRegion textureRegion, float x, float y, float width, float height) {
    }

    @Override
    public void drawTextureRegion(TextureRegion textureRegion, float x, float y, float width, float height, float rotation) {
    }

    @Override
    public void drawShape(Shape shape) {
    }

    @Override
    public void fillShape(Shape shape) {
    }

    @Override
    public void drawSprite(Sprite sprite) {
    }

    @Override
    public void drawSprite(Sprite sprite, float x, float y) {
    }

    @Override
    public void drawSpriteCache(SpriteCache spriteCache, int cacheId) {
    }

    @Override
    public void drawStage(Stage stage) {
    }

    @Override
    public void drawParticleEffect(ParticleEffect effect) {
    }

    @Override
    public void drawNinePatch(NinePatch ninePatch, float x, float y, float width, float height) {
    }

    @Override
    public void drawNinePatch(NinePatchDrawable ninePatchDrawable, float x, float y, float width, float height) {
    }

    @Override
    public void drawTiledDrawable(TiledDrawable tiledDrawable, float x, float y, float width, float height) {
    }

    @Override
    public void drawBitmapFontCache(BitmapFontCache bitmapFontCache) {
    }

    @Override
    public void rotate(float degrees, float x, float y) {
        this.rotation += degrees;
        this.rotation %= 360.0f;
        this.rotationX = x;
        this.rotationY = y;
    }

    @Override
    public void setRotation(float degrees, float x, float y) {
        this.rotation = degrees;
        this.rotation %= 360.0f;
        this.rotationX = x;
        this.rotationY = y;
    }

    @Override
    public void scale(float scaleX, float scaleY) {
        this.scaleX *= scaleX;
        this.scaleY *= scaleY;
    }

    @Override
    public void setScale(float scaleX, float scaleY) {
        this.scaleX = scaleX;
        this.scaleY = scaleY;
    }

    @Override
    public void clearScaling() {
        this.scaleX = 1.0f;
        this.scaleY = 1.0f;
    }

    @Override
    public void translate(float translateX, float translateY) {
        this.translationX += translateX;
        this.translationY += translateY;
    }

    @Override
    public void setTranslation(float translateX, float translateY) {
        this.translationX = translateX;
        this.translationY = translateY;
    }

    @Override
    public void setClip(float x, float y, float width, float height) {
        this.clip = new Rectangle(x, y, width, height);
    }

    @Override
    public void setClip(Rectangle clip) {
        this.clip = clip;
    }

    @Override
    public Rectangle removeClip() {
        Rectangle result = this.clip;
        this.clip = null;
        return result;
    }

    @Override
    public Rectangle peekClip() {
        Rectangle result = new Rectangle();
        this.peekClip(result);
        return result;
    }

    @Override
    public void peekClip(Rectangle rectangle) {
        if (this.clip == null) {
            rectangle.set(0.0f, 0.0f, this.getViewportWidth(), this.getViewportHeight());
        } else {
            rectangle.set(this.clip);
        }
    }

    @Override
    public void setTint(Color tint) {
        this.tint = tint;
    }

    @Override
    public void setFont(BitmapFont font) {
    }

    @Override
    public void removeTint() {
    }

    @Override
    public void enableBlending() {
    }

    @Override
    public void disableBlending() {
    }

    @Override
    public void setShaderProgram(ShaderProgram shaderProgram) {
    }

    @Override
    public ShaderProgram getShaderProgram() {
        return null;
    }

    @Override
    public void clearShaderProgram() {
    }

    @Override
    public void setBlendFunction(int srcFunc, int dstFunc) {
    }

    @Override
    public void clearBlendFunction() {
    }

    @Override
    public void flush() {
    }

    private void resetTransformations() {
        this.translationX = 0.0f;
        this.translationY = 0.0f;
        this.scaleX = 1.0f;
        this.scaleY = 1.0f;
        this.rotation = 0.0f;
        this.rotationX = 0.0f;
        this.rotationY = 0.0f;
    }

    @Override
    public int getLineHeight() {
        return this.lineHeight;
    }

    @Override
    public void setLineHeight(int lineHeight) {
        if (lineHeight > 0) {
            this.lineHeight = lineHeight;
        }
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(Color color) {
        if (color == null) {
            return;
        }
        this.color = color;
    }

    @Override
    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    @Override
    public void setBackgroundColor(Color backgroundColor) {
        if (backgroundColor != null) {
            this.backgroundColor = backgroundColor;
        }
    }

    @Override
    public BitmapFont getFont() {
        return null;
    }

    @Override
    public Color getTint() {
        return this.tint;
    }

    @Override
    public float getScaleX() {
        return this.scaleX;
    }

    @Override
    public float getScaleY() {
        return this.scaleY;
    }

    @Override
    public float getTranslationX() {
        return this.translationX;
    }

    @Override
    public float getTranslationY() {
        return this.translationY;
    }

    @Override
    public float getRotation() {
        return this.rotation;
    }

    @Override
    public float getRotationX() {
        return this.rotationX;
    }

    @Override
    public float getRotationY() {
        return this.rotationY;
    }

    @Override
    public Matrix4 getProjectionMatrix() {
        return this.camera.combined.cpy();
    }

    @Override
    public boolean isWindowReady() {
        return true;
    }

    @Override
    public int getWindowWidth() {
        return this.windowWidth;
    }

    @Override
    public int getWindowHeight() {
        return this.windowHeight;
    }

    @Override
    public float getViewportWidth() {
        return this.camera.viewportWidth;
    }

    @Override
    public float getViewportHeight() {
        return this.camera.viewportHeight;
    }

    public String toString() {
        return "HeadlessLibGdxGraphics [color=" + this.color + ", backgroundColor=" + this.backgroundColor + ", tint=" + this.tint + ", translationX=" + this.translationX + ", translationY=" + this.translationY + ", scaleX=" + this.scaleX + ", scaleY=" + this.scaleY + ", rotation=" + this.rotation + ", rotationX=" + this.rotationX + ", rotationY=" + this.rotationY + ", windowWidth=" + this.windowWidth + ", windowHeight=" + this.windowHeight + ", lineHeight=" + this.lineHeight + "]";
    }
}

