/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.graphics;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.BitmapFontCache;
import com.badlogic.gdx.graphics.g2d.PolygonSpriteBatch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.SpriteCache;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.EarClippingTriangulator;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.utils.NinePatchDrawable;
import com.badlogic.gdx.scenes.scene2d.utils.TiledDrawable;
import com.badlogic.gdx.utils.viewport.Viewport;
import org.mini2Dx.core.game.GameWrapper;
import org.mini2Dx.core.geom.Rectangle;
import org.mini2Dx.core.geom.Shape;
import org.mini2Dx.core.graphics.Graphics;
import org.mini2Dx.core.graphics.NinePatch;
import org.mini2Dx.core.graphics.ParticleEffect;
import org.mini2Dx.core.graphics.ShapeTextureCache;
import org.mini2Dx.core.graphics.Sprite;
import org.mini2Dx.core.graphics.TextureRegion;

public class LibGdxGraphics
implements Graphics {
    private static final String LOGGING_TAG = LibGdxGraphics.class.getSimpleName();
    private final GameWrapper gameWrapper;
    private final SpriteBatch spriteBatch;
    private final ShapeTextureCache colorTextureCache;
    private final ShapeRenderer shapeRenderer;
    private final PolygonSpriteBatch polygonSpriteBatch;
    private final EarClippingTriangulator triangulator = new EarClippingTriangulator();
    private Color color;
    private Color backgroundColor;
    private Color tint;
    private Color defaultTint;
    private OrthographicCamera camera;
    private BitmapFont font;
    private ShaderProgram defaultShader;
    private float translationX;
    private float translationY;
    private float scaleX;
    private float scaleY;
    private float rotation;
    private float rotationX;
    private float rotationY;
    private int windowWidth;
    private int windowHeight;
    private int defaultBlendSrcFunc = 770;
    private int defaultBlendDstFunc = 771;
    private int lineHeight;
    private boolean rendering;
    private boolean renderingShapes;
    private boolean renderingStage;
    private Rectangle clip;
    private float[] triangleVertices = new float[6];
    private float[] polygonRenderData = new float[15];

    public LibGdxGraphics(GameWrapper gameWrapper, SpriteBatch spriteBatch, PolygonSpriteBatch polygonSpriteBatch, ShapeRenderer shapeRenderer) {
        this.gameWrapper = gameWrapper;
        this.spriteBatch = spriteBatch;
        this.shapeRenderer = shapeRenderer;
        this.polygonSpriteBatch = polygonSpriteBatch;
        this.windowWidth = Gdx.graphics.getWidth();
        this.windowHeight = Gdx.graphics.getHeight();
        this.defaultTint = spriteBatch.getColor();
        if (this.defaultTint != null) {
            this.font = new BitmapFont(true);
        }
        this.tint = this.defaultTint;
        this.lineHeight = 1;
        this.color = Color.WHITE;
        this.backgroundColor = Color.BLACK;
        this.colorTextureCache = new ShapeTextureCache();
        this.translationX = 0.0f;
        this.translationY = 0.0f;
        this.scaleX = 1.0f;
        this.scaleY = 1.0f;
        this.rotation = 0.0f;
        this.rotationX = 0.0f;
        this.rotationY = 0.0f;
        this.camera = new OrthographicCamera();
    }

    @Override
    public void preRender(int gameWidth, int gameHeight) {
        this.windowWidth = gameWidth;
        this.windowHeight = gameHeight;
        this.tint = this.defaultTint;
        this.spriteBatch.setColor(this.tint);
        Gdx.gl.glClearColor(this.backgroundColor.r, this.backgroundColor.g, this.backgroundColor.b, 1.0f);
        Gdx.gl.glClear(17408);
        this.rendering = false;
        this.renderingStage = false;
        if (this.defaultShader == null) {
            this.defaultShader = SpriteBatch.createDefaultShader();
        }
    }

    @Override
    public void postRender() {
        this.endRendering();
        this.resetTransformations();
        this.clearShaderProgram();
        this.clearBlendFunction();
    }

    @Override
    public Stage createStage(Viewport viewport) {
        return new Stage(viewport, (Batch)this.spriteBatch);
    }

    @Override
    public void drawLineSegment(float x1, float y1, float x2, float y2) {
        this.beginRendering();
        this.endRendering();
        this.renderingShapes = true;
        this.shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
        Gdx.gl.glEnable(3042);
        Gdx.gl.glBlendFunc(770, 771);
        this.shapeRenderer.setColor(this.color);
        this.shapeRenderer.rectLine(x1, y1, x2, y2, (float)this.lineHeight);
        this.shapeRenderer.end();
        this.beginRendering();
    }

    @Override
    public void drawRect(float x, float y, float width, float height) {
        int roundWidth = MathUtils.round((float)width);
        int roundHeight = MathUtils.round((float)height);
        this.beginRendering();
        this.endRendering();
        this.renderingShapes = true;
        this.shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
        Gdx.gl.glEnable(3042);
        Gdx.gl.glBlendFunc(770, 771);
        this.shapeRenderer.setColor(this.color);
        this.shapeRenderer.rectLine(x, y, x + (float)roundWidth, y, (float)this.lineHeight);
        this.shapeRenderer.rectLine(x, y, x, y + (float)roundHeight, (float)this.lineHeight);
        this.shapeRenderer.rectLine(x + (float)roundWidth, y, x + (float)roundWidth, y + (float)roundHeight, (float)this.lineHeight);
        this.shapeRenderer.rectLine(x, y + (float)roundHeight, x + (float)roundWidth, y + (float)roundHeight, (float)this.lineHeight);
        this.shapeRenderer.end();
        this.beginRendering();
    }

    @Override
    public void fillRect(float x, float y, float width, float height) {
        this.beginRendering();
        this.spriteBatch.draw(this.colorTextureCache.getFilledRectangleTexture(this.color), x, y, 0.0f, 0.0f, width, height, 1.0f, 1.0f, 0.0f, 0, 0, 1, 1, false, false);
    }

    @Override
    public void drawCircle(float centerX, float centerY, int radius) {
        this.beginRendering();
        this.endRendering();
        this.renderingShapes = true;
        this.shapeRenderer.begin(ShapeRenderer.ShapeType.Line);
        Gdx.gl.glEnable(3042);
        Gdx.gl.glBlendFunc(770, 771);
        this.shapeRenderer.setColor(this.color);
        this.shapeRenderer.circle(centerX, centerY, (float)radius);
        this.shapeRenderer.end();
    }

    @Override
    public void drawCircle(float centerX, float centerY, float radius) {
        this.drawCircle(centerX, centerY, MathUtils.round((float)radius));
    }

    @Override
    public void fillCircle(float centerX, float centerY, int radius) {
        this.beginRendering();
        this.endRendering();
        this.renderingShapes = true;
        this.shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
        Gdx.gl.glEnable(3042);
        Gdx.gl.glBlendFunc(770, 771);
        this.shapeRenderer.setColor(this.color);
        this.shapeRenderer.circle(centerX, centerY, (float)radius);
        this.shapeRenderer.end();
        this.beginRendering();
    }

    @Override
    public void fillCircle(float centerX, float centerY, float radius) {
        this.fillCircle(centerX, centerY, MathUtils.round((float)radius));
    }

    @Override
    public void drawTriangle(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.triangleVertices[0] = x1;
        this.triangleVertices[1] = y1;
        this.triangleVertices[2] = x2;
        this.triangleVertices[3] = y2;
        this.triangleVertices[4] = x3;
        this.triangleVertices[5] = y3;
        this.drawPolygon(this.triangleVertices);
    }

    @Override
    public void fillTriangle(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.triangleVertices[0] = x1;
        this.triangleVertices[1] = y1;
        this.triangleVertices[2] = x2;
        this.triangleVertices[3] = y2;
        this.triangleVertices[4] = x3;
        this.triangleVertices[5] = y3;
        this.fillPolygon(this.triangleVertices, this.triangulator.computeTriangles((float[])this.triangleVertices).items);
    }

    @Override
    public void drawPolygon(float[] vertices) {
        this.beginRendering();
        this.endRendering();
        this.renderingShapes = true;
        this.shapeRenderer.begin(ShapeRenderer.ShapeType.Line);
        Gdx.gl.glEnable(3042);
        Gdx.gl.glBlendFunc(770, 771);
        this.shapeRenderer.setColor(this.color);
        this.shapeRenderer.polygon(vertices);
        this.shapeRenderer.end();
        this.beginRendering();
    }

    @Override
    public void fillPolygon(float[] vertices, short[] triangles) {
        this.beginRendering();
        this.endRendering();
        this.renderingShapes = true;
        if (vertices.length * 5 > this.polygonRenderData.length) {
            this.polygonRenderData = new float[vertices.length * 5];
        }
        int totalPoints = vertices.length / 2;
        for (int i = 0; i < totalPoints; ++i) {
            int verticesIndex = i * 2;
            int renderIndex = i * 5;
            this.polygonRenderData[renderIndex] = vertices[verticesIndex];
            this.polygonRenderData[renderIndex + 1] = vertices[verticesIndex + 1];
            this.polygonRenderData[renderIndex + 2] = this.color.toFloatBits();
            this.polygonRenderData[renderIndex + 3] = vertices[verticesIndex];
            this.polygonRenderData[renderIndex + 4] = vertices[verticesIndex + 1];
        }
        this.polygonSpriteBatch.begin();
        this.polygonSpriteBatch.draw(this.colorTextureCache.getFilledRectangleTexture(this.color), this.polygonRenderData, 0, vertices.length * 5, triangles, 0, triangles.length);
        this.polygonSpriteBatch.end();
        this.beginRendering();
    }

    @Override
    public void drawString(String text, float x, float y) {
        if (this.font == null) {
            return;
        }
        this.beginRendering();
        this.font.setColor(this.color);
        this.font.draw((Batch)this.spriteBatch, (CharSequence)text, x, y);
    }

    @Override
    public void drawString(String text, float x, float y, float targetWidth) {
        this.drawString(text, x, y, targetWidth, 8);
    }

    @Override
    public void drawString(String text, float x, float y, float targetWidth, int horizontalAlign) {
        if (this.font == null) {
            return;
        }
        this.beginRendering();
        this.font.setColor(this.color);
        this.font.draw((Batch)this.spriteBatch, (CharSequence)text, x, y, targetWidth, horizontalAlign, true);
    }

    @Override
    public void drawTexture(Texture texture, float x, float y) {
        this.drawTexture(texture, x, y, texture.getWidth(), texture.getHeight());
    }

    @Override
    public void drawTexture(Texture texture, float x, float y, boolean flipY) {
        this.drawTexture(texture, x, y, texture.getWidth(), texture.getHeight(), flipY);
    }

    @Override
    public void drawTexture(Texture texture, float x, float y, float width, float height) {
        this.drawTexture(texture, x, y, width, height, true);
    }

    @Override
    public void drawTexture(Texture texture, float x, float y, float width, float height, boolean flipY) {
        this.beginRendering();
        this.spriteBatch.draw(texture, x, y, 0.0f, 0.0f, width, height, 1.0f, 1.0f, 0.0f, 0, 0, texture.getWidth(), texture.getHeight(), false, flipY);
    }

    @Override
    public void drawTextureRegion(TextureRegion textureRegion, float x, float y) {
        this.drawTextureRegion(textureRegion, x, y, textureRegion.getRegionWidth(), textureRegion.getRegionHeight());
    }

    @Override
    public void drawTextureRegion(TextureRegion textureRegion, float x, float y, float width, float height) {
        this.drawTextureRegion(textureRegion, x, y, width, height, 0.0f);
    }

    @Override
    public void drawTextureRegion(TextureRegion textureRegion, float x, float y, float width, float height, float rotation) {
        this.beginRendering();
        this.spriteBatch.draw((com.badlogic.gdx.graphics.g2d.TextureRegion)textureRegion, x, y, 0.0f, 0.0f, width, height, 1.0f, 1.0f, rotation);
    }

    @Override
    public void drawShape(Shape shape) {
        shape.draw(this);
    }

    @Override
    public void fillShape(Shape shape) {
        shape.fill(this);
    }

    @Override
    public void drawSprite(Sprite sprite) {
        this.beginRendering();
        sprite.draw((Batch)this.spriteBatch);
    }

    @Override
    public void drawSprite(Sprite sprite, float x, float y) {
        this.beginRendering();
        float oldX = sprite.getX();
        float oldY = sprite.getY();
        Color oldTint = sprite.getColor();
        if (this.tint != null) {
            sprite.setColor(this.tint);
        }
        sprite.setPosition(x, y);
        sprite.draw((Batch)this.spriteBatch);
        sprite.setPosition(oldX, oldY);
        sprite.setColor(oldTint);
    }

    @Override
    public void drawSpriteCache(SpriteCache spriteCache, int cacheId) {
        this.beginRendering();
        spriteCache.getProjectionMatrix().set(this.spriteBatch.getProjectionMatrix().cpy());
        spriteCache.getTransformMatrix().set(this.spriteBatch.getTransformMatrix().cpy());
        Gdx.gl.glEnable(3042);
        spriteCache.begin();
        spriteCache.draw(cacheId);
        spriteCache.end();
    }

    @Override
    public void drawStage(Stage stage) {
        this.endRendering();
        Camera stageCamera = stage.getViewport().getCamera();
        stageCamera.up.set(0.0f, -1.0f, 0.0f);
        stageCamera.direction.set(0.0f, 0.0f, 1.0f);
        stageCamera.update();
        if (!stage.getRoot().isVisible()) {
            return;
        }
        this.renderingStage = true;
        this.beginRendering();
        this.spriteBatch.setProjectionMatrix(stageCamera.combined);
        this.polygonSpriteBatch.setProjectionMatrix(stageCamera.combined);
        this.shapeRenderer.setProjectionMatrix(stageCamera.combined);
        this.spriteBatch.begin();
        stage.getRoot().draw((Batch)this.spriteBatch, 1.0f);
        this.spriteBatch.end();
        this.endRendering();
        this.renderingStage = false;
    }

    @Override
    public void drawParticleEffect(ParticleEffect effect) {
        this.beginRendering();
        effect.render(this.spriteBatch);
    }

    @Override
    public void drawNinePatch(NinePatch ninePatch, float x, float y, float width, float height) {
        this.beginRendering();
        ninePatch.draw((Batch)this.spriteBatch, x, y, width, height);
    }

    @Override
    public void drawNinePatch(NinePatchDrawable ninePatchDrawable, float x, float y, float width, float height) {
        this.beginRendering();
        ninePatchDrawable.draw((Batch)this.spriteBatch, x, y, width, height);
    }

    @Override
    public void drawTiledDrawable(TiledDrawable tiledDrawable, float x, float y, float width, float height) {
        this.beginRendering();
        tiledDrawable.draw((Batch)this.spriteBatch, x, y, width, height);
    }

    @Override
    public void drawBitmapFontCache(BitmapFontCache bitmapFontCache) {
        this.beginRendering();
        bitmapFontCache.draw((Batch)this.spriteBatch);
    }

    @Override
    public void rotate(float degrees, float x, float y) {
        if (this.rendering) {
            this.endRendering();
        }
        this.rotation += degrees;
        this.rotation %= 360.0f;
        this.rotationX = x;
        this.rotationY = y;
    }

    @Override
    public void setRotation(float degrees, float x, float y) {
        if (this.rendering) {
            this.endRendering();
        }
        this.rotation = degrees;
        this.rotation %= 360.0f;
        this.rotationX = x;
        this.rotationY = y;
    }

    @Override
    public void scale(float scaleX, float scaleY) {
        if (this.rendering) {
            this.endRendering();
        }
        this.scaleX *= scaleX;
        this.scaleY *= scaleY;
    }

    @Override
    public void setScale(float scaleX, float scaleY) {
        if (this.rendering) {
            this.endRendering();
        }
        this.scaleX = scaleX;
        this.scaleY = scaleY;
    }

    @Override
    public void clearScaling() {
        if (this.rendering) {
            this.endRendering();
        }
        this.scaleX = 1.0f;
        this.scaleY = 1.0f;
    }

    @Override
    public void translate(float translateX, float translateY) {
        if (this.rendering) {
            this.endRendering();
        }
        this.translationX += translateX;
        this.translationY += translateY;
    }

    @Override
    public void setTranslation(float translateX, float translateY) {
        if (this.rendering) {
            this.endRendering();
        }
        this.translationX = translateX;
        this.translationY = translateY;
    }

    @Override
    public void setClip(float x, float y, float width, float height) {
        if (this.rendering) {
            this.endRendering();
        }
        if (MathUtils.isEqual((float)0.0f, (float)x) && MathUtils.isEqual((float)0.0f, (float)y) && MathUtils.isEqual((float)this.getViewportWidth(), (float)width) && MathUtils.isEqual((float)this.getViewportHeight(), (float)height)) {
            this.clip = null;
        } else if (this.clip == null) {
            this.clip = new Rectangle(x, y, width, height);
        } else {
            this.clip.set(x, y, width, height);
        }
    }

    @Override
    public void setClip(Rectangle clip) {
        this.setClip(clip.getX(), clip.getY(), clip.getWidth(), clip.getHeight());
    }

    @Override
    public Rectangle removeClip() {
        if (this.rendering) {
            this.endRendering();
        }
        Rectangle result = this.clip;
        this.clip = null;
        return result;
    }

    @Override
    public Rectangle peekClip() {
        Rectangle result = new Rectangle();
        this.peekClip(result);
        return result;
    }

    @Override
    public void peekClip(Rectangle rectangle) {
        if (this.clip == null) {
            rectangle.set(0.0f, 0.0f, this.getViewportWidth(), this.getViewportHeight());
        } else {
            rectangle.set(this.clip);
        }
    }

    @Override
    public void setTint(Color tint) {
        if (this.rendering) {
            this.endRendering();
        }
        this.tint = tint;
        this.spriteBatch.setColor(tint);
    }

    @Override
    public void setFont(BitmapFont font) {
        if (font != null) {
            if (this.rendering) {
                this.endRendering();
            }
            this.font = font;
        }
    }

    @Override
    public void removeTint() {
        this.setTint(this.defaultTint);
    }

    @Override
    public void enableBlending() {
        this.spriteBatch.enableBlending();
    }

    @Override
    public void disableBlending() {
        this.spriteBatch.disableBlending();
    }

    @Override
    public void setShaderProgram(ShaderProgram shaderProgram) {
        this.spriteBatch.setShader(shaderProgram);
    }

    @Override
    public ShaderProgram getShaderProgram() {
        return this.spriteBatch.getShader();
    }

    @Override
    public void clearShaderProgram() {
        this.spriteBatch.setShader(this.defaultShader);
    }

    @Override
    public void setBlendFunction(int srcFunc, int dstFunc) {
        this.spriteBatch.setBlendFunction(srcFunc, dstFunc);
    }

    @Override
    public void clearBlendFunction() {
        this.spriteBatch.setBlendFunction(this.defaultBlendSrcFunc, this.defaultBlendDstFunc);
    }

    @Override
    public void flush() {
        this.spriteBatch.flush();
    }

    private void beginRendering() {
        if (!this.rendering) {
            if (!this.renderingStage) {
                this.applyTransformations();
                Gdx.gl.glClearDepthf(1.0f);
                Gdx.gl.glClear(256);
                if (this.clip != null) {
                    Gdx.gl.glDepthFunc(513);
                    Gdx.gl.glEnable(2929);
                    Gdx.gl.glDepthMask(true);
                    Gdx.gl.glColorMask(false, false, false, false);
                    this.shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
                    this.shapeRenderer.setColor(0.0f, 1.0f, 0.0f, 0.5f);
                    this.shapeRenderer.rect(this.clip.getX(), this.clip.getY(), this.clip.getWidth(), this.clip.getHeight());
                    this.shapeRenderer.end();
                    this.spriteBatch.begin();
                    Gdx.gl.glColorMask(true, true, true, true);
                    Gdx.gl.glEnable(2929);
                    Gdx.gl.glDepthFunc(514);
                } else {
                    this.spriteBatch.begin();
                }
            }
            this.rendering = true;
        }
    }

    private void endRendering() {
        if (this.rendering && !this.renderingStage) {
            this.undoTransformations();
            this.spriteBatch.end();
            if (this.renderingShapes) {
                this.shapeRenderer.end();
            }
            if (this.clip != null) {
                Gdx.gl.glClearDepthf(1.0f);
                Gdx.gl.glClear(256);
                Gdx.gl.glDisable(2929);
            }
        }
        this.rendering = false;
        this.renderingShapes = false;
    }

    private void applyTransformations() {
        float viewportWidth = MathUtils.round((float)((float)this.windowWidth / this.scaleX));
        float viewportHeight = MathUtils.round((float)((float)this.windowHeight / this.scaleY));
        this.camera.setToOrtho(true, viewportWidth, viewportHeight);
        if (this.translationX != 0.0f || this.translationY != 0.0f) {
            this.camera.translate(this.translationX, this.translationY);
        }
        this.camera.update();
        if (this.rotation != 0.0f) {
            this.camera.rotateAround(new Vector3(this.rotationX, this.rotationY, 0.0f), new Vector3(0.0f, 0.0f, 1.0f), -this.rotation);
        }
        this.camera.update();
        this.spriteBatch.setProjectionMatrix(this.camera.combined);
        this.shapeRenderer.setProjectionMatrix(this.camera.combined);
        this.polygonSpriteBatch.setProjectionMatrix(this.camera.combined);
    }

    private void undoTransformations() {
        if (this.rotation != 0.0f) {
            this.camera.rotateAround(new Vector3(this.rotationX, this.rotationY, 0.0f), new Vector3(0.0f, 0.0f, 1.0f), this.rotation);
        }
        this.camera.update();
        if (this.translationX != 0.0f || this.translationY != 0.0f) {
            this.camera.translate(-this.translationX, -this.translationY);
        }
        this.camera.update();
    }

    private void resetTransformations() {
        this.translationX = 0.0f;
        this.translationY = 0.0f;
        this.scaleX = 1.0f;
        this.scaleY = 1.0f;
        this.rotation = 0.0f;
        this.rotationX = 0.0f;
        this.rotationY = 0.0f;
    }

    @Override
    public int getLineHeight() {
        return this.lineHeight;
    }

    @Override
    public void setLineHeight(int lineHeight) {
        if (lineHeight > 0) {
            this.lineHeight = lineHeight;
        }
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(Color color) {
        if (color == null) {
            return;
        }
        this.color = color;
    }

    @Override
    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    @Override
    public void setBackgroundColor(Color backgroundColor) {
        if (backgroundColor != null) {
            this.backgroundColor = backgroundColor;
        }
    }

    @Override
    public BitmapFont getFont() {
        return this.font;
    }

    @Override
    public Color getTint() {
        return this.tint;
    }

    @Override
    public float getScaleX() {
        return this.scaleX;
    }

    @Override
    public float getScaleY() {
        return this.scaleY;
    }

    @Override
    public float getTranslationX() {
        return this.translationX;
    }

    @Override
    public float getTranslationY() {
        return this.translationY;
    }

    @Override
    public float getRotation() {
        return this.rotation;
    }

    @Override
    public float getRotationX() {
        return this.rotationX;
    }

    @Override
    public float getRotationY() {
        return this.rotationY;
    }

    @Override
    public Matrix4 getProjectionMatrix() {
        return this.camera.combined.cpy();
    }

    @Override
    public boolean isWindowReady() {
        return this.gameWrapper.isGameWindowReady();
    }

    @Override
    public int getWindowWidth() {
        return this.windowWidth;
    }

    @Override
    public int getWindowHeight() {
        return this.windowHeight;
    }

    @Override
    public float getViewportWidth() {
        return this.camera.viewportWidth;
    }

    @Override
    public float getViewportHeight() {
        return this.camera.viewportHeight;
    }

    public String toString() {
        return "LibGdxGraphics [color=" + this.color + ", backgroundColor=" + this.backgroundColor + ", tint=" + this.tint + ", translationX=" + this.translationX + ", translationY=" + this.translationY + ", scaleX=" + this.scaleX + ", scaleY=" + this.scaleY + ", rotation=" + this.rotation + ", rotationX=" + this.rotationX + ", rotationY=" + this.rotationY + ", windowWidth=" + this.windowWidth + ", windowHeight=" + this.windowHeight + ", lineHeight=" + this.lineHeight + "]";
    }
}

