/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.graphics;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.utils.TiledDrawable;
import org.mini2Dx.core.graphics.NinePatch;
import org.mini2Dx.core.graphics.TextureRegion;

public class RepeatedNinePatch
extends NinePatch {
    private TiledDrawable topCenter;
    private TiledDrawable middleLeft;
    private TiledDrawable middleCenter;
    private TiledDrawable middleRight;
    private TiledDrawable bottomCenter;

    public RepeatedNinePatch(Texture texture, int left, int right, int top, int bottom) {
        super(texture, left, right, top, bottom);
        this.loadTiledDrawables();
    }

    public RepeatedNinePatch(TextureRegion region, int left, int right, int top, int bottom) {
        super(region, left, right, top, bottom);
        this.loadTiledDrawables();
    }

    public RepeatedNinePatch(NinePatch ninePatch) {
        this(ninePatch, ninePatch.color);
    }

    public RepeatedNinePatch(NinePatch ninePatch, Color color) {
        super(ninePatch, color);
        this.loadTiledDrawables();
    }

    private void loadTiledDrawables() {
        if (this.patches[1] != null) {
            this.topCenter = new TiledDrawable((com.badlogic.gdx.graphics.g2d.TextureRegion)this.patches[1]);
        }
        if (this.patches[3] != null) {
            this.middleLeft = new TiledDrawable((com.badlogic.gdx.graphics.g2d.TextureRegion)this.patches[3]);
        }
        if (this.patches[4] != null) {
            this.middleCenter = new TiledDrawable((com.badlogic.gdx.graphics.g2d.TextureRegion)this.patches[4]);
        }
        if (this.patches[5] != null) {
            this.middleRight = new TiledDrawable((com.badlogic.gdx.graphics.g2d.TextureRegion)this.patches[5]);
        }
        if (this.patches[7] != null) {
            this.bottomCenter = new TiledDrawable((com.badlogic.gdx.graphics.g2d.TextureRegion)this.patches[7]);
        }
    }

    @Override
    void draw(Batch batch, float x, float y, float width, float height) {
        if (this.patches[2] == null) {
            float halfWidth = width * 0.5f;
            float leftWidth = this.patches[0].getRegionWidth();
            float centerWidth = this.patches[1].getRegionWidth();
            float totalMiddleHeight = height - (float)this.patches[0].getRegionHeight() - (float)this.patches[6].getRegionHeight();
            this.patches[0].flip(false, true);
            batch.draw((com.badlogic.gdx.graphics.g2d.TextureRegion)this.patches[0], x, y, leftWidth, (float)this.patches[0].getRegionHeight());
            this.patches[0].flip(false, true);
            this.patches[1].flip(false, true);
            batch.draw((com.badlogic.gdx.graphics.g2d.TextureRegion)this.patches[1], x + leftWidth, y, centerWidth, (float)this.patches[1].getRegionHeight());
            this.patches[1].flip(false, true);
            this.middleLeft.draw(batch, x, y + (float)this.patches[0].getRegionHeight(), leftWidth, totalMiddleHeight);
            this.middleCenter.draw(batch, x + leftWidth, y + (float)this.patches[0].getRegionHeight(), centerWidth, totalMiddleHeight);
            this.patches[6].flip(false, true);
            batch.draw((com.badlogic.gdx.graphics.g2d.TextureRegion)this.patches[6], x, y + (float)this.patches[0].getRegionHeight() + totalMiddleHeight, leftWidth, (float)this.patches[6].getRegionHeight());
            this.patches[6].flip(false, true);
            this.patches[7].flip(false, true);
            batch.draw((com.badlogic.gdx.graphics.g2d.TextureRegion)this.patches[7], x + leftWidth, y + (float)this.patches[0].getRegionHeight() + totalMiddleHeight, centerWidth, (float)this.patches[7].getRegionHeight());
            this.patches[7].flip(false, true);
        } else if (this.patches[6] == null) {
            float halfHeight = height * 0.5f;
            float topHeight = this.patches[0].getRegionHeight();
            float middleHeight = this.patches[3].getRegionHeight();
            float totalCenterWidth = width - (float)this.patches[0].getRegionWidth() - (float)this.patches[2].getRegionWidth();
            this.patches[0].flip(false, true);
            batch.draw((com.badlogic.gdx.graphics.g2d.TextureRegion)this.patches[0], x, y, (float)this.patches[0].getRegionWidth(), topHeight);
            this.patches[0].flip(false, true);
            this.patches[3].flip(false, true);
            batch.draw((com.badlogic.gdx.graphics.g2d.TextureRegion)this.patches[3], x, y + topHeight, (float)this.patches[3].getRegionWidth(), middleHeight);
            this.patches[3].flip(false, true);
            this.topCenter.draw(batch, x + (float)this.patches[0].getRegionWidth(), y, totalCenterWidth, topHeight);
            this.middleCenter.draw(batch, x + (float)this.patches[3].getRegionWidth(), y + topHeight, totalCenterWidth, middleHeight);
            this.patches[2].flip(false, true);
            batch.draw((com.badlogic.gdx.graphics.g2d.TextureRegion)this.patches[2], x + (float)this.patches[0].getRegionWidth() + totalCenterWidth, y, (float)this.patches[2].getRegionWidth(), topHeight);
            this.patches[2].flip(false, true);
            this.patches[5].flip(false, true);
            batch.draw((com.badlogic.gdx.graphics.g2d.TextureRegion)this.patches[5], x + (float)this.patches[3].getRegionWidth() + totalCenterWidth, y, (float)this.patches[5].getRegionWidth(), topHeight);
            this.patches[5].flip(false, true);
        } else {
            float totalCenterWidth = width - (float)this.patches[0].getRegionWidth() - (float)this.patches[2].getRegionWidth();
            float totalMiddleHeight = height - (float)this.patches[0].getRegionHeight() - (float)this.patches[6].getRegionHeight();
            this.middleCenter.draw(batch, x + (float)this.patches[0].getRegionWidth(), y + (float)this.patches[6].getRegionHeight(), totalCenterWidth, totalMiddleHeight);
            this.topCenter.draw(batch, x + (float)this.patches[0].getRegionWidth(), y + (float)this.patches[6].getRegionHeight() + totalMiddleHeight, totalCenterWidth, (float)this.patches[7].getRegionHeight());
            this.bottomCenter.draw(batch, x + (float)this.patches[0].getRegionWidth(), y, totalCenterWidth, (float)this.patches[1].getRegionHeight());
            this.middleLeft.draw(batch, x, y + (float)this.patches[6].getRegionHeight(), (float)this.patches[3].getRegionWidth(), totalMiddleHeight);
            this.middleRight.draw(batch, x + (float)this.patches[3].getRegionWidth() + totalCenterWidth, y + (float)this.patches[6].getRegionHeight(), (float)this.patches[3].getRegionWidth(), totalMiddleHeight);
            batch.draw((com.badlogic.gdx.graphics.g2d.TextureRegion)this.patches[0], x, y + (float)this.patches[6].getRegionHeight() + totalMiddleHeight);
            batch.draw((com.badlogic.gdx.graphics.g2d.TextureRegion)this.patches[2], x + (float)this.patches[0].getRegionWidth() + totalCenterWidth, y + (float)this.patches[6].getRegionHeight() + totalMiddleHeight);
            batch.draw((com.badlogic.gdx.graphics.g2d.TextureRegion)this.patches[6], x, y);
            batch.draw((com.badlogic.gdx.graphics.g2d.TextureRegion)this.patches[8], x + (float)this.patches[0].getRegionWidth() + totalCenterWidth, y);
        }
    }
}

