/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.graphics;

import com.badlogic.gdx.graphics.Texture;
import org.mini2Dx.core.graphics.TextureRegion;

public class Sprite
extends com.badlogic.gdx.graphics.g2d.Sprite {
    public Sprite() {
    }

    public Sprite(Texture texture) {
        this(texture, texture.getWidth(), texture.getHeight());
    }

    public Sprite(Texture texture, int srcWidth, int srcHeight) {
        this(texture, 0, 0, srcWidth, srcHeight);
    }

    public Sprite(Texture texture, int srcX, int srcY, int srcWidth, int srcHeight) {
        super(texture, srcX, srcY, srcWidth, srcHeight);
        this.flip(false, true);
    }

    public Sprite(TextureRegion region) {
        super((com.badlogic.gdx.graphics.g2d.TextureRegion)region);
        this.setFlip(region.isFlipX(), region.isFlipY());
    }

    public Sprite(TextureRegion region, int srcX, int srcY, int srcWidth, int srcHeight) {
        super((com.badlogic.gdx.graphics.g2d.TextureRegion)region, srcX, srcY, srcWidth, srcHeight);
        this.setFlip(region.isFlipX(), region.isFlipY());
    }

    public Sprite(Sprite sprite) {
        super((com.badlogic.gdx.graphics.g2d.Sprite)sprite);
    }

    public float getAlpha() {
        return this.getColor().a;
    }

    public boolean isFlipY() {
        return !super.isFlipY();
    }

    public int getRegionY() {
        this.setFlipY(!this.isFlipY());
        int result = super.getRegionY();
        this.setFlipY(!this.isFlipY());
        return result;
    }

    public void setFlip(boolean x, boolean y) {
        boolean performX = false;
        boolean performY = false;
        if (this.isFlipX() != x) {
            performX = true;
        }
        if (this.isFlipY() != y) {
            performY = true;
        }
        this.flip(performX, performY);
    }

    public void setFlipX(boolean flipX) {
        if (flipX == this.isFlipX()) {
            return;
        }
        this.flip(true, false);
    }

    public void setFlipY(boolean flipY) {
        if (flipY == this.isFlipY()) {
            return;
        }
        this.flip(false, true);
    }
}

