/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.graphics;

import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;

public class TextureRegion
extends com.badlogic.gdx.graphics.g2d.TextureRegion {
    public TextureRegion() {
    }

    public TextureRegion(Texture texture) {
        super(texture);
        this.flip(false, true);
    }

    public TextureRegion(Texture texture, int width, int height) {
        super(texture, width, height);
        this.flip(false, true);
    }

    public TextureRegion(Texture texture, int x, int y, int width, int height) {
        super(texture, x, y, width, height);
        this.flip(false, true);
    }

    public TextureRegion(Texture texture, float u, float v, float u2, float v2) {
        super(texture, u, v, u2, v2);
        this.flip(false, true);
    }

    public TextureRegion(TextureRegion region) {
        super((com.badlogic.gdx.graphics.g2d.TextureRegion)region);
    }

    public TextureRegion(TextureRegion region, int x, int y, int width, int height) {
        super((com.badlogic.gdx.graphics.g2d.TextureRegion)region, x, y, width, height);
        this.flip(false, true);
    }

    public TextureRegion(TextureAtlas.AtlasRegion atlasRegion) {
        super((com.badlogic.gdx.graphics.g2d.TextureRegion)atlasRegion);
        this.flip(false, true);
    }

    public boolean isFlipY() {
        return !super.isFlipY();
    }

    public int getRegionY() {
        this.setFlipY(!this.isFlipY());
        int result = super.getRegionY();
        this.setFlipY(!this.isFlipY());
        return result;
    }

    public void setFlip(boolean flipX, boolean flipY) {
        this.setFlipX(flipX);
        this.setFlipY(flipY);
    }

    public void setFlipX(boolean flipX) {
        if (flipX == this.isFlipX()) {
            return;
        }
        this.flip(true, false);
    }

    public void setFlipY(boolean flipY) {
        if (flipY == this.isFlipY()) {
            return;
        }
        this.flip(false, true);
    }

    public Pixmap toPixmap() {
        Texture texture = this.getTexture();
        if (!texture.getTextureData().isPrepared()) {
            texture.getTextureData().prepare();
        }
        Pixmap texturePixmap = texture.getTextureData().consumePixmap();
        Pixmap result = new Pixmap(this.getRegionWidth(), this.getRegionHeight(), Pixmap.Format.RGBA8888);
        result.drawPixmap(texturePixmap, 0, 0, this.getRegionX(), this.getRegionY(), this.getRegionWidth(), this.getRegionHeight());
        return result;
    }
}

