/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.graphics.pipeline;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import org.mini2Dx.core.game.GameContainer;
import org.mini2Dx.core.graphics.Graphics;
import org.mini2Dx.core.graphics.pipeline.RenderOperation;
import org.mini2Dx.core.util.Ref;

public class RenderFrameBufferOperation
implements RenderOperation {
    private final Ref<FrameBuffer> frameBufferRef;
    private final Vector2 renderPosition = new Vector2();
    private FrameBuffer frameBuffer;
    private Texture.TextureFilter minFilter = Texture.TextureFilter.Nearest;
    private Texture.TextureFilter magFilter = Texture.TextureFilter.Nearest;
    private int renderX;
    private int renderY;

    public RenderFrameBufferOperation(Ref<FrameBuffer> frameBufferRef) {
        this.frameBufferRef = frameBufferRef;
    }

    public void updateRenderPosition(Vector2 position, GameContainer gc, float delta) {
    }

    @Override
    public void update(GameContainer gc, float delta) {
        this.updateRenderPosition(this.renderPosition, gc, delta);
        this.frameBuffer = this.frameBufferRef.get();
        this.renderX = MathUtils.round((float)this.renderPosition.x);
        this.renderY = MathUtils.round((float)this.renderPosition.y);
    }

    @Override
    public void interpolate(GameContainer gc, float alpha) {
    }

    @Override
    public void apply(GameContainer gc, Graphics g) {
        if (this.frameBuffer == null) {
            return;
        }
        Texture texture = (Texture)this.frameBuffer.getColorBufferTexture();
        texture.setFilter(this.minFilter, this.magFilter);
        g.drawTexture(texture, this.renderX, this.renderY);
    }

    @Override
    public void unapply(GameContainer gc, Graphics g) {
    }

    public Texture.TextureFilter getMinFilter() {
        return this.minFilter;
    }

    public void setMinFilter(Texture.TextureFilter minFilter) {
        if (minFilter == null) {
            return;
        }
        this.minFilter = minFilter;
    }

    public Texture.TextureFilter getMagFilter() {
        return this.magFilter;
    }

    public void setMagFilter(Texture.TextureFilter magFilter) {
        if (magFilter == null) {
            return;
        }
        this.magFilter = magFilter;
    }
}

