/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.graphics.pipeline;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import org.mini2Dx.core.game.GameContainer;
import org.mini2Dx.core.graphics.Graphics;
import org.mini2Dx.core.graphics.pipeline.RenderOperation;

public class ShaderProgramOperation
implements RenderOperation {
    private static final String LOGGING_TAG = ShaderProgramOperation.class.getSimpleName();
    protected final ShaderProgram shaderProgram;
    private ShaderProgram previousProgram;

    public ShaderProgramOperation(FileHandle vertexShader, FileHandle fragmentShader) {
        this(new ShaderProgram(vertexShader, fragmentShader));
    }

    public ShaderProgramOperation(ShaderProgram shaderProgram) {
        this.shaderProgram = shaderProgram;
        if (!shaderProgram.isCompiled()) {
            Gdx.app.error(LOGGING_TAG, shaderProgram.getLog());
        }
    }

    @Override
    public void update(GameContainer gc, float delta) {
    }

    @Override
    public void interpolate(GameContainer gc, float alpha) {
    }

    @Override
    public void apply(GameContainer gc, Graphics g) {
        this.previousProgram = g.getShaderProgram();
        g.setShaderProgram(this.shaderProgram);
    }

    @Override
    public void unapply(GameContainer gc, Graphics g) {
        g.setShaderProgram(this.previousProgram);
    }
}

