/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.graphics.pipeline;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import org.mini2Dx.core.game.GameContainer;
import org.mini2Dx.core.graphics.Graphics;
import org.mini2Dx.core.graphics.pipeline.RenderOperation;

public abstract class TranslateOperation
implements RenderOperation {
    private final Vector2 translation = new Vector2();
    private int translateX;
    private int translateY;

    public abstract void updateTranslation(Vector2 var1, GameContainer var2, float var3);

    @Override
    public void update(GameContainer gc, float delta) {
        this.updateTranslation(this.translation, gc, delta);
        this.translateX = MathUtils.round((float)this.translation.x);
        this.translateY = MathUtils.round((float)this.translation.y);
    }

    @Override
    public void interpolate(GameContainer gc, float alpha) {
    }

    @Override
    public void apply(GameContainer gc, Graphics g) {
        g.translate(this.translateX, this.translateY);
    }

    @Override
    public void unapply(GameContainer gc, Graphics g) {
        g.translate(-this.translateX, -this.translateY);
    }
}

