/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.graphics.viewport;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import org.mini2Dx.core.graphics.viewport.Viewport;
import org.mini2Dx.core.util.Scaling;

public class ScalingViewport
extends Viewport {
    private final Scaling scaling;
    private final float worldWidth;
    private final float worldHeight;
    private final Vector2 size = new Vector2();
    private final Vector2 scale = new Vector2();
    private boolean powerOfTwo;

    public ScalingViewport(Scaling scaling, boolean powerOfTwo, float worldWidth, float worldHeight) {
        this.scaling = scaling;
        this.powerOfTwo = powerOfTwo;
        this.worldWidth = worldWidth;
        this.worldHeight = worldHeight;
    }

    @Override
    public void onResize(int width, int height) {
        this.scaling.apply(this.size, this.scale, this.powerOfTwo, this.worldWidth, this.worldHeight, width, height);
        int viewWidth = MathUtils.round((float)this.size.x);
        int viewHeight = MathUtils.round((float)this.size.y);
        this.setBounds((width - viewWidth) / MathUtils.round((float)(2.0f * this.scale.x)), (height - viewHeight) / MathUtils.round((float)(2.0f * this.scale.y)), MathUtils.round((float)this.worldWidth), MathUtils.round((float)this.worldHeight), this.scale.x, this.scale.y);
    }

    public boolean isPowerOfTwo() {
        return this.powerOfTwo;
    }

    public void setPowerOfTwo(boolean powerOfTwo) {
        this.powerOfTwo = powerOfTwo;
    }
}

