/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.graphics.viewport;

import com.badlogic.gdx.math.Vector2;
import org.mini2Dx.core.geom.Rectangle;
import org.mini2Dx.core.graphics.Graphics;

public abstract class Viewport {
    private int x;
    private int y;
    private int width;
    private int height;
    private float scaleX;
    private float invScaleX;
    private float scaleY;
    private float invScaleY;
    private int previousWindowWidth;
    private int previousWindowHeight;
    private float previousScaleX;
    private float previousScaleY;
    private float previousTranslateX;
    private float previousTranslateY;
    private final Rectangle previousClip = new Rectangle();

    protected abstract void onResize(int var1, int var2);

    public void apply(Graphics g) {
        if (this.previousWindowWidth != g.getWindowWidth() || this.previousWindowHeight != g.getWindowHeight()) {
            this.onResize(g.getWindowWidth(), g.getWindowHeight());
            this.previousWindowWidth = g.getWindowWidth();
            this.previousWindowHeight = g.getWindowHeight();
        }
        this.previousScaleX = g.getScaleX();
        this.previousScaleY = g.getScaleY();
        this.previousTranslateX = g.getTranslationX();
        this.previousTranslateY = g.getTranslationY();
        g.peekClip(this.previousClip);
        g.setScale(this.scaleX, this.scaleY);
        g.setTranslation(-this.x, -this.y);
        g.setClip(0.0f, 0.0f, this.width, this.height);
    }

    public void unapply(Graphics g) {
        g.setClip(this.previousClip);
        g.setTranslation(this.previousTranslateX, this.previousTranslateY);
        g.setScale(this.previousScaleX, this.previousScaleY);
    }

    public void toScreenCoordinates(Vector2 result, float worldX, float worldY) {
        result.x = worldX * this.scaleX + (float)this.x;
        result.y = worldY * this.scaleY + (float)this.y;
    }

    public void toWorldCoordinates(Vector2 result, float screenX, float screenY) {
        result.x = (screenX - (float)this.x) * this.invScaleX;
        result.y = (screenY - (float)this.y) * this.invScaleY;
    }

    public void toScreenCoordinates(Vector2 worldCoordinates) {
        this.toScreenCoordinates(worldCoordinates, worldCoordinates.x, worldCoordinates.y);
    }

    public void toWorldCoordinates(Vector2 screenCoordinates) {
        this.toWorldCoordinates(screenCoordinates, screenCoordinates.x, screenCoordinates.y);
    }

    protected void setBounds(int x, int y, int width, int height, float scaleX, float scaleY) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.scaleX = scaleX;
        this.invScaleX = 1.0f / scaleX;
        this.scaleY = scaleY;
        this.invScaleY = 1.0f / scaleY;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public float getInvScaleX() {
        return this.invScaleX;
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public float getInvScaleY() {
        return this.invScaleY;
    }
}

