/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.screen;

import com.badlogic.gdx.utils.IntMap;
import java.util.Iterator;
import org.mini2Dx.core.game.GameContainer;
import org.mini2Dx.core.graphics.Graphics;
import org.mini2Dx.core.screen.GameScreen;
import org.mini2Dx.core.screen.ScreenManager;
import org.mini2Dx.core.screen.Transition;
import org.mini2Dx.core.screen.transition.NullTransition;

public class BasicScreenManager<T extends GameScreen>
implements ScreenManager<T> {
    private final IntMap<T> gameScreens = new IntMap();
    protected T currentScreen;
    protected T nextScreen;
    protected Transition transitionIn;
    protected Transition transitionOut;

    @Override
    public void update(GameContainer gc, float delta) {
        if (this.transitionOut != null) {
            this.transitionOut.update(gc, delta);
            if (this.transitionOut.isFinished()) {
                if (this.currentScreen != null) {
                    this.currentScreen.postTransitionOut(this.transitionOut);
                }
                T oldScreen = this.currentScreen;
                this.currentScreen = this.nextScreen;
                this.nextScreen = null;
                this.transitionOut = null;
                if (this.transitionIn != null) {
                    this.currentScreen.preTransitionIn(this.transitionIn);
                }
            } else {
                return;
            }
        }
        if (this.transitionIn != null) {
            this.transitionIn.update(gc, delta);
            if (this.transitionIn.isFinished()) {
                this.currentScreen.postTransitionIn(this.transitionIn);
                this.transitionIn = null;
            } else {
                return;
            }
        }
        this.currentScreen.update(gc, this, delta);
    }

    @Override
    public void interpolate(GameContainer gc, float alpha) {
        if (this.currentScreen != null) {
            this.currentScreen.interpolate(gc, alpha);
        }
    }

    @Override
    public void render(GameContainer gc, Graphics g) {
        if (this.transitionOut != null) {
            this.transitionOut.preRender(gc, g);
        } else if (this.transitionIn != null) {
            this.transitionIn.preRender(gc, g);
        }
        if (this.currentScreen != null) {
            this.currentScreen.render(gc, g);
        }
        if (this.transitionOut != null) {
            this.transitionOut.postRender(gc, g);
        } else if (this.transitionIn != null) {
            this.transitionIn.postRender(gc, g);
        }
    }

    @Override
    public void enterGameScreen(int id, Transition transitionOut, Transition transitionIn) {
        if (transitionOut == null) {
            transitionOut = new NullTransition();
        }
        if (transitionIn == null) {
            transitionIn = new NullTransition();
        }
        this.transitionIn = transitionIn;
        this.transitionOut = transitionOut;
        this.nextScreen = (GameScreen)this.gameScreens.get(id);
        this.transitionIn.initialise((GameScreen)this.currentScreen, (GameScreen)this.nextScreen);
        this.transitionOut.initialise((GameScreen)this.currentScreen, (GameScreen)this.nextScreen);
        if (this.currentScreen != null) {
            this.currentScreen.preTransitionOut(transitionOut);
        }
    }

    @Override
    public void addGameScreen(T screen) {
        this.gameScreens.put(screen.getId(), screen);
    }

    @Override
    public T getGameScreen(int id) {
        return (T)((GameScreen)this.gameScreens.get(id));
    }

    @Override
    public boolean isTransitioning() {
        return this.transitionIn != null || this.transitionOut != null;
    }

    @Override
    public void onResize(int width, int height) {
        if (this.currentScreen == null) {
            return;
        }
        this.currentScreen.onResize(width, height);
    }

    @Override
    public void onPause() {
        if (this.currentScreen == null) {
            return;
        }
        this.currentScreen.onPause();
    }

    @Override
    public void onResume() {
        if (this.currentScreen == null) {
            return;
        }
        this.currentScreen.onResume();
    }

    @Override
    public Iterator<T> getGameScreens() {
        return this.gameScreens.values().iterator();
    }
}

