/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.screen.transition;

import com.badlogic.gdx.graphics.Color;
import org.mini2Dx.core.game.GameContainer;
import org.mini2Dx.core.graphics.Graphics;
import org.mini2Dx.core.screen.GameScreen;
import org.mini2Dx.core.screen.Transition;
import org.mini2Dx.core.util.ColorUtils;

public class FadeOutTransition
implements Transition {
    private final Color originalColor;
    private Color color;
    private float duration;

    public FadeOutTransition() {
        this(ColorUtils.rgbToColor("1,1,1"));
    }

    public FadeOutTransition(Color color) {
        this(color, 0.5f);
    }

    public FadeOutTransition(Color color, float duration) {
        this.originalColor = color;
        this.duration = duration;
    }

    @Override
    public void initialise(GameScreen outScreen, GameScreen inScreen) {
        this.color = this.originalColor.cpy();
        this.color.a = 0.0f;
    }

    @Override
    public void update(GameContainer gc, float delta) {
        this.color.a += delta * 1.0f / this.duration;
        if (this.color.a > 1.0f) {
            this.color.a = 1.0f;
        }
    }

    @Override
    public void preRender(GameContainer gc, Graphics g) {
    }

    @Override
    public void postRender(GameContainer gc, Graphics g) {
        Color old = g.getColor();
        g.setColor(this.color);
        g.fillRect(0.0f, 0.0f, gc.getWidth(), gc.getHeight());
        g.setColor(old);
    }

    @Override
    public boolean isFinished() {
        return this.color.a >= 1.0f;
    }
}

