/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.serialization;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.JsonWriter;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.reflect.Annotation;
import com.badlogic.gdx.utils.reflect.ArrayReflection;
import com.badlogic.gdx.utils.reflect.ClassReflection;
import com.badlogic.gdx.utils.reflect.Method;
import com.badlogic.gdx.utils.reflect.ReflectionException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.mini2Dx.core.serialization.RequiredFieldException;
import org.mini2Dx.core.serialization.SerializationException;
import org.mini2Dx.core.serialization.annotation.ConstructorArg;
import org.mini2Dx.core.serialization.annotation.Field;
import org.mini2Dx.core.serialization.annotation.NonConcrete;
import org.mini2Dx.core.serialization.annotation.PostDeserialize;
import org.mini2Dx.core.serialization.collection.DeserializedCollection;
import org.mini2Dx.core.serialization.collection.SerializedCollection;
import org.mini2Dx.core.serialization.map.deserialize.DeserializedMap;
import org.mini2Dx.core.serialization.map.serialize.SerializedMap;

public class JsonSerializer {
    private final ObjectMap<String, Method[]> methodCache = new ObjectMap();
    private final ObjectMap<String, com.badlogic.gdx.utils.reflect.Field[]> fieldCache = new ObjectMap();

    public <T> T fromJson(FileHandle fileHandle, Class<T> clazz) throws SerializationException {
        return this.deserialize(new JsonReader().parse(fileHandle), clazz);
    }

    public <T> T fromJson(String json, Class<T> clazz) throws SerializationException {
        return this.deserialize(new JsonReader().parse(json), clazz);
    }

    public <T> void toJson(FileHandle fileHandle, T object) throws SerializationException {
        this.toJson(fileHandle, object, false);
    }

    public <T> void toJson(FileHandle fileHandle, T object, boolean prettyPrint) throws SerializationException {
        String json = this.toJson(object, prettyPrint);
        fileHandle.writeString(json, false);
    }

    public <T> String toJson(T object) throws SerializationException {
        return this.toJson(object, false);
    }

    public <T> String toJson(T object, boolean prettyPrint) throws SerializationException {
        StringWriter writer = new StringWriter();
        Json json = new Json();
        json.setOutputType(JsonWriter.OutputType.json);
        json.setWriter((Writer)writer);
        this.writeObject(null, object, null, json);
        String result = writer.toString();
        try {
            writer.close();
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
        if (prettyPrint) {
            return json.prettyPrint(result);
        }
        return result;
    }

    private <T> void callPostDeserializeMethods(T object, Class<?> clazz) throws SerializationException {
        for (Class<?> currentClass = clazz; currentClass != null && !currentClass.equals(Object.class); currentClass = currentClass.getSuperclass()) {
            Method[] methods;
            String className = currentClass.getName();
            if (!this.methodCache.containsKey((Object)className)) {
                this.methodCache.put((Object)className, (Object)ClassReflection.getDeclaredMethods(currentClass));
            }
            for (Method method : methods = (Method[])this.methodCache.get((Object)className)) {
                if (!method.isAnnotationPresent(PostDeserialize.class)) continue;
                try {
                    method.invoke(object, new Object[0]);
                }
                catch (ReflectionException e) {
                    throw new SerializationException((Exception)((Object)e));
                }
            }
        }
    }

    private <T> void writePrimitive(String fieldName, Object value, Json json) {
        if (fieldName != null) {
            json.writeValue(fieldName, value);
        } else {
            json.writeValue(value);
        }
    }

    private <T> void writeArray(com.badlogic.gdx.utils.reflect.Field field, Object array, Json json) throws SerializationException {
        if (field != null) {
            json.writeArrayStart(field.getName());
        } else {
            json.writeArrayStart();
        }
        int arrayLength = Array.getLength(array);
        for (int i = 0; i < arrayLength; ++i) {
            this.writeObject(field, Array.get(array, i), null, json);
        }
        json.writeArrayEnd();
    }

    private <T> void writeSerializedCollection(com.badlogic.gdx.utils.reflect.Field field, SerializedCollection collection, Json json) throws SerializationException {
        if (field != null) {
            json.writeArrayStart(field.getName());
        } else {
            json.writeArrayStart();
        }
        int arrayLength = collection.getLength();
        for (int i = 0; i < arrayLength; ++i) {
            this.writeObject(field, collection.get(i), null, json);
        }
        json.writeArrayEnd();
        collection.dispose();
    }

    private <T> void writeSerializedMap(com.badlogic.gdx.utils.reflect.Field field, SerializedMap map, Json json) throws SerializationException {
        if (field != null) {
            json.writeObjectStart(field.getName());
        } else {
            json.writeObjectStart();
        }
        for (Object key : map.keys()) {
            this.writeObject(field, map.get(key), key.toString(), json);
        }
        json.writeObjectEnd();
    }

    private <T> void writeClassFieldIfRequired(com.badlogic.gdx.utils.reflect.Field fieldDefinition, T object, String fieldName, Json json) throws SerializationException {
        if (fieldDefinition == null) {
            return;
        }
        Class<?> clazz = object.getClass();
        Class fieldDefinitionClass = fieldDefinition.getType();
        if (fieldDefinitionClass.isArray()) {
            Class<?> arrayComponentType = fieldDefinitionClass.getComponentType();
            if (arrayComponentType.isInterface() && arrayComponentType.getAnnotation(NonConcrete.class) == null) {
                throw new SerializationException("Cannot serialize interface unless it has a @" + NonConcrete.class.getSimpleName() + " annotation");
            }
            this.writePrimitive("class", clazz.getName(), json);
            return;
        }
        if (Collection.class.isAssignableFrom(fieldDefinitionClass)) {
            Class valueClass = fieldDefinition.getElementType(0);
            if (valueClass.isInterface() && valueClass.getAnnotation(NonConcrete.class) == null) {
                throw new SerializationException("Cannot serialize interface unless it has a @" + NonConcrete.class.getSimpleName() + " annotation");
            }
            this.writePrimitive("class", clazz.getName(), json);
            return;
        }
        if (Map.class.isAssignableFrom(fieldDefinitionClass)) {
            Class valueClass = fieldDefinition.getElementType(1);
            if (valueClass.isInterface() && valueClass.getAnnotation(NonConcrete.class) == null) {
                throw new SerializationException("Cannot serialize interface unless it has a @" + NonConcrete.class.getSimpleName() + " annotation");
            }
            this.writePrimitive("class", clazz.getName(), json);
            return;
        }
        if (fieldDefinitionClass.isInterface()) {
            if (fieldDefinitionClass.getAnnotation(NonConcrete.class) == null) {
                throw new SerializationException("Cannot serialize interface unless it has a @" + NonConcrete.class.getSimpleName() + " annotation");
            }
            this.writePrimitive("class", clazz.getName(), json);
            return;
        }
        if (Modifier.isAbstract(fieldDefinitionClass.getModifiers())) {
            if (fieldDefinitionClass.getAnnotation(NonConcrete.class) == null) {
                throw new SerializationException("Cannot serialize abstract class unless it has a @" + NonConcrete.class.getSimpleName() + " annotation");
            }
            this.writePrimitive("class", clazz.getName(), json);
            return;
        }
    }

    private <T> void writeObject(com.badlogic.gdx.utils.reflect.Field fieldDefinition, T object, String fieldName, Json json) throws SerializationException {
        try {
            if (object == null) {
                this.writePrimitive(fieldName, null, json);
                return;
            }
            Class<?> clazz = object.getClass();
            if (this.isPrimitive(clazz) || clazz.equals(String.class)) {
                this.writePrimitive(fieldName, object, json);
                return;
            }
            if (clazz.isEnum() || clazz.getSuperclass().isEnum()) {
                this.writePrimitive(fieldName, object.toString(), json);
                return;
            }
            if (clazz.isArray()) {
                this.writeArray(fieldDefinition, object, json);
                return;
            }
            SerializedMap serializedMap = SerializedMap.getImplementation(clazz, object);
            if (serializedMap != null) {
                this.writeSerializedMap(fieldDefinition, serializedMap, json);
                return;
            }
            SerializedCollection serializedCollection = SerializedCollection.getImplementation(clazz, object);
            if (serializedCollection != null) {
                this.writeSerializedCollection(fieldDefinition, serializedCollection, json);
                return;
            }
            if (fieldName == null) {
                json.writeObjectStart();
            } else {
                json.writeObjectStart(fieldName);
            }
            this.writeClassFieldIfRequired(fieldDefinition, object, fieldName, json);
            for (Class<?> currentClass = clazz; currentClass != null && !currentClass.equals(Object.class); currentClass = currentClass.getSuperclass()) {
                Annotation annotation;
                com.badlogic.gdx.utils.reflect.Field[] fields;
                String className = currentClass.getName();
                if (!this.fieldCache.containsKey((Object)className)) {
                    this.fieldCache.put((Object)className, (Object)ClassReflection.getDeclaredFields(currentClass));
                }
                if (!this.methodCache.containsKey((Object)className)) {
                    this.methodCache.put((Object)className, (Object)ClassReflection.getDeclaredMethods(currentClass));
                }
                Method[] methods = (Method[])this.methodCache.get((Object)className);
                for (com.badlogic.gdx.utils.reflect.Field field : fields = (com.badlogic.gdx.utils.reflect.Field[])this.fieldCache.get((Object)className)) {
                    field.setAccessible(true);
                    annotation = field.getDeclaredAnnotation(Field.class);
                    if (annotation == null) continue;
                    Field fieldAnnotation = (Field)annotation.getAnnotation(Field.class);
                    if (!fieldAnnotation.optional() && field.get(object) == null) {
                        throw new RequiredFieldException(currentClass, field.getName());
                    }
                    this.writeObject(field, field.get(object), field.getName(), json);
                }
                for (com.badlogic.gdx.utils.reflect.Field field : methods) {
                    if (field.getParameterTypes().length > 0 || (annotation = field.getDeclaredAnnotation(ConstructorArg.class)) == null) continue;
                    ConstructorArg constructorArg = (ConstructorArg)annotation.getAnnotation(ConstructorArg.class);
                    this.writeObject(null, field.invoke(object, new Object[0]), constructorArg.name(), json);
                }
            }
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                Method[] methods;
                String className = interfaces[i].getName();
                if (!this.methodCache.containsKey((Object)className)) {
                    this.methodCache.put((Object)className, (Object)ClassReflection.getDeclaredMethods(interfaces[i]));
                }
                for (Method method : methods = (Method[])this.methodCache.get((Object)className)) {
                    Annotation annotation;
                    if (method.getParameterTypes().length > 0 || (annotation = method.getDeclaredAnnotation(ConstructorArg.class)) == null) continue;
                    ConstructorArg constructorArg = (ConstructorArg)annotation.getAnnotation(ConstructorArg.class);
                    this.writeObject(null, method.invoke(object, new Object[0]), constructorArg.name(), json);
                }
            }
            json.writeObjectEnd();
        }
        catch (SerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SerializationException(e);
        }
    }

    private <T> T construct(JsonValue objectRoot, Class<?> clazz) throws InstantiationException, IllegalAccessException, SerializationException, IllegalArgumentException, InvocationTargetException, ClassNotFoundException {
        Constructor<?>[] constructors = clazz.getConstructors();
        if (constructors.length == 1 && constructors[0].getParameterAnnotations().length == 0) {
            return (T)clazz.newInstance();
        }
        Constructor<?> bestMatchedConstructor = null;
        ArrayList<ConstructorArg> detectedAnnotations = new ArrayList<ConstructorArg>(1);
        for (int i = 0; i < constructors.length; ++i) {
            detectedAnnotations.clear();
            boolean allAnnotated = true;
            for (int j = 0; j < constructors[i].getParameterAnnotations().length; ++j) {
                java.lang.annotation.Annotation[] annotations = constructors[i].getParameterAnnotations()[j];
                if (annotations.length == 0) {
                    allAnnotated = false;
                    break;
                }
                boolean hasConstructorArgAnnotation = false;
                for (int k = 0; k < annotations.length; ++k) {
                    ConstructorArg constructorArg;
                    if (!annotations[i].annotationType().isAssignableFrom(ConstructorArg.class) || objectRoot.get((constructorArg = (ConstructorArg)annotations[i]).name()) == null) continue;
                    detectedAnnotations.add(constructorArg);
                    hasConstructorArgAnnotation = true;
                    break;
                }
                if (hasConstructorArgAnnotation) continue;
                allAnnotated = false;
            }
            if (!allAnnotated) continue;
            if (bestMatchedConstructor == null) {
                bestMatchedConstructor = constructors[i];
                continue;
            }
            if (detectedAnnotations.size() <= bestMatchedConstructor.getParameterAnnotations().length) continue;
            bestMatchedConstructor = constructors[i];
        }
        if (bestMatchedConstructor == null) {
            throw new SerializationException("Could not find suitable constructor for class " + clazz.getName());
        }
        if (detectedAnnotations.size() == 0) {
            return (T)clazz.newInstance();
        }
        Object[] constructorParameters = new Object[detectedAnnotations.size()];
        for (int i = 0; i < detectedAnnotations.size(); ++i) {
            ConstructorArg constructorArg = (ConstructorArg)detectedAnnotations.get(i);
            constructorParameters[i] = this.deserialize(objectRoot.get(constructorArg.name()), constructorArg.clazz());
            objectRoot.remove(constructorArg.name());
        }
        return bestMatchedConstructor.newInstance(constructorParameters);
    }

    private Class<?> determineImplementation(JsonValue objectRoot, Class<?> clazz) throws SerializationException, ClassNotFoundException {
        if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) {
            JsonValue classField = objectRoot.get("class");
            if (classField == null) {
                throw new SerializationException("No class field found for deserializing " + clazz.getName());
            }
            clazz = Class.forName(classField.asString());
        }
        return clazz;
    }

    private <T> T deserialize(JsonValue objectRoot, Class<T> fieldClass) throws SerializationException {
        try {
            if (objectRoot.isNull()) {
                return null;
            }
            if (objectRoot.isObject()) {
                Class<?> clazz = this.determineImplementation(objectRoot, fieldClass);
                T result = this.construct(objectRoot, clazz);
                for (Class<?> currentClass = clazz; currentClass != null && !currentClass.equals(Object.class); currentClass = currentClass.getSuperclass()) {
                    for (com.badlogic.gdx.utils.reflect.Field field : ClassReflection.getDeclaredFields(currentClass)) {
                        field.setAccessible(true);
                        Annotation annotation = field.getDeclaredAnnotation(Field.class);
                        if (annotation == null) continue;
                        Field fieldAnnotation = (Field)annotation.getAnnotation(Field.class);
                        JsonValue value = objectRoot.get(field.getName());
                        if (value == null || value.isNull()) {
                            if (fieldAnnotation.optional()) continue;
                            throw new RequiredFieldException(currentClass, field.getName());
                        }
                        this.setField(result, field, value);
                    }
                }
                this.callPostDeserializeMethods(result, clazz);
                return result;
            }
            if (objectRoot.isArray()) {
                Class<?> arrayType = fieldClass.getComponentType();
                Object array = ArrayReflection.newInstance(arrayType, (int)objectRoot.size);
                for (int i = 0; i < objectRoot.size; ++i) {
                    Array.set(array, i, this.deserialize(objectRoot.get(i), arrayType));
                }
                return (T)array;
            }
            if (fieldClass.isEnum()) {
                return Enum.valueOf(fieldClass, objectRoot.asString());
            }
            if (fieldClass.equals(Boolean.TYPE) || fieldClass.equals(Boolean.class)) {
                return (T)Boolean.valueOf(objectRoot.asBoolean());
            }
            if (fieldClass.equals(Byte.TYPE) || fieldClass.equals(Byte.class)) {
                return (T)Byte.valueOf(objectRoot.asByte());
            }
            if (fieldClass.equals(Character.TYPE) || fieldClass.equals(Character.class)) {
                return (T)Character.valueOf(objectRoot.asChar());
            }
            if (fieldClass.equals(Double.TYPE) || fieldClass.equals(Double.class)) {
                return (T)Double.valueOf(objectRoot.asDouble());
            }
            if (fieldClass.equals(Float.TYPE) || fieldClass.equals(Float.class)) {
                return (T)Float.valueOf(objectRoot.asFloat());
            }
            if (fieldClass.equals(Integer.TYPE) || fieldClass.equals(Integer.class)) {
                return (T)Integer.valueOf(objectRoot.asInt());
            }
            if (fieldClass.equals(Long.TYPE) || fieldClass.equals(Long.class)) {
                return (T)Long.valueOf(objectRoot.asLong());
            }
            if (fieldClass.equals(Short.TYPE) || fieldClass.equals(Short.class)) {
                return (T)Short.valueOf(objectRoot.asShort());
            }
            return (T)objectRoot.asString();
        }
        catch (SerializationException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SerializationException(e);
        }
    }

    private <T> void setField(T targetObject, com.badlogic.gdx.utils.reflect.Field field, JsonValue value) throws SerializationException {
        try {
            Class clazz = field.getType();
            if (clazz.isArray()) {
                this.setArrayField(targetObject, field, clazz, value);
                return;
            }
            if (clazz.isEnum()) {
                if (field.isFinal()) {
                    throw new SerializationException("Cannot use @Field on final enum fields. Use the @ConstructorArg method instead.");
                }
                field.set(targetObject, Enum.valueOf(clazz, value.asString()));
                return;
            }
            if (!clazz.isPrimitive()) {
                if (clazz.equals(String.class)) {
                    if (field.isFinal()) {
                        throw new SerializationException("Cannot use @Field on final String fields. Use the @ConstructorArg method instead.");
                    }
                    field.set(targetObject, (Object)value.asString());
                } else {
                    DeserializedMap deserializedMap = DeserializedMap.getImplementation(field, clazz, targetObject);
                    if (deserializedMap != null) {
                        this.setSerializedMapField(deserializedMap, targetObject, field, clazz, value);
                    } else {
                        DeserializedCollection deserializedCollection = DeserializedCollection.getImplementation(field, clazz, targetObject);
                        if (deserializedCollection != null) {
                            this.setSerializedCollectionField(deserializedCollection, targetObject, field, clazz, value);
                        } else {
                            if (field.isFinal()) {
                                throw new SerializationException("Cannot use @Field on final " + clazz.getName() + " fields.");
                            }
                            field.set(targetObject, this.deserialize(value, clazz));
                        }
                    }
                }
                return;
            }
            if (field.isFinal()) {
                throw new SerializationException("Cannot use @Field on final " + clazz.getName() + " fields. Use the @ConstructorArg method instead.");
            }
            field.set(targetObject, this.deserialize(value, clazz));
        }
        catch (SerializationException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SerializationException(e);
        }
    }

    private <T> void setSerializedCollectionField(DeserializedCollection deserializedCollection, T targetObject, com.badlogic.gdx.utils.reflect.Field field, Class<?> clazz, JsonValue value) throws SerializationException {
        try {
            Class<?> valueClass = deserializedCollection.getValueClass();
            for (int i = 0; i < value.size; ++i) {
                deserializedCollection.add(this.deserialize(value.get(i), valueClass));
            }
        }
        catch (SerializationException e) {
            throw e;
        }
        catch (Exception e) {
            e.getMessage();
            throw new SerializationException(e);
        }
    }

    private <T> void setArrayField(T targetObject, com.badlogic.gdx.utils.reflect.Field field, Class<?> clazz, JsonValue value) throws SerializationException {
        try {
            if (clazz.equals(boolean[].class)) {
                boolean[] result = value.asBooleanArray();
                if (field.isFinal()) {
                    Object targetArray = field.get(targetObject);
                    for (int i = 0; i < result.length; ++i) {
                        ArrayReflection.set((Object)targetArray, (int)i, (Object)result[i]);
                    }
                } else {
                    field.set(targetObject, (Object)result);
                }
            } else if (clazz.equals(byte[].class)) {
                byte[] result = value.asByteArray();
                if (field.isFinal()) {
                    Object targetArray = field.get(targetObject);
                    for (int i = 0; i < result.length; ++i) {
                        ArrayReflection.set((Object)targetArray, (int)i, (Object)result[i]);
                    }
                } else {
                    field.set(targetObject, (Object)result);
                }
            } else if (clazz.equals(char[].class)) {
                char[] result = value.asCharArray();
                if (field.isFinal()) {
                    Object targetArray = field.get(targetObject);
                    for (int i = 0; i < result.length; ++i) {
                        ArrayReflection.set((Object)targetArray, (int)i, (Object)Character.valueOf(result[i]));
                    }
                } else {
                    field.set(targetObject, (Object)result);
                }
            } else if (clazz.equals(double[].class)) {
                double[] result = value.asDoubleArray();
                if (field.isFinal()) {
                    Object targetArray = field.get(targetObject);
                    for (int i = 0; i < result.length; ++i) {
                        ArrayReflection.set((Object)targetArray, (int)i, (Object)result[i]);
                    }
                } else {
                    field.set(targetObject, (Object)result);
                }
            } else if (clazz.equals(float[].class)) {
                float[] result = value.asFloatArray();
                if (field.isFinal()) {
                    Object targetArray = field.get(targetObject);
                    for (int i = 0; i < result.length; ++i) {
                        ArrayReflection.set((Object)targetArray, (int)i, (Object)Float.valueOf(result[i]));
                    }
                } else {
                    field.set(targetObject, (Object)result);
                }
            } else if (clazz.equals(int[].class)) {
                int[] result = value.asIntArray();
                if (field.isFinal()) {
                    Object targetArray = field.get(targetObject);
                    for (int i = 0; i < result.length; ++i) {
                        ArrayReflection.set((Object)targetArray, (int)i, (Object)result[i]);
                    }
                } else {
                    field.set(targetObject, (Object)result);
                }
            } else if (clazz.equals(long[].class)) {
                long[] result = value.asLongArray();
                if (field.isFinal()) {
                    Object targetArray = field.get(targetObject);
                    for (int i = 0; i < result.length; ++i) {
                        ArrayReflection.set((Object)targetArray, (int)i, (Object)result[i]);
                    }
                } else {
                    field.set(targetObject, (Object)result);
                }
            } else if (clazz.equals(short[].class)) {
                short[] result = value.asShortArray();
                if (field.isFinal()) {
                    Object targetArray = field.get(targetObject);
                    for (int i = 0; i < result.length; ++i) {
                        ArrayReflection.set((Object)targetArray, (int)i, (Object)result[i]);
                    }
                } else {
                    field.set(targetObject, (Object)result);
                }
            } else if (clazz.equals(String[].class)) {
                String[] result = value.asStringArray();
                if (field.isFinal()) {
                    Object targetArray = field.get(targetObject);
                    for (int i = 0; i < result.length; ++i) {
                        ArrayReflection.set((Object)targetArray, (int)i, (Object)result[i]);
                    }
                } else {
                    field.set(targetObject, (Object)result);
                }
            } else {
                Object result = this.deserialize(value, clazz);
                if (field.isFinal()) {
                    Object targetArray = field.get(targetObject);
                    int length = ArrayReflection.getLength(result);
                    for (int i = 0; i < length; ++i) {
                        ArrayReflection.set((Object)targetArray, (int)i, (Object)ArrayReflection.get(result, (int)i));
                    }
                } else {
                    field.set(targetObject, result);
                }
            }
        }
        catch (SerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SerializationException(e);
        }
    }

    private <T> void setSerializedMapField(DeserializedMap deserializedMap, T targetObject, com.badlogic.gdx.utils.reflect.Field field, Class<?> clazz, JsonValue value) throws SerializationException {
        try {
            Class<?> keyClass = deserializedMap.getKeyClass();
            Class<?> valueClass = deserializedMap.getValueClass();
            for (int i = 0; i < value.size; ++i) {
                deserializedMap.put(this.parseMapKey(value.get((int)i).name, keyClass), this.deserialize(value.get(i), valueClass));
            }
        }
        catch (SerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SerializationException(e);
        }
    }

    private boolean isPrimitive(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return true;
        }
        if (clazz.equals(Boolean.class)) {
            return true;
        }
        if (clazz.equals(Byte.class)) {
            return true;
        }
        if (clazz.equals(Character.class)) {
            return true;
        }
        if (clazz.equals(Double.class)) {
            return true;
        }
        if (clazz.equals(Float.class)) {
            return true;
        }
        if (clazz.equals(Integer.class)) {
            return true;
        }
        if (clazz.equals(Long.class)) {
            return true;
        }
        return clazz.equals(Short.class);
    }

    private <T> T parseMapKey(String value, Class<T> clazz) {
        if (clazz.equals(Boolean.TYPE) || clazz.equals(Boolean.class)) {
            return (T)new Boolean(value);
        }
        if (clazz.equals(Byte.TYPE) || clazz.equals(Byte.class)) {
            return (T)new Byte(value);
        }
        if (clazz.equals(Character.TYPE) || clazz.equals(Character.class)) {
            return (T)new Character(value.charAt(0));
        }
        if (clazz.equals(Double.TYPE) || clazz.equals(Double.class)) {
            return (T)new Double(value);
        }
        if (clazz.equals(Float.TYPE) || clazz.equals(Float.class)) {
            return (T)new Float(value);
        }
        if (clazz.equals(Integer.TYPE) || clazz.equals(Integer.class)) {
            return (T)new Integer(value);
        }
        if (clazz.equals(Long.TYPE) || clazz.equals(Long.class)) {
            return (T)new Long(value);
        }
        if (clazz.equals(Short.TYPE) || clazz.equals(Short.class)) {
            return (T)new Short(value);
        }
        if (clazz.isEnum()) {
            return Enum.valueOf(clazz, value);
        }
        return (T)value;
    }
}

