/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.serialization.collection;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.BooleanArray;
import com.badlogic.gdx.utils.ByteArray;
import com.badlogic.gdx.utils.CharArray;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.IntSet;
import com.badlogic.gdx.utils.LongArray;
import com.badlogic.gdx.utils.ObjectSet;
import com.badlogic.gdx.utils.OrderedSet;
import com.badlogic.gdx.utils.ShortArray;
import com.badlogic.gdx.utils.SortedIntList;
import com.badlogic.gdx.utils.reflect.ClassReflection;
import com.badlogic.gdx.utils.reflect.Field;
import com.badlogic.gdx.utils.reflect.ReflectionException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.mini2Dx.core.serialization.collection.GdxDeserializedCollection;
import org.mini2Dx.core.serialization.collection.ListDeserializedCollection;
import org.mini2Dx.core.serialization.collection.SetDeserializedCollection;

public abstract class DeserializedCollection<T> {
    protected final Field field;
    protected final Class<?> fieldClass;
    protected final T collection;

    public DeserializedCollection(Field field, Class<?> fieldClass, Object object) throws ReflectionException {
        this.field = field;
        this.fieldClass = fieldClass;
        if (field.isFinal()) {
            this.collection = field.get(object);
        } else {
            this.collection = fieldClass.isInterface() ? ClassReflection.newInstance(this.getFallbackImplementation()) : ClassReflection.newInstance(fieldClass);
            field.set(object, this.collection);
        }
    }

    public abstract Class<? extends T> getFallbackImplementation();

    public abstract Class<?> getValueClass();

    public abstract void add(Object var1);

    public static DeserializedCollection getImplementation(Field field, Class<?> fieldClass, Object object) throws ReflectionException, NoSuchMethodException {
        if (List.class.isAssignableFrom(fieldClass)) {
            return new ListDeserializedCollection(field, fieldClass, object);
        }
        if (Set.class.isAssignableFrom(fieldClass)) {
            return new SetDeserializedCollection(field, fieldClass, object);
        }
        if (Array.class.isAssignableFrom(fieldClass)) {
            return new GdxDeserializedCollection(Array.class, field.getElementType(0), field, fieldClass, object);
        }
        if (BooleanArray.class.isAssignableFrom(fieldClass)) {
            return new GdxDeserializedCollection<BooleanArray, Boolean>(BooleanArray.class, Boolean.class, field, fieldClass, object);
        }
        if (ByteArray.class.isAssignableFrom(fieldClass)) {
            return new GdxDeserializedCollection<ByteArray, Byte>(ByteArray.class, Byte.class, field, fieldClass, object);
        }
        if (CharArray.class.isAssignableFrom(fieldClass)) {
            return new GdxDeserializedCollection<CharArray, Character>(CharArray.class, Character.class, field, fieldClass, object);
        }
        if (FloatArray.class.isAssignableFrom(fieldClass)) {
            return new GdxDeserializedCollection<FloatArray, Float>(FloatArray.class, Float.class, field, fieldClass, object);
        }
        if (IntArray.class.isAssignableFrom(fieldClass)) {
            return new GdxDeserializedCollection<IntArray, Integer>(IntArray.class, Integer.class, field, fieldClass, object);
        }
        if (IntSet.class.isAssignableFrom(fieldClass)) {
            return new GdxDeserializedCollection<IntSet, Integer>(IntSet.class, Integer.class, field, fieldClass, object);
        }
        if (LongArray.class.isAssignableFrom(fieldClass)) {
            return new GdxDeserializedCollection<LongArray, Long>(LongArray.class, Long.class, field, fieldClass, object);
        }
        if (OrderedSet.class.isAssignableFrom(fieldClass)) {
            return new GdxDeserializedCollection(OrderedSet.class, field.getElementType(0), field, fieldClass, object);
        }
        if (ObjectSet.class.isAssignableFrom(fieldClass)) {
            return new GdxDeserializedCollection(ObjectSet.class, field.getElementType(0), field, fieldClass, object);
        }
        if (ShortArray.class.isAssignableFrom(fieldClass)) {
            return new GdxDeserializedCollection<ShortArray, Short>(ShortArray.class, Short.class, field, fieldClass, object);
        }
        if (SortedIntList.class.isAssignableFrom(fieldClass)) {
            return new GdxDeserializedCollection<SortedIntList, Integer>(SortedIntList.class, Integer.class, field, fieldClass, object);
        }
        if (Collection.class.isAssignableFrom(fieldClass)) {
            return new ListDeserializedCollection(field, fieldClass, object);
        }
        return null;
    }
}

