/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.serialization.collection;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.utils.reflect.Field;
import com.badlogic.gdx.utils.reflect.ReflectionException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.mini2Dx.core.serialization.collection.DeserializedCollection;

public class GdxDeserializedCollection<T, N>
extends DeserializedCollection<T> {
    private static final String LOGGING_TAG = GdxDeserializedCollection.class.getSimpleName();
    private final Class<T> fallbackClass;
    private final Class<N> valueClass;
    private Method addMethod;

    public GdxDeserializedCollection(Class<T> fallbackClass, Class<N> valueClass, Field field, Class<?> fieldClass, Object object) throws ReflectionException, NoSuchMethodException {
        super(field, fieldClass, object);
        this.fallbackClass = fallbackClass;
        this.valueClass = valueClass;
        for (Method method : fieldClass.getMethods()) {
            method.setAccessible(true);
            if (!method.getName().equals("add") || method.getParameterTypes().length != 1) continue;
            this.addMethod = method;
            break;
        }
        if (this.addMethod == null) {
            throw new NoSuchMethodException("No such method add on " + fieldClass.getName());
        }
    }

    @Override
    public Class<? extends T> getFallbackImplementation() {
        return this.fallbackClass;
    }

    @Override
    public Class<?> getValueClass() {
        return this.valueClass;
    }

    @Override
    public void add(Object element) {
        try {
            this.addMethod.invoke(this.collection, element);
        }
        catch (IllegalAccessException e) {
            Gdx.app.error(LOGGING_TAG, e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Gdx.app.error(LOGGING_TAG, e.getMessage(), (Throwable)e);
        }
    }
}

