/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.serialization.collection;

import com.badlogic.gdx.Gdx;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.mini2Dx.core.serialization.collection.SerializedCollection;

public class GdxSerializedCollection<T>
extends SerializedCollection<T> {
    private static final String LOGGING_TAG = GdxSerializedCollection.class.getSimpleName();
    private Method getMethod;
    private Field sizeField;

    public GdxSerializedCollection(Class<T> clazz, T collection) throws NoSuchFieldException {
        super(collection);
        for (Method method : clazz.getMethods()) {
            method.setAccessible(true);
            if (!method.getName().equals("get")) continue;
            this.getMethod = method;
            break;
        }
        this.sizeField = clazz.getField("size");
    }

    @Override
    public Object get(int index) {
        try {
            return this.getMethod.invoke(this.collection, index);
        }
        catch (IllegalAccessException e) {
            Gdx.app.error(LOGGING_TAG, e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Gdx.app.error(LOGGING_TAG, e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public int getLength() {
        try {
            return (Integer)this.sizeField.get(this.collection);
        }
        catch (IllegalAccessException e) {
            Gdx.app.error(LOGGING_TAG, e.getMessage(), (Throwable)e);
            return -1;
        }
    }

    @Override
    public void dispose() {
    }
}

