/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.serialization.map.deserialize;

import com.badlogic.gdx.utils.ArrayMap;
import com.badlogic.gdx.utils.IntFloatMap;
import com.badlogic.gdx.utils.IntIntMap;
import com.badlogic.gdx.utils.IntMap;
import com.badlogic.gdx.utils.LongMap;
import com.badlogic.gdx.utils.ObjectFloatMap;
import com.badlogic.gdx.utils.ObjectIntMap;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.OrderedMap;
import com.badlogic.gdx.utils.reflect.ClassReflection;
import com.badlogic.gdx.utils.reflect.Field;
import com.badlogic.gdx.utils.reflect.ReflectionException;
import java.util.Map;
import org.mini2Dx.core.serialization.map.deserialize.GdxDeserializedMap;
import org.mini2Dx.core.serialization.map.deserialize.MapDeserializedMap;

public abstract class DeserializedMap<T> {
    protected final Field field;
    protected final Class<?> fieldClass;
    protected final T map;

    public DeserializedMap(Field field, Class<?> fieldClass, Object object) throws ReflectionException {
        this.field = field;
        this.fieldClass = fieldClass;
        if (field.isFinal()) {
            this.map = field.get(object);
        } else {
            this.map = fieldClass.isInterface() ? ClassReflection.newInstance(this.getFallbackImplementation()) : ClassReflection.newInstance(fieldClass);
            field.set(object, this.map);
        }
    }

    public abstract Class<? extends T> getFallbackImplementation();

    public abstract Class<?> getKeyClass();

    public abstract Class<?> getValueClass();

    public abstract void put(Object var1, Object var2);

    public static DeserializedMap getImplementation(Field field, Class<?> fieldClass, Object object) throws ReflectionException {
        if (Map.class.isAssignableFrom(fieldClass)) {
            return new MapDeserializedMap(field, fieldClass, object);
        }
        if (ArrayMap.class.isAssignableFrom(fieldClass)) {
            return new GdxDeserializedMap<ArrayMap>(field, ArrayMap.class, field.getElementType(0), field.getElementType(1), object);
        }
        if (IntMap.class.isAssignableFrom(fieldClass)) {
            return new GdxDeserializedMap<IntMap>(field, IntMap.class, Integer.class, field.getElementType(0), object);
        }
        if (IntFloatMap.class.isAssignableFrom(fieldClass)) {
            return new GdxDeserializedMap<IntFloatMap>(field, IntFloatMap.class, Integer.class, Float.class, object);
        }
        if (IntIntMap.class.isAssignableFrom(fieldClass)) {
            return new GdxDeserializedMap<IntIntMap>(field, IntIntMap.class, Integer.class, Integer.class, object);
        }
        if (LongMap.class.isAssignableFrom(fieldClass)) {
            return new GdxDeserializedMap<LongMap>(field, LongMap.class, Long.class, field.getElementType(0), object);
        }
        if (ObjectFloatMap.class.isAssignableFrom(fieldClass)) {
            return new GdxDeserializedMap<ObjectFloatMap>(field, ObjectFloatMap.class, field.getElementType(0), Float.class, object);
        }
        if (ObjectIntMap.class.isAssignableFrom(fieldClass)) {
            return new GdxDeserializedMap<ObjectIntMap>(field, ObjectIntMap.class, field.getElementType(0), Integer.class, object);
        }
        if (ObjectMap.class.isAssignableFrom(fieldClass)) {
            return new GdxDeserializedMap<ObjectMap>(field, ObjectMap.class, field.getElementType(0), field.getElementType(1), object);
        }
        if (OrderedMap.class.isAssignableFrom(fieldClass)) {
            return new GdxDeserializedMap<OrderedMap>(field, OrderedMap.class, field.getElementType(0), field.getElementType(1), object);
        }
        return null;
    }
}

