/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.serialization.map.deserialize;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.utils.reflect.Field;
import com.badlogic.gdx.utils.reflect.ReflectionException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.mini2Dx.core.serialization.map.deserialize.DeserializedMap;

public class GdxDeserializedMap<T>
extends DeserializedMap<T> {
    private static final String LOGGING_TAG = GdxDeserializedMap.class.getSimpleName();
    private final Class<T> fallbackClass;
    private final Class<?> keyClass;
    private final Class<?> valueClass;
    private Method putMethod;

    public GdxDeserializedMap(Field field, Class<T> fieldClass, Class<?> keyClass, Class<?> valueClass, Object object) throws ReflectionException {
        super(field, fieldClass, object);
        this.fallbackClass = fieldClass;
        this.keyClass = keyClass;
        this.valueClass = valueClass;
        for (Method method : fieldClass.getMethods()) {
            if (!method.getName().equals("put")) continue;
            this.putMethod = method;
            break;
        }
    }

    @Override
    public Class<? extends T> getFallbackImplementation() {
        return this.fallbackClass;
    }

    @Override
    public Class<?> getKeyClass() {
        return this.keyClass;
    }

    @Override
    public Class<?> getValueClass() {
        return this.valueClass;
    }

    @Override
    public void put(Object key, Object value) {
        try {
            this.putMethod.invoke(this.map, key, value);
        }
        catch (IllegalAccessException e) {
            Gdx.app.error(LOGGING_TAG, e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Gdx.app.error(LOGGING_TAG, e.getMessage(), (Throwable)e);
        }
    }
}

