/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.util;

import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import org.mini2Dx.core.graphics.Graphics;
import org.mini2Dx.core.util.RollingAverage;

public class PerformanceTracker {
    private static final GlyphLayout GLYPH_LAYOUT = new GlyphLayout();
    private static final String DURATION_PREFIX = "Avg update duration:: ";
    private static final String UPDATE_PREFIX = "Updates / second:: ";
    private static final String FRAMES_PREFIX = "Frames / second:: ";
    private static final String MEMORY_PREFIX = "Memory usage:: ";
    private static final String MS = "ms";
    private final RollingAverage averageUpdateDuration = new RollingAverage(60);
    private final String[] messages = new String[4];
    private long lastMessagesUpdate = 0L;
    private long updateSecondStart = System.nanoTime();
    private int updates;
    private int updatesPerSecond;
    private long updateStart;
    private long frameSecondStart = System.nanoTime();
    private int frames;
    private int framesPerSecond;

    public PerformanceTracker() {
        this.updateMessages();
    }

    public void markUpdateBegin() {
        long time = System.nanoTime();
        if (time - this.updateSecondStart >= 1000000000L) {
            this.updatesPerSecond = this.updates;
            this.updates = 0;
            this.updateSecondStart = time;
        }
        ++this.updates;
        this.updateStart = System.nanoTime();
    }

    public void markUpdateEnd() {
        long time = System.nanoTime();
        long updateDuration = time - this.updateStart;
        this.averageUpdateDuration.mark(updateDuration);
    }

    public void markFrame() {
        long time = System.nanoTime();
        if (time - this.frameSecondStart >= 1000000000L) {
            this.framesPerSecond = this.frames;
            this.frames = 0;
            this.frameSecondStart = time;
        }
        ++this.frames;
    }

    public int getUpdatesPerSecond() {
        return this.updatesPerSecond;
    }

    public int getFramesPerSecond() {
        return this.framesPerSecond;
    }

    public double getAverageUpdateDuration() {
        return this.averageUpdateDuration.getAverage();
    }

    public long getTotalMemory() {
        return Runtime.getRuntime().totalMemory();
    }

    public long getUsedMemory() {
        return this.getTotalMemory() - this.getAvailableMemory();
    }

    public long getAvailableMemory() {
        return Runtime.getRuntime().freeMemory();
    }

    public void draw(Graphics g, float x, float y) {
        this.draw(g, x, y, -1.0f, 0);
    }

    public void draw(Graphics g, float x, float y, float targetWidth, int horizontalAlign) {
        this.updateMessages();
        float lineHeight = this.getLineHeight(g);
        for (int i = 0; i < this.messages.length; ++i) {
            if (targetWidth < 0.0f) {
                g.drawString(this.messages[i], x, y + lineHeight * (float)i + 1.0f * (float)i);
                continue;
            }
            g.drawString(this.messages[i], x, y + lineHeight * (float)i + 1.0f * (float)i, targetWidth, horizontalAlign);
        }
    }

    public void drawInTopLeft(Graphics g) {
        this.draw(g, 0.0f, 0.0f);
    }

    public void drawInTopRight(Graphics g) {
        float textWidth = this.getLineWidth(g);
        this.draw(g, g.getViewportWidth() - textWidth - 1.0f, 0.0f, textWidth, 16);
    }

    public void drawInBottomLeft(Graphics g) {
        float textHeight = this.getLineHeight(g) * (float)this.messages.length + (float)this.messages.length;
        this.draw(g, 0.0f, g.getViewportHeight() - textHeight - 1.0f, -1.0f, 8);
    }

    public void drawInBottomRight(Graphics g) {
        float textWidth = this.getLineWidth(g);
        float textHeight = this.getLineHeight(g) * (float)this.messages.length + (float)this.messages.length;
        this.draw(g, g.getViewportWidth() - textWidth - 1.0f, g.getViewportHeight() - textHeight - 1.0f, textWidth, 16);
    }

    private float getLineWidth(Graphics g) {
        float lineWidth = 0.0f;
        for (int i = 0; i < this.messages.length; ++i) {
            GLYPH_LAYOUT.setText(g.getFont(), (CharSequence)this.messages[i]);
            if (!(PerformanceTracker.GLYPH_LAYOUT.width > lineWidth)) continue;
            lineWidth = PerformanceTracker.GLYPH_LAYOUT.width;
        }
        return lineWidth;
    }

    private float getLineHeight(Graphics g) {
        float lineHeight = 0.0f;
        for (int i = 0; i < this.messages.length; ++i) {
            GLYPH_LAYOUT.setText(g.getFont(), (CharSequence)this.messages[i]);
            if (!(PerformanceTracker.GLYPH_LAYOUT.height > lineHeight)) continue;
            lineHeight = PerformanceTracker.GLYPH_LAYOUT.height;
        }
        return lineHeight;
    }

    private String getHumanReadableByteValue(long bytes) {
        int unit = 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = "KMGTPE".charAt(exp - 1) + "i";
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    private void updateMessages() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastMessagesUpdate < 1000L) {
            return;
        }
        this.lastMessagesUpdate = currentTime;
        this.messages[0] = DURATION_PREFIX + String.format("%.3f", this.averageUpdateDuration.getAverage() / 1000000.0) + MS;
        this.messages[1] = UPDATE_PREFIX + this.updatesPerSecond;
        this.messages[2] = FRAMES_PREFIX + this.framesPerSecond;
        this.messages[3] = MEMORY_PREFIX + this.getHumanReadableByteValue(this.getUsedMemory()) + "/" + this.getHumanReadableByteValue(this.getTotalMemory());
    }
}

