/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.util;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import org.mini2Dx.core.exception.MdxException;

public class UriFileHandle {
    public static FileHandle get(String uri) {
        if (uri == null) {
            throw new NullPointerException("Cannot pass null to " + UriFileHandle.class.getSimpleName() + ".get(String uri)");
        }
        String[] components = uri.split(":\\/\\/");
        if (components.length < 2) {
            throw new MdxException("No URI specified. Options are internal://, external://, absolute://, classpath://, local://");
        }
        switch (components[0]) {
            case "internal": {
                return Gdx.files.internal(components[1]);
            }
            case "external": {
                return Gdx.files.external(components[1]);
            }
            case "absolute": {
                return Gdx.files.absolute(components[1]);
            }
            case "classpath": {
                return Gdx.files.classpath(components[1]);
            }
            case "local": {
                return Gdx.files.local(components[1]);
            }
        }
        throw new MdxException("Invalid URI specified. Options are internal://, external://, absolute://, classpath://, local://");
    }
}

