/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.serialization;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.reflect.jvm.JvmReflection;
import org.mini2Dx.core.serialization.AotSerializationData;
import org.mini2Dx.core.serialization.aot.AotSerializedClassData;
import org.mini2Dx.core.serialization.dummy.TestChildObject;
import org.mini2Dx.core.serialization.dummy.TestComplexConstructorArgObject;
import org.mini2Dx.core.serialization.dummy.TestParentObject;

public class AotSerializationDataTest {
    @Before
    public void setUp() {
        AotSerializationData.clear();
        Mdx.reflect = new JvmReflection();
    }

    @Test
    public void testSaveToRestoreFrom() throws Exception {
        AotSerializationData.registerClass(TestParentObject.class);
        AotSerializationData.registerClass(TestChildObject.class);
        StringWriter stringWriter = new StringWriter();
        AotSerializationData.saveTo((Writer)stringWriter);
        AotSerializedClassData classData = AotSerializationData.getClassData(TestParentObject.class);
        Assert.assertTrue((classData.getTotalFields() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((classData.getPostDeserializeMethodName() != null ? 1 : 0) != 0);
        String data = stringWriter.toString();
        System.out.println(data);
        Assert.assertTrue((data.length() > 0 ? 1 : 0) != 0);
        AotSerializationData.clear();
        AotSerializationData.restoreFrom((Reader)new StringReader(data));
        AotSerializedClassData result = AotSerializationData.getClassData(TestParentObject.class);
        Assert.assertTrue((result.getTotalFields() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((classData.getPostDeserializeMethodName() != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)classData, (Object)result);
    }

    @Test
    public void testSaveToRestoreFromWithConstructorArgs() throws Exception {
        AotSerializationData.registerClass(TestComplexConstructorArgObject.class);
        StringWriter stringWriter = new StringWriter();
        AotSerializationData.saveTo((Writer)stringWriter);
        AotSerializedClassData classData = AotSerializationData.getClassData(TestComplexConstructorArgObject.class);
        Assert.assertEquals((long)0L, (long)classData.getTotalFields());
        Assert.assertEquals((long)2L, (long)classData.getTotalConstructors());
        String data = stringWriter.toString();
        System.out.println(data);
        Assert.assertTrue((data.length() > 0 ? 1 : 0) != 0);
        AotSerializationData.clear();
        AotSerializationData.restoreFrom((Reader)new StringReader(data));
        AotSerializedClassData result = AotSerializationData.getClassData(TestComplexConstructorArgObject.class);
        Assert.assertEquals((long)0L, (long)classData.getTotalFields());
        Assert.assertEquals((long)2L, (long)classData.getTotalConstructors());
        Assert.assertEquals((Object)classData, (Object)result);
        Assert.assertTrue((result.getTotalConstructors() > 0 ? 1 : 0) != 0);
        block4: for (int i = 0; i < result.getTotalConstructors(); ++i) {
            switch (result.getConstructorData(i).getTotalArgs()) {
                case 1: {
                    Assert.assertEquals((Object)"id", (Object)result.getConstructorData(i).getConstructorArgName(0));
                    Assert.assertEquals(Integer.class, (Object)result.getConstructorData(i).getConstructorArgType(0));
                    continue block4;
                }
                case 5: {
                    Assert.assertEquals((Object)"id", (Object)result.getConstructorData(i).getConstructorArgName(0));
                    Assert.assertEquals(Integer.class, (Object)result.getConstructorData(i).getConstructorArgType(0));
                    Assert.assertEquals((Object)"x", (Object)result.getConstructorData(i).getConstructorArgName(1));
                    Assert.assertEquals(Float.class, (Object)result.getConstructorData(i).getConstructorArgType(1));
                    Assert.assertEquals((Object)"y", (Object)result.getConstructorData(i).getConstructorArgName(2));
                    Assert.assertEquals(Float.class, (Object)result.getConstructorData(i).getConstructorArgType(2));
                    Assert.assertEquals((Object)"width", (Object)result.getConstructorData(i).getConstructorArgName(3));
                    Assert.assertEquals(Float.class, (Object)result.getConstructorData(i).getConstructorArgType(3));
                    Assert.assertEquals((Object)"height", (Object)result.getConstructorData(i).getConstructorArgName(4));
                    Assert.assertEquals(Float.class, (Object)result.getConstructorData(i).getConstructorArgType(4));
                    continue block4;
                }
                default: {
                    Assert.fail((String)"Incorrect number of constructor args");
                }
            }
        }
    }
}

