/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.serialization;

import java.util.ArrayList;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.exception.RequiredFieldException;
import org.mini2Dx.core.exception.SerializationException;
import org.mini2Dx.core.reflect.jvm.JvmReflection;
import org.mini2Dx.core.serialization.AotSerializationData;
import org.mini2Dx.core.serialization.JsonSerializer;
import org.mini2Dx.core.serialization.dummy.TestAbstractImplObject;
import org.mini2Dx.core.serialization.dummy.TestChildObject;
import org.mini2Dx.core.serialization.dummy.TestConstuctorArgObject;
import org.mini2Dx.core.serialization.dummy.TestEnum;
import org.mini2Dx.core.serialization.dummy.TestInterface;
import org.mini2Dx.core.serialization.dummy.TestInterfaceImpl;
import org.mini2Dx.core.serialization.dummy.TestParentObject;
import org.mini2Dx.gdx.utils.Array;
import org.mini2Dx.gdx.utils.IntArray;
import org.mini2Dx.gdx.utils.IntIntMap;
import org.mini2Dx.gdx.utils.IntSet;
import org.mini2Dx.gdx.utils.ObjectMap;

public class JsonSerializationTest {
    private JsonSerializer serializer;
    private TestParentObject parentObject;

    @Before
    public void setUp() {
        AotSerializationData.clear();
        Mdx.reflect = new JvmReflection();
        this.serializer = new JsonSerializer();
        this.parentObject = new TestParentObject();
        this.parentObject.setSuperField("super super");
        this.parentObject.setBooleanValue(true);
        this.parentObject.setByteValue((byte)1);
        this.parentObject.setFloatValue(2.5f);
        this.parentObject.setIgnoredValue(1);
        this.parentObject.setIntValue(255);
        this.parentObject.setEnumValue(TestEnum.OPTION_B);
        this.parentObject.setListValues(new ArrayList<String>());
        this.parentObject.getListValues().add("itemA");
        this.parentObject.getListValues().add("itemB");
        this.parentObject.setLongValue(Long.MAX_VALUE);
        this.parentObject.setMapValues(new HashMap<String, Integer>());
        this.parentObject.getMapValues().put("key", 77);
        this.parentObject.setShortValue((short)655);
        this.parentObject.setStringValue("hello");
        this.parentObject.setStringArrayValue(new String[]{"item1", "item2"});
        this.parentObject.setIntArrayValue(new int[]{1, 2, 3});
        this.parentObject.setChildObject(new TestChildObject(34));
        this.parentObject.setChildObjectArray(new TestChildObject[3]);
        this.parentObject.getChildObjectArray()[0] = new TestChildObject(51);
        this.parentObject.getChildObjectArray()[1] = new TestChildObject(57);
        this.parentObject.setChildren(new ArrayList<TestChildObject>());
        this.parentObject.getChildren().add(new TestChildObject(35));
        this.parentObject.getChildren().add(new TestChildObject(36));
        this.parentObject.setMapObjectValues(new HashMap<String, TestChildObject>());
        this.parentObject.getMapObjectValues().put("key1", new TestChildObject(100));
        this.parentObject.getMapObjectValues().put("key2", new TestChildObject(101));
        this.parentObject.setArgObject(new TestConstuctorArgObject("cargValue"));
        this.parentObject.setInterfaceObject(new TestInterfaceImpl("id-1"));
        this.parentObject.setInterfaceObjectList(new ArrayList<TestInterface>());
        this.parentObject.getInterfaceObjectList().add(new TestInterfaceImpl("id-3"));
        this.parentObject.getInterfaceObjectList().add(new TestInterfaceImpl("id-4"));
        this.parentObject.getFinalStringList().add("fstr1");
        this.parentObject.getFinalStringList().add("fstr2");
        this.parentObject.getFinalStringArray()[0] = "fstr3";
        this.parentObject.getFinalStringArray()[1] = "fstr4";
        this.parentObject.getFinalStringArray()[2] = "fstr5";
        this.parentObject.getFinalStringMap().put("fkey1", "fstr6");
        this.parentObject.getFinalStringMap().put("fkey2", "fstr7");
        this.parentObject.setAbstractObject(new TestAbstractImplObject());
        this.parentObject.getAbstractObject().setValue(91);
        this.parentObject.setGdxObjectMap((ObjectMap<String, String>)new ObjectMap());
        this.parentObject.getGdxObjectMap().put((Object)"testGdxKey", (Object)"testGdxValue");
        this.parentObject.setGdxArray((Array<String>)new Array());
        this.parentObject.getGdxArray().add((Object)"testGdxArrayValue");
        this.parentObject.setGdxIntArray(new IntArray());
        this.parentObject.getGdxIntArray().add(1);
        this.parentObject.getGdxIntArray().add(77);
        this.parentObject.setGdxIntSet(new IntSet());
        this.parentObject.getGdxIntSet().add(99);
        this.parentObject.getGdxIntSet().add(101);
        this.parentObject.setGdxIntIntMap(new IntIntMap());
        this.parentObject.getGdxIntIntMap().put(44, 55);
        this.parentObject.getGdxIntIntMap().put(66, 77);
    }

    @Test
    public void testJsonSerialization() throws SerializationException {
        this.testJsonSerialization(false);
    }

    @Test
    public void testJsonSerializationWithPrettyPrint() throws SerializationException {
        this.testJsonSerialization(true);
    }

    @Test(expected=RequiredFieldException.class)
    public void testJsonSerializationWithMissingRequiredField() throws SerializationException {
        String json = this.serializer.toJson((Object)this.parentObject);
        json = json.replace("intValue", "fintValue");
        this.serializer.fromJson(json, TestParentObject.class);
    }

    @Test
    public void testJsonSerializationWithAotData() throws SerializationException {
        AotSerializationData.registerClass(TestParentObject.class);
        this.testJsonSerialization(false);
    }

    private void testJsonSerialization(boolean prettyPrint) throws SerializationException {
        int i;
        int i2;
        int i3;
        String json = this.serializer.toJson((Object)this.parentObject, prettyPrint);
        Assert.assertEquals((Object)true, (Object)(json.length() > 2 ? 1 : 0));
        System.out.println(json);
        TestParentObject result = (TestParentObject)this.serializer.fromJson(json, TestParentObject.class);
        Assert.assertTrue((boolean)result.isPostDeserializeCalled());
        Assert.assertTrue((boolean)result.getChildObject().isPostDeserializeCalled());
        Assert.assertEquals((Object)this.parentObject.getSuperField(), (Object)result.getSuperField());
        Assert.assertEquals((Object)((Object)this.parentObject.getEnumValue()), (Object)((Object)result.getEnumValue()));
        Assert.assertEquals((Object)this.parentObject.isBooleanValue(), (Object)result.isBooleanValue());
        Assert.assertEquals((long)this.parentObject.getByteValue(), (long)result.getByteValue());
        Assert.assertEquals((float)this.parentObject.getFloatValue(), (float)result.getFloatValue(), (float)0.0f);
        Assert.assertEquals((long)this.parentObject.getIntValue(), (long)result.getIntValue());
        Assert.assertEquals((long)this.parentObject.getIntArrayValue().length, (long)result.getIntArrayValue().length);
        for (i3 = 0; i3 < this.parentObject.getIntArrayValue().length; ++i3) {
            Assert.assertEquals((long)this.parentObject.getIntArrayValue()[i3], (long)result.getIntArrayValue()[i3]);
        }
        Assert.assertEquals((long)this.parentObject.getLongValue(), (long)result.getLongValue());
        Assert.assertEquals((long)this.parentObject.getShortValue(), (long)result.getShortValue());
        Assert.assertEquals((Object)this.parentObject.getStringValue(), (Object)result.getStringValue());
        Assert.assertEquals((long)this.parentObject.getStringArrayValue().length, (long)result.getStringArrayValue().length);
        for (i3 = 0; i3 < this.parentObject.getStringArrayValue().length; ++i3) {
            Assert.assertEquals((Object)this.parentObject.getStringArrayValue()[i3], (Object)result.getStringArrayValue()[i3]);
        }
        Assert.assertEquals((long)this.parentObject.getListValues().size(), (long)result.getListValues().size());
        Assert.assertEquals(this.parentObject.getListValues(), result.getListValues());
        Assert.assertEquals((long)this.parentObject.getMapValues().size(), (long)result.getMapValues().size());
        for (String key : this.parentObject.getMapValues().keySet()) {
            Assert.assertEquals((Object)true, (Object)result.getMapValues().containsKey(key));
            Assert.assertEquals((Object)this.parentObject.getMapValues().get(key), (Object)result.getMapValues().get(key));
        }
        Assert.assertEquals((long)this.parentObject.getChildObject().getIntValue(), (long)result.getChildObject().getIntValue());
        Assert.assertEquals((long)this.parentObject.getChildObjectArray().length, (long)result.getChildObjectArray().length);
        for (i2 = 0; i2 < this.parentObject.getChildObjectArray().length; ++i2) {
            Assert.assertEquals((Object)this.parentObject.getChildObjectArray()[i2], (Object)result.getChildObjectArray()[i2]);
        }
        Assert.assertEquals((long)this.parentObject.getChildren().size(), (long)result.getChildren().size());
        for (i2 = 0; i2 < this.parentObject.getChildren().size(); ++i2) {
            Assert.assertEquals((long)this.parentObject.getChildren().get(i2).getIntValue(), (long)result.getChildren().get(i2).getIntValue());
        }
        Assert.assertEquals((Object)this.parentObject.getArgObject(), (Object)result.getArgObject());
        Assert.assertNotSame((Object)this.parentObject.getIgnoredValue(), (Object)result.getIgnoredValue());
        Assert.assertEquals((Object)this.parentObject.getInterfaceObject(), (Object)result.getInterfaceObject());
        Assert.assertEquals((long)this.parentObject.getInterfaceObjectList().size(), (long)result.getInterfaceObjectList().size());
        for (i2 = 0; i2 < this.parentObject.getInterfaceObjectList().size(); ++i2) {
            Assert.assertEquals((Object)this.parentObject.getInterfaceObjectList().get(i2), (Object)result.getInterfaceObjectList().get(i2));
        }
        Assert.assertEquals((long)this.parentObject.getFinalStringList().size(), (long)result.getFinalStringList().size());
        for (i2 = 0; i2 < this.parentObject.getFinalStringList().size(); ++i2) {
            Assert.assertEquals((Object)this.parentObject.getFinalStringList().get(i2), (Object)result.getFinalStringList().get(i2));
        }
        Assert.assertEquals((long)this.parentObject.getFinalStringMap().size(), (long)result.getFinalStringMap().size());
        for (String key : this.parentObject.getFinalStringMap().keySet()) {
            Assert.assertEquals((Object)this.parentObject.getFinalStringMap().get(key), (Object)result.getFinalStringMap().get(key));
        }
        Assert.assertEquals((long)this.parentObject.getFinalStringArray().length, (long)result.getFinalStringArray().length);
        for (int i4 = 0; i4 < this.parentObject.getFinalStringArray().length; ++i4) {
            Assert.assertEquals((Object)this.parentObject.getFinalStringArray()[i4], (Object)result.getFinalStringArray()[i4]);
        }
        Assert.assertEquals((long)this.parentObject.getAbstractObject().getValue(), (long)result.getAbstractObject().getValue());
        Assert.assertEquals((long)this.parentObject.getGdxObjectMap().size, (long)result.getGdxObjectMap().size);
        ObjectMap.Entries entries = this.parentObject.getGdxObjectMap().entries();
        while (entries.hasNext()) {
            ObjectMap.Entry entry = entries.next();
            Assert.assertEquals((Object)entry.value, (Object)result.getGdxObjectMap().get(entry.key));
        }
        Assert.assertEquals((long)this.parentObject.getGdxArray().size, (long)result.getGdxArray().size);
        for (i = 0; i < this.parentObject.getGdxArray().size; ++i) {
            Assert.assertEquals((Object)this.parentObject.getGdxArray().get(i), (Object)result.getGdxArray().get(i));
        }
        Assert.assertEquals((long)this.parentObject.getGdxIntArray().size, (long)result.getGdxIntArray().size);
        for (i = 0; i < this.parentObject.getGdxIntArray().size; ++i) {
            Assert.assertEquals((long)this.parentObject.getGdxIntArray().get(i), (long)result.getGdxIntArray().get(i));
        }
        Assert.assertEquals((long)this.parentObject.getGdxIntSet().size, (long)result.getGdxIntSet().size);
        Assert.assertEquals((Object)this.parentObject.getGdxIntSet(), (Object)result.getGdxIntSet());
        Assert.assertEquals((long)this.parentObject.getGdxIntIntMap().size, (long)result.getGdxIntIntMap().size);
        Assert.assertEquals((Object)this.parentObject.getGdxIntIntMap(), (Object)result.getGdxIntIntMap());
    }
}

