/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.core.serialization;

import java.util.ArrayList;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.exception.SerializationException;
import org.mini2Dx.core.reflect.jvm.JvmReflection;
import org.mini2Dx.core.serialization.AotSerializationData;
import org.mini2Dx.core.serialization.XmlSerializer;
import org.mini2Dx.core.serialization.dummy.TestAbstractImplObject;
import org.mini2Dx.core.serialization.dummy.TestChildObject;
import org.mini2Dx.core.serialization.dummy.TestComplexConstructorArgObject;
import org.mini2Dx.core.serialization.dummy.TestComplexConstructorParentObject;
import org.mini2Dx.core.serialization.dummy.TestConstuctorArgObject;
import org.mini2Dx.core.serialization.dummy.TestEnum;
import org.mini2Dx.core.serialization.dummy.TestInterface;
import org.mini2Dx.core.serialization.dummy.TestInterfaceImpl;
import org.mini2Dx.core.serialization.dummy.TestParentObject;
import org.mini2Dx.gdx.utils.Array;
import org.mini2Dx.gdx.utils.IntArray;
import org.mini2Dx.gdx.utils.IntIntMap;
import org.mini2Dx.gdx.utils.IntSet;
import org.mini2Dx.gdx.utils.ObjectMap;

public class XmlSerializationTest {
    private XmlSerializer xmlSerializer;
    private TestParentObject parentObject;

    @Before
    public void setUp() {
        Mdx.reflect = new JvmReflection();
        AotSerializationData.clear();
        this.xmlSerializer = new XmlSerializer();
        this.parentObject = this.createTestParentObject();
    }

    @Test
    public void testXmlSerialization() throws SerializationException {
        int i;
        int i2;
        int i3;
        int i4;
        String xml = this.xmlSerializer.toXml((Object)this.parentObject);
        Assert.assertEquals((Object)true, (Object)(xml.length() > 2 ? 1 : 0));
        System.out.println(xml);
        TestParentObject result = (TestParentObject)this.xmlSerializer.fromXml(xml, TestParentObject.class);
        Assert.assertTrue((boolean)result.isPostDeserializeCalled());
        Assert.assertTrue((boolean)result.getChildObject().isPostDeserializeCalled());
        Assert.assertEquals((Object)this.parentObject.getSuperField(), (Object)result.getSuperField());
        Assert.assertEquals((Object)((Object)this.parentObject.getEnumValue()), (Object)((Object)result.getEnumValue()));
        Assert.assertEquals((Object)this.parentObject.isBooleanValue(), (Object)result.isBooleanValue());
        Assert.assertEquals((long)this.parentObject.getByteValue(), (long)result.getByteValue());
        Assert.assertEquals((float)this.parentObject.getFloatValue(), (float)result.getFloatValue(), (float)0.0f);
        Assert.assertEquals((long)this.parentObject.getIntValue(), (long)result.getIntValue());
        Assert.assertEquals((long)this.parentObject.getIntArrayValue().length, (long)result.getIntArrayValue().length);
        for (i4 = 0; i4 < this.parentObject.getIntArrayValue().length; ++i4) {
            Assert.assertEquals((long)this.parentObject.getIntArrayValue()[i4], (long)result.getIntArrayValue()[i4]);
        }
        Assert.assertEquals((long)this.parentObject.getLongValue(), (long)result.getLongValue());
        Assert.assertEquals((long)this.parentObject.getShortValue(), (long)result.getShortValue());
        Assert.assertEquals((Object)this.parentObject.getStringValue(), (Object)result.getStringValue());
        Assert.assertEquals((long)this.parentObject.getStringArrayValue().length, (long)result.getStringArrayValue().length);
        for (i4 = 0; i4 < this.parentObject.getStringArrayValue().length; ++i4) {
            Assert.assertEquals((Object)this.parentObject.getStringArrayValue()[i4], (Object)result.getStringArrayValue()[i4]);
        }
        Assert.assertEquals((long)this.parentObject.getListValues().size(), (long)result.getListValues().size());
        Assert.assertEquals(this.parentObject.getListValues(), result.getListValues());
        Assert.assertEquals((long)this.parentObject.getMapValues().size(), (long)result.getMapValues().size());
        for (String key : this.parentObject.getMapValues().keySet()) {
            Assert.assertEquals((Object)true, (Object)result.getMapValues().containsKey(key));
            Assert.assertEquals((Object)this.parentObject.getMapValues().get(key), (Object)result.getMapValues().get(key));
        }
        Assert.assertEquals((long)this.parentObject.getChildObject().getIntValue(), (long)result.getChildObject().getIntValue());
        Assert.assertEquals((long)this.parentObject.getChildObjectArray().length, (long)result.getChildObjectArray().length);
        for (i3 = 0; i3 < this.parentObject.getChildObjectArray().length; ++i3) {
            Assert.assertEquals((Object)this.parentObject.getChildObjectArray()[i3], (Object)result.getChildObjectArray()[i3]);
        }
        Assert.assertEquals((long)this.parentObject.getChildren().size(), (long)result.getChildren().size());
        for (i3 = 0; i3 < this.parentObject.getChildren().size(); ++i3) {
            Assert.assertEquals((long)this.parentObject.getChildren().get(i3).getIntValue(), (long)result.getChildren().get(i3).getIntValue());
        }
        Assert.assertEquals((long)this.parentObject.getMapObjectValues().size(), (long)result.getMapObjectValues().size());
        for (String key : this.parentObject.getMapObjectValues().keySet()) {
            Assert.assertEquals((Object)true, (Object)result.getMapObjectValues().containsKey(key));
            Assert.assertEquals((Object)this.parentObject.getMapObjectValues().get(key), (Object)result.getMapObjectValues().get(key));
        }
        Assert.assertNotSame((Object)this.parentObject.getIgnoredValue(), (Object)result.getIgnoredValue());
        Assert.assertEquals((Object)this.parentObject.getInterfaceObject(), (Object)result.getInterfaceObject());
        Assert.assertEquals((long)this.parentObject.getInterfaceObjectList().size(), (long)result.getInterfaceObjectList().size());
        for (i2 = 0; i2 < this.parentObject.getInterfaceObjectList().size(); ++i2) {
            Assert.assertEquals((Object)this.parentObject.getInterfaceObjectList().get(i2), (Object)result.getInterfaceObjectList().get(i2));
        }
        Assert.assertEquals((long)this.parentObject.getFinalStringList().size(), (long)result.getFinalStringList().size());
        for (i2 = 0; i2 < this.parentObject.getFinalStringList().size(); ++i2) {
            Assert.assertEquals((Object)this.parentObject.getFinalStringList().get(i2), (Object)result.getFinalStringList().get(i2));
        }
        Assert.assertEquals((long)this.parentObject.getFinalStringMap().size(), (long)result.getFinalStringMap().size());
        for (String key : this.parentObject.getFinalStringMap().keySet()) {
            Assert.assertEquals((Object)this.parentObject.getFinalStringMap().get(key), (Object)result.getFinalStringMap().get(key));
        }
        Assert.assertEquals((long)this.parentObject.getFinalStringArray().length, (long)result.getFinalStringArray().length);
        for (int i5 = 0; i5 < this.parentObject.getFinalStringArray().length; ++i5) {
            Assert.assertEquals((Object)this.parentObject.getFinalStringArray()[i5], (Object)result.getFinalStringArray()[i5]);
        }
        Assert.assertEquals((long)this.parentObject.getAbstractObject().getValue(), (long)result.getAbstractObject().getValue());
        Assert.assertEquals((long)this.parentObject.getGdxObjectMap().size, (long)result.getGdxObjectMap().size);
        ObjectMap.Entries entries = this.parentObject.getGdxObjectMap().entries();
        while (entries.hasNext()) {
            ObjectMap.Entry entry = entries.next();
            Assert.assertEquals((Object)entry.value, (Object)result.getGdxObjectMap().get(entry.key));
        }
        Assert.assertEquals((long)this.parentObject.getGdxArray().size, (long)result.getGdxArray().size);
        for (i = 0; i < this.parentObject.getGdxArray().size; ++i) {
            Assert.assertEquals((Object)this.parentObject.getGdxArray().get(i), (Object)result.getGdxArray().get(i));
        }
        Assert.assertEquals((long)this.parentObject.getGdxIntArray().size, (long)result.getGdxIntArray().size);
        for (i = 0; i < this.parentObject.getGdxIntArray().size; ++i) {
            Assert.assertEquals((long)this.parentObject.getGdxIntArray().get(i), (long)result.getGdxIntArray().get(i));
        }
        Assert.assertEquals((long)this.parentObject.getGdxIntSet().size, (long)result.getGdxIntSet().size);
        Assert.assertEquals((Object)this.parentObject.getGdxIntSet(), (Object)result.getGdxIntSet());
        Assert.assertEquals((long)this.parentObject.getGdxIntIntMap().size, (long)result.getGdxIntIntMap().size);
        Assert.assertEquals((Object)this.parentObject.getGdxIntIntMap(), (Object)result.getGdxIntIntMap());
    }

    @Test
    public void testXmlSerializationWithNullField() throws SerializationException {
        this.parentObject.getFinalStringMap().put("test", null);
        String xml = this.xmlSerializer.toXml((Object)this.parentObject);
        this.xmlSerializer.fromXml(xml, TestParentObject.class);
    }

    @Test
    public void testXmlSerializationWithAotData() throws SerializationException {
        String xml = this.xmlSerializer.toXml((Object)this.parentObject);
        Assert.assertEquals((Object)true, (Object)(xml.length() > 2 ? 1 : 0));
        System.out.println(xml);
        this.xmlSerializer.fromXml(xml, TestParentObject.class);
    }

    @Test
    public void testPrettyXmlDeserialization() throws SerializationException {
        int i;
        int i2;
        int i3;
        String xml = "<?xml version=\"1.0\"?>\n";
        xml = xml + "<data>\n";
        xml = xml + "    <intValue>255</intValue>\n";
        xml = xml + "    <booleanValue>true</booleanValue>\n";
        xml = xml + "    <byteValue>1</byteValue>\n";
        xml = xml + "    <shortValue>655</shortValue>\n";
        xml = xml + "    <longValue>9223372036854775807</longValue>\n";
        xml = xml + "    <floatValue>2.5</floatValue>\n";
        xml = xml + "    <intArrayValue length=\"3\">\n";
        xml = xml + "        <value>1</value>\n";
        xml = xml + "        <value>2</value>\n";
        xml = xml + "        <value>3</value>\n";
        xml = xml + "    </intArrayValue>\n";
        xml = xml + "    <stringArrayValue length=\"2\">\n";
        xml = xml + "        <value>item1</value>\n";
        xml = xml + "        <value>item2</value>\n";
        xml = xml + "    </stringArrayValue>\n";
        xml = xml + "    <stringValue>hello</stringValue>\n";
        xml = xml + "    <enumValue>OPTION_B</enumValue>\n";
        xml = xml + "    <mapValues>\n";
        xml = xml + "        <entry>\n";
        xml = xml + "            <key>key</key>\n";
        xml = xml + "            <value>77</value>\n";
        xml = xml + "        </entry>\n";
        xml = xml + "    </mapValues>\n";
        xml = xml + "    <listValues>\n";
        xml = xml + "        <value>itemA</value>\n";
        xml = xml + "        <value>itemB</value>\n";
        xml = xml + "    </listValues>\n";
        xml = xml + "    <childObject>\n";
        xml = xml + "        <intValue>34</intValue>\n";
        xml = xml + "    </childObject>\n";
        xml = xml + "    <childObjectArray length=\"3\">\n";
        xml = xml + "        <value>\n";
        xml = xml + "            <intValue>51</intValue>\n";
        xml = xml + "        </value>\n";
        xml = xml + "        <value>\n";
        xml = xml + "            <intValue>57</intValue>\n";
        xml = xml + "        </value>\n";
        xml = xml + "    </childObjectArray>\n";
        xml = xml + "    <optionalChildObject/>\n";
        xml = xml + "    <children>\n";
        xml = xml + "        <value>\n";
        xml = xml + "            <intValue>35</intValue>\n";
        xml = xml + "        </value>\n";
        xml = xml + "        <value>\n";
        xml = xml + "            <intValue>36</intValue>\n";
        xml = xml + "        </value>\n";
        xml = xml + "    </children>\n";
        xml = xml + "    <superField>super super</superField>\n";
        xml = xml + "    <argObject argValue=\"cargValue\">\n";
        xml = xml + "    </argObject>\n";
        xml = xml + "    <interfaceObject id=\"id-5\" class=\"org.mini2Dx.core.serialization.dummy.TestInterfaceImpl\">\n";
        xml = xml + "    </interfaceObject>\n";
        xml = xml + "    <interfaceObjectList>\n";
        xml = xml + "        <value id=\"id-3\" class=\"org.mini2Dx.core.serialization.dummy.TestInterfaceImpl\">\n";
        xml = xml + "        </value>\n";
        xml = xml + "        <value id=\"id-4\" class=\"org.mini2Dx.core.serialization.dummy.TestInterfaceImpl\">\n";
        xml = xml + "        </value>\n";
        xml = xml + "    </interfaceObjectList>\n";
        xml = xml + "    <finalStringList>\n";
        xml = xml + "        <value>fstr1</value>\n";
        xml = xml + "        <value>fstr2</value>\n";
        xml = xml + "    </finalStringList>\n";
        xml = xml + "    <finalStringArray length=\"3\">\n";
        xml = xml + "        <value>fstr3</value>\n";
        xml = xml + "        <value>fstr4</value>\n";
        xml = xml + "        <value>fstr5</value>\n";
        xml = xml + "    </finalStringArray>\n";
        xml = xml + "    <finalStringMap>\n";
        xml = xml + "        <entry>\n";
        xml = xml + "            <key>fkey1</key>\n";
        xml = xml + "            <value>fstr6</value>\n";
        xml = xml + "        </entry>\n";
        xml = xml + "        <entry>\n";
        xml = xml + "            <key>fkey2</key>\n";
        xml = xml + "            <value>fstr7</value>\n";
        xml = xml + "        </entry>\n";
        xml = xml + "    </finalStringMap>\n";
        xml = xml + "    <abstractObject class=\"org.mini2Dx.core.serialization.dummy.TestAbstractImplObject\">\n";
        xml = xml + "        <value>91</value>\n";
        xml = xml + "    </abstractObject>\n";
        xml = xml + "    <gdxObjectMap>\n";
        xml = xml + "        <entry>\n";
        xml = xml + "            <key>testGdxKey</key>\n";
        xml = xml + "            <value>testGdxValue</value>\n";
        xml = xml + "        </entry>\n";
        xml = xml + "    </gdxObjectMap>\n";
        xml = xml + "    <gdxArray>\n";
        xml = xml + "        <value>testGdxArrayValue</value>\n";
        xml = xml + "    </gdxArray>\n";
        xml = xml + "    <gdxIntArray>\n";
        xml = xml + "        <value>1</value>\n";
        xml = xml + "        <value>77</value>\n";
        xml = xml + "    </gdxIntArray>\n";
        xml = xml + "    <gdxIntSet>\n";
        xml = xml + "        <value>99</value>\n";
        xml = xml + "        <value>101</value>\n";
        xml = xml + "    </gdxIntSet>\n";
        xml = xml + "    <gdxIntIntMap>\n";
        xml = xml + "        <entry>\n";
        xml = xml + "            <key>44</key>\n";
        xml = xml + "            <value>55</value>\n";
        xml = xml + "        </entry>\n";
        xml = xml + "        <entry>\n";
        xml = xml + "            <key>66</key>\n";
        xml = xml + "            <value>77</value>\n";
        xml = xml + "        </entry>\n";
        xml = xml + "    </gdxIntIntMap>\n";
        xml = xml + "</data>";
        TestParentObject result = (TestParentObject)this.xmlSerializer.fromXml(xml, TestParentObject.class);
        Assert.assertEquals((long)this.parentObject.getByteValue(), (long)result.getByteValue());
        Assert.assertEquals((float)this.parentObject.getFloatValue(), (float)result.getFloatValue(), (float)0.0f);
        Assert.assertEquals((long)this.parentObject.getIntValue(), (long)result.getIntValue());
        Assert.assertEquals((Object)this.parentObject.isBooleanValue(), (Object)result.isBooleanValue());
        Assert.assertEquals((Object)((Object)this.parentObject.getEnumValue()), (Object)((Object)result.getEnumValue()));
        Assert.assertEquals((long)this.parentObject.getIntArrayValue().length, (long)result.getIntArrayValue().length);
        for (i3 = 0; i3 < this.parentObject.getIntArrayValue().length; ++i3) {
            Assert.assertEquals((long)this.parentObject.getIntArrayValue()[i3], (long)result.getIntArrayValue()[i3]);
        }
        Assert.assertEquals((long)this.parentObject.getLongValue(), (long)result.getLongValue());
        Assert.assertEquals((long)this.parentObject.getShortValue(), (long)result.getShortValue());
        Assert.assertEquals((Object)this.parentObject.getStringValue(), (Object)result.getStringValue());
        Assert.assertEquals((long)this.parentObject.getStringArrayValue().length, (long)result.getStringArrayValue().length);
        for (i3 = 0; i3 < this.parentObject.getStringArrayValue().length; ++i3) {
            Assert.assertEquals((Object)this.parentObject.getStringArrayValue()[i3], (Object)result.getStringArrayValue()[i3]);
        }
        Assert.assertEquals((long)this.parentObject.getListValues().size(), (long)result.getListValues().size());
        Assert.assertEquals(this.parentObject.getListValues(), result.getListValues());
        Assert.assertEquals((long)this.parentObject.getMapValues().size(), (long)result.getMapValues().size());
        for (String key : this.parentObject.getMapValues().keySet()) {
            Assert.assertEquals((Object)true, (Object)result.getMapValues().containsKey(key));
            Assert.assertEquals((Object)this.parentObject.getMapValues().get(key), (Object)result.getMapValues().get(key));
        }
        Assert.assertEquals((long)this.parentObject.getChildObject().getIntValue(), (long)result.getChildObject().getIntValue());
        Assert.assertEquals((long)this.parentObject.getChildObjectArray().length, (long)result.getChildObjectArray().length);
        for (i2 = 0; i2 < this.parentObject.getChildObjectArray().length; ++i2) {
            Assert.assertEquals((Object)this.parentObject.getChildObjectArray()[i2], (Object)result.getChildObjectArray()[i2]);
        }
        Assert.assertEquals((long)this.parentObject.getChildren().size(), (long)result.getChildren().size());
        for (i2 = 0; i2 < this.parentObject.getChildren().size(); ++i2) {
            Assert.assertEquals((long)this.parentObject.getChildren().get(i2).getIntValue(), (long)result.getChildren().get(i2).getIntValue());
        }
        Assert.assertNotSame((Object)this.parentObject.getIgnoredValue(), (Object)result.getIgnoredValue());
        Assert.assertEquals((Object)this.parentObject.getInterfaceObject(), (Object)result.getInterfaceObject());
        Assert.assertEquals((long)this.parentObject.getInterfaceObjectList().size(), (long)result.getInterfaceObjectList().size());
        for (i2 = 0; i2 < this.parentObject.getInterfaceObjectList().size(); ++i2) {
            Assert.assertEquals((Object)this.parentObject.getInterfaceObjectList().get(i2), (Object)result.getInterfaceObjectList().get(i2));
        }
        Assert.assertEquals((long)this.parentObject.getAbstractObject().getValue(), (long)result.getAbstractObject().getValue());
        Assert.assertEquals((long)this.parentObject.getGdxObjectMap().size, (long)result.getGdxObjectMap().size);
        ObjectMap.Entries entries = this.parentObject.getGdxObjectMap().entries();
        while (entries.hasNext()) {
            ObjectMap.Entry entry = entries.next();
            Assert.assertEquals((Object)entry.value, (Object)result.getGdxObjectMap().get(entry.key));
        }
        Assert.assertEquals((long)this.parentObject.getGdxArray().size, (long)result.getGdxArray().size);
        for (i = 0; i < this.parentObject.getGdxArray().size; ++i) {
            Assert.assertEquals((Object)this.parentObject.getGdxArray().get(i), (Object)result.getGdxArray().get(i));
        }
        Assert.assertEquals((long)this.parentObject.getGdxIntArray().size, (long)result.getGdxIntArray().size);
        for (i = 0; i < this.parentObject.getGdxIntArray().size; ++i) {
            Assert.assertEquals((long)this.parentObject.getGdxIntArray().get(i), (long)result.getGdxIntArray().get(i));
        }
        Assert.assertEquals((long)this.parentObject.getGdxIntSet().size, (long)result.getGdxIntSet().size);
        Assert.assertEquals((Object)this.parentObject.getGdxIntSet(), (Object)result.getGdxIntSet());
        Assert.assertEquals((long)this.parentObject.getGdxIntIntMap().size, (long)result.getGdxIntIntMap().size);
        Assert.assertEquals((Object)this.parentObject.getGdxIntIntMap(), (Object)result.getGdxIntIntMap());
        Assert.assertEquals((Object)this.parentObject.getSuperField(), (Object)result.getSuperField());
    }

    @Test
    public void testComplexConstructorMatching() throws SerializationException {
        TestComplexConstructorArgObject expected1 = new TestComplexConstructorArgObject();
        String xml = this.xmlSerializer.toXml((Object)expected1);
        System.out.println(xml);
        TestComplexConstructorArgObject result1 = (TestComplexConstructorArgObject)this.xmlSerializer.fromXml(xml, TestComplexConstructorArgObject.class);
        Assert.assertEquals((Object)expected1, (Object)result1);
        result1 = (TestComplexConstructorArgObject)this.xmlSerializer.fromXml("<?xml version=\"1.0\" ?><data></data>", TestComplexConstructorArgObject.class);
        Assert.assertEquals((Object)expected1, (Object)result1);
        TestComplexConstructorArgObject expected2 = new TestComplexConstructorArgObject(99);
        xml = this.xmlSerializer.toXml((Object)expected2);
        TestComplexConstructorArgObject result2 = (TestComplexConstructorArgObject)this.xmlSerializer.fromXml(xml, TestComplexConstructorArgObject.class);
        Assert.assertEquals((Object)expected2, (Object)result2);
        result2 = (TestComplexConstructorArgObject)this.xmlSerializer.fromXml("<?xml version=\"1.0\" ?><data id=\"99\"></data>", TestComplexConstructorArgObject.class);
        Assert.assertEquals((Object)expected2, (Object)result2);
        TestComplexConstructorArgObject expected3 = new TestComplexConstructorArgObject(101, 1.0f, 2.0f, 3.0f, 4.0f);
        xml = this.xmlSerializer.toXml((Object)expected3);
        TestComplexConstructorArgObject result3 = (TestComplexConstructorArgObject)this.xmlSerializer.fromXml(xml, TestComplexConstructorArgObject.class);
        Assert.assertEquals((Object)expected3, (Object)result3);
        result3 = (TestComplexConstructorArgObject)this.xmlSerializer.fromXml("<?xml version=\"1.0\" ?><data id=\"101\" x=\"1\" y=\"2\" width=\"3\" height=\"4\"></data>", TestComplexConstructorArgObject.class);
        Assert.assertEquals((Object)expected3, (Object)result3);
        TestComplexConstructorParentObject expected4 = new TestComplexConstructorParentObject();
        expected4.getChildren().add((Object)expected3);
        xml = this.xmlSerializer.toXml((Object)expected4);
        System.out.println(xml);
        TestComplexConstructorParentObject result4 = (TestComplexConstructorParentObject)this.xmlSerializer.fromXml(xml, TestComplexConstructorParentObject.class);
        Assert.assertEquals((Object)expected4, (Object)result4);
        result4 = (TestComplexConstructorParentObject)this.xmlSerializer.fromXml("<?xml version=\"1.0\" ?><data><children length=\"1\"><value class=\"org.mini2Dx.core.serialization.dummy.TestComplexConstructorArgObject\" id=\"101\" width=\"3\" height=\"4\" x=\"1\" y=\"2\"></value></children></data>", TestComplexConstructorParentObject.class);
        Assert.assertEquals((Object)expected4, (Object)result4);
    }

    protected TestParentObject createTestParentObject() {
        TestParentObject parentObject = new TestParentObject();
        parentObject.setSuperField("super super");
        parentObject.setBooleanValue(true);
        parentObject.setByteValue((byte)1);
        parentObject.setFloatValue(2.5f);
        parentObject.setIgnoredValue(1);
        parentObject.setIntValue(255);
        parentObject.setEnumValue(TestEnum.OPTION_B);
        parentObject.setListValues(new ArrayList<String>());
        parentObject.getListValues().add("itemA");
        parentObject.getListValues().add("itemB");
        parentObject.setLongValue(Long.MAX_VALUE);
        parentObject.setMapValues(new HashMap<String, Integer>());
        parentObject.getMapValues().put("key", 77);
        parentObject.setShortValue((short)655);
        parentObject.setStringValue("hello");
        parentObject.setStringArrayValue(new String[]{"item1", "item2"});
        parentObject.setIntArrayValue(new int[]{1, 2, 3});
        parentObject.setChildObject(new TestChildObject(34));
        parentObject.setChildObjectArray(new TestChildObject[3]);
        parentObject.getChildObjectArray()[0] = new TestChildObject(51);
        parentObject.getChildObjectArray()[1] = new TestChildObject(57);
        parentObject.setChildren(new ArrayList<TestChildObject>());
        parentObject.getChildren().add(new TestChildObject(35));
        parentObject.getChildren().add(new TestChildObject(36));
        parentObject.setMapObjectValues(new HashMap<String, TestChildObject>());
        parentObject.getMapObjectValues().put("key1", new TestChildObject(100));
        parentObject.getMapObjectValues().put("key2", new TestChildObject(101));
        parentObject.setArgObject(new TestConstuctorArgObject("cargValue"));
        parentObject.setInterfaceObject(new TestInterfaceImpl("id-5"));
        parentObject.setInterfaceObjectList(new ArrayList<TestInterface>());
        parentObject.getInterfaceObjectList().add(new TestInterfaceImpl("id-3"));
        parentObject.getInterfaceObjectList().add(new TestInterfaceImpl("id-4"));
        parentObject.getFinalStringList().add("fstr1");
        parentObject.getFinalStringList().add("fstr2");
        parentObject.getFinalStringArray()[0] = "fstr3";
        parentObject.getFinalStringArray()[1] = "fstr4";
        parentObject.getFinalStringArray()[2] = "fstr5";
        parentObject.getFinalStringMap().put("fkey1", "fstr6");
        parentObject.getFinalStringMap().put("fkey2", "fstr7");
        parentObject.setAbstractObject(new TestAbstractImplObject());
        parentObject.getAbstractObject().setValue(91);
        parentObject.setGdxObjectMap((ObjectMap<String, String>)new ObjectMap());
        parentObject.getGdxObjectMap().put((Object)"testGdxKey", (Object)"testGdxValue");
        parentObject.setGdxArray((Array<String>)new Array());
        parentObject.getGdxArray().add((Object)"testGdxArrayValue");
        parentObject.setGdxIntArray(new IntArray());
        parentObject.getGdxIntArray().add(1);
        parentObject.getGdxIntArray().add(77);
        parentObject.setGdxIntSet(new IntSet());
        parentObject.getGdxIntSet().add(99);
        parentObject.getGdxIntSet().add(101);
        parentObject.setGdxIntIntMap(new IntIntMap());
        parentObject.getGdxIntIntMap().put(44, 55);
        parentObject.getGdxIntIntMap().put(66, 77);
        return parentObject;
    }
}

