/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.headless;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.ApplicationLogger;
import com.badlogic.gdx.Audio;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.LifecycleListener;
import com.badlogic.gdx.Net;
import com.badlogic.gdx.Preferences;
import com.badlogic.gdx.backends.headless.HeadlessApplicationLogger;
import com.badlogic.gdx.backends.headless.HeadlessFiles;
import com.badlogic.gdx.backends.headless.HeadlessNet;
import com.badlogic.gdx.backends.headless.HeadlessPreferences;
import com.badlogic.gdx.backends.headless.mock.audio.MockAudio;
import com.badlogic.gdx.backends.headless.mock.graphics.Mini2DxMockGraphics;
import com.badlogic.gdx.backends.headless.mock.input.MockInput;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Clipboard;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.game.ApplicationListener;
import org.mini2Dx.core.game.GameContainer;
import org.mini2Dx.headless.HeadlessGameWrapper;
import org.mini2Dx.headless.HeadlessMini2DxConfig;

public class HeadlessMini2DxGame
implements Application {
    protected final HeadlessMini2DxConfig config;
    protected final Mini2DxMockGraphics graphics;
    protected MockAudio audio;
    protected final HeadlessFiles files;
    protected final MockInput input;
    protected final HeadlessNet net;
    protected final ApplicationListener listener;
    protected Thread mainLoopThread;
    protected boolean running = true;
    protected final Array<Runnable> runnables = new Array();
    protected final Array<Runnable> executedRunnables = new Array();
    protected final Array<LifecycleListener> lifecycleListeners = new Array();
    protected int logLevel = 2;
    protected ApplicationLogger applicationLogger;
    protected String preferencesdir;
    ObjectMap<String, Preferences> preferences = new ObjectMap();

    public HeadlessMini2DxGame(GameContainer game, HeadlessMini2DxConfig config) {
        this.setApplicationLogger((ApplicationLogger)new HeadlessApplicationLogger());
        this.config = config;
        this.listener = new HeadlessGameWrapper(game, config.gameIdentifier);
        this.files = new HeadlessFiles();
        this.net = new HeadlessNet();
        this.graphics = new Mini2DxMockGraphics(config);
        this.audio = new MockAudio();
        this.input = new MockInput();
        this.initialiseLibGDX();
        if (config.runGame) {
            this.launchGame();
        } else {
            this.listener.create();
        }
    }

    private void initialiseLibGDX() {
        this.preferencesdir = this.config.preferencesDirectory;
        Gdx.app = this;
        Gdx.graphics = this.graphics;
        Gdx.audio = this.audio;
        Gdx.files = this.files;
        Gdx.input = this.input;
        Gdx.net = this.net;
    }

    private void launchGame() {
        this.mainLoopThread = new Thread("Headless Application"){

            @Override
            public void run() {
                try {
                    HeadlessMini2DxGame.this.executeGame();
                }
                catch (Throwable t) {
                    if (t instanceof RuntimeException) {
                        throw (RuntimeException)t;
                    }
                    throw new GdxRuntimeException(t);
                }
            }
        };
        this.mainLoopThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executeGame() {
        Array<LifecycleListener> lifecycleListeners = this.lifecycleListeners;
        this.listener.create();
        int frameRate = this.config.targetFPS;
        float maximumDelta = 1.0f / (float)frameRate;
        long fpsDeltaNanos = (long)(maximumDelta * 1.0E9f);
        float accumulator = 0.0f;
        float targetTimestep = this.config.targetTimestep;
        while (this.running) {
            this.graphics.updateTime();
            Mdx.performanceTracker.markFrame();
            this.graphics.incrementFrameId();
            this.executeRunnables();
            if (!this.running) break;
            float delta = this.graphics.getDeltaTime();
            if (delta > maximumDelta) {
                delta = maximumDelta;
            }
            accumulator += delta;
            while (accumulator >= targetTimestep) {
                Mdx.performanceTracker.markUpdateBegin();
                this.listener.update(targetTimestep);
                Mdx.performanceTracker.markUpdateEnd();
                accumulator -= targetTimestep;
            }
            this.listener.interpolate(accumulator / targetTimestep);
            this.listener.render();
            if (frameRate <= 0) continue;
            this.graphics.sleepTillDeltaTime(fpsDeltaNanos);
        }
        Array<LifecycleListener> array = lifecycleListeners;
        synchronized (array) {
            for (LifecycleListener listener : lifecycleListeners) {
                listener.pause();
                listener.dispose();
            }
        }
        this.listener.pause();
        this.listener.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeRunnables() {
        Array<Runnable> array = this.runnables;
        synchronized (array) {
            for (int i = this.runnables.size - 1; i >= 0; --i) {
                this.executedRunnables.add(this.runnables.get(i));
            }
            this.runnables.clear();
        }
        if (this.executedRunnables.size == 0) {
            return false;
        }
        do {
            ((Runnable)this.executedRunnables.pop()).run();
        } while (this.executedRunnables.size > 0);
        return true;
    }

    public ApplicationListener getApplicationListener() {
        return this.listener;
    }

    public Audio getAudio() {
        return this.audio;
    }

    public Files getFiles() {
        return this.files;
    }

    public Graphics getGraphics() {
        return this.graphics;
    }

    public Input getInput() {
        return this.input;
    }

    public Net getNet() {
        return this.net;
    }

    public Application.ApplicationType getType() {
        return Application.ApplicationType.HeadlessDesktop;
    }

    public int getVersion() {
        return 0;
    }

    public void stop() {
        this.running = false;
        try {
            this.mainLoopThread.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public long getJavaHeap() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    public long getNativeHeap() {
        return this.getJavaHeap();
    }

    public Preferences getPreferences(String name) {
        if (this.preferences.containsKey((Object)name)) {
            return (Preferences)this.preferences.get((Object)name);
        }
        HeadlessPreferences prefs = new HeadlessPreferences(name, this.preferencesdir);
        this.preferences.put((Object)name, (Object)prefs);
        return prefs;
    }

    public Clipboard getClipboard() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postRunnable(Runnable runnable) {
        Array<Runnable> array = this.runnables;
        synchronized (array) {
            this.runnables.add((Object)runnable);
        }
    }

    public void debug(String tag, String message) {
        if (this.logLevel >= 3) {
            System.out.println(tag + ": " + message);
        }
    }

    public void debug(String tag, String message, Throwable exception) {
        if (this.logLevel >= 3) {
            System.out.println(tag + ": " + message);
            exception.printStackTrace(System.out);
        }
    }

    public void log(String tag, String message) {
        if (this.logLevel >= 2) {
            System.out.println(tag + ": " + message);
        }
    }

    public void log(String tag, String message, Throwable exception) {
        if (this.logLevel >= 2) {
            System.out.println(tag + ": " + message);
            exception.printStackTrace(System.out);
        }
    }

    public void error(String tag, String message) {
        if (this.logLevel >= 1) {
            System.err.println(tag + ": " + message);
        }
    }

    public void error(String tag, String message, Throwable exception) {
        if (this.logLevel >= 1) {
            System.err.println(tag + ": " + message);
            exception.printStackTrace(System.err);
        }
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public void setApplicationLogger(ApplicationLogger applicationLogger) {
        this.applicationLogger = applicationLogger;
    }

    public ApplicationLogger getApplicationLogger() {
        return this.applicationLogger;
    }

    public void exit() {
        this.postRunnable(new Runnable(){

            @Override
            public void run() {
                HeadlessMini2DxGame.this.running = false;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLifecycleListener(LifecycleListener listener) {
        Array<LifecycleListener> array = this.lifecycleListeners;
        synchronized (array) {
            this.lifecycleListeners.add((Object)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLifecycleListener(LifecycleListener listener) {
        Array<LifecycleListener> array = this.lifecycleListeners;
        synchronized (array) {
            this.lifecycleListeners.removeValue((Object)listener, true);
        }
    }
}

