/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;

public class LibgdxTextureRegionWrapper
extends TextureRegion {
    public LibgdxTextureRegionWrapper() {
    }

    public LibgdxTextureRegionWrapper(Texture texture) {
        super(texture);
        this.flip(false, true);
    }

    public LibgdxTextureRegionWrapper(Texture texture, int width, int height) {
        super(texture, width, height);
        this.flip(false, true);
    }

    public LibgdxTextureRegionWrapper(Texture texture, int x, int y, int width, int height) {
        super(texture, x, y, width, height);
        this.flip(false, true);
    }

    public LibgdxTextureRegionWrapper(Texture texture, float u, float v, float u2, float v2) {
        super(texture, u, v, u2, v2);
        this.flip(false, true);
    }

    public LibgdxTextureRegionWrapper(TextureRegion region) {
        super(region);
    }

    public LibgdxTextureRegionWrapper(TextureRegion region, int x, int y, int width, int height) {
        super(region, x, y, width, height);
        this.flip(false, true);
    }

    public LibgdxTextureRegionWrapper(TextureAtlas.AtlasRegion atlasRegion) {
        super((TextureRegion)atlasRegion);
        this.flip(false, true);
    }

    public boolean isFlipY() {
        return !super.isFlipY();
    }

    public int getRegionY() {
        this.setFlipY(!this.isFlipY());
        int result = super.getRegionY();
        this.setFlipY(!this.isFlipY());
        return result;
    }

    public void setFlip(boolean flipX, boolean flipY) {
        this.setFlipX(flipX);
        this.setFlipY(flipY);
    }

    public void setFlipX(boolean flipX) {
        if (flipX == this.isFlipX()) {
            return;
        }
        this.flip(true, false);
    }

    public void setFlipY(boolean flipY) {
        if (flipY == this.isFlipY()) {
            return;
        }
        this.flip(false, true);
    }

    public void setRegionHeight(int height) {
        if (!this.isFlipY()) {
            this.setV(this.getV2() + (float)height / (float)this.getTexture().getHeight());
        } else {
            this.setV2(this.getV() + (float)height / (float)this.getTexture().getHeight());
        }
    }
}

