/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import org.mini2Dx.core.graphics.TextureFilter;
import org.mini2Dx.libgdx.graphics.LibgdxTexture;

public class LibgdxSpriteBatchWrapper
extends SpriteBatch {
    private TextureFilter minFilter = TextureFilter.PIXEL;
    private TextureFilter magFilter = TextureFilter.PIXEL;

    public LibgdxSpriteBatchWrapper() {
    }

    public LibgdxSpriteBatchWrapper(int size) {
        super(size);
    }

    public LibgdxSpriteBatchWrapper(int size, ShaderProgram defaultShader) {
        super(size, defaultShader);
    }

    protected void switchTexture(Texture texture) {
        if (texture instanceof LibgdxTexture) {
            LibgdxTexture gdxTexture = (LibgdxTexture)texture;
            this.setTextureFilters(gdxTexture);
        }
        super.switchTexture(texture);
    }

    private void setTextureFilters(LibgdxTexture texture) {
        if (!texture.getMagTextureFilter().equals((Object)this.magFilter)) {
            texture.setTextureFilter(this.minFilter, this.magFilter);
            return;
        }
        if (!texture.getMinTextureFilter().equals((Object)this.minFilter)) {
            texture.setTextureFilter(this.minFilter, this.magFilter);
            return;
        }
    }

    public TextureFilter getMinFilter() {
        return this.minFilter;
    }

    public void setMinFilter(TextureFilter minFilter) {
        this.minFilter = minFilter;
    }

    public TextureFilter getMagFilter() {
        return this.magFilter;
    }

    public void setMagFilter(TextureFilter magFilter) {
        this.magFilter = magFilter;
    }
}

