/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.libgdx;

import com.badlogic.gdx.Gdx;
import java.io.IOException;
import org.mini2Dx.core.Audio;
import org.mini2Dx.core.audio.Music;
import org.mini2Dx.core.audio.MusicCompletionListener;
import org.mini2Dx.core.audio.Sound;
import org.mini2Dx.core.audio.SoundCompletionListener;
import org.mini2Dx.core.files.FileHandle;
import org.mini2Dx.gdx.utils.Array;
import org.mini2Dx.libgdx.audio.LibgdxMusic;
import org.mini2Dx.libgdx.audio.LibgdxSound;
import org.mini2Dx.libgdx.files.LibgdxFileHandle;

public class LibgdxAudio
implements Audio {
    private final Array<MusicCompletionListener> musicCompletionListeners = new Array();
    private final Array<SoundCompletionListener> soundCompletionListeners = new Array();

    public Sound newSound(FileHandle fileHandle) throws IOException {
        LibgdxFileHandle gdxFileHandle = (LibgdxFileHandle)fileHandle;
        return new LibgdxSound(Gdx.audio.newSound(gdxFileHandle.fileHandle));
    }

    public Music newMusic(FileHandle fileHandle) throws IOException {
        LibgdxFileHandle gdxFileHandle = (LibgdxFileHandle)fileHandle;
        return new LibgdxMusic(this, Gdx.audio.newMusic(gdxFileHandle.fileHandle));
    }

    public void addMusicCompletionListener(MusicCompletionListener completionListener) {
        this.musicCompletionListeners.add((Object)completionListener);
    }

    public void removeMusicCompletionListener(MusicCompletionListener completionListener) {
        this.musicCompletionListeners.removeValue((Object)completionListener, false);
    }

    public void addSoundCompletionListener(SoundCompletionListener completionListener) {
        this.soundCompletionListeners.add((Object)completionListener);
    }

    public void removeSoundCompletionListener(SoundCompletionListener completionListener) {
        this.soundCompletionListeners.removeValue((Object)completionListener, false);
    }

    public void notifyMusicCompletionListeners(Music music) {
        for (int i = this.musicCompletionListeners.size - 1; i >= 0; --i) {
            ((MusicCompletionListener)this.musicCompletionListeners.get(i)).onMusicCompleted(music);
        }
    }

    public void notifySoundCompletionListeners(long soundId) {
        for (int i = this.soundCompletionListeners.size - 1; i >= 0; --i) {
            ((SoundCompletionListener)this.soundCompletionListeners.get(i)).onSoundCompleted(soundId);
        }
    }
}

