/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.libgdx;

import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import org.mini2Dx.core.Fonts;
import org.mini2Dx.core.files.FileHandle;
import org.mini2Dx.core.font.GameFont;
import org.mini2Dx.libgdx.files.LibgdxFileHandle;
import org.mini2Dx.libgdx.font.LibgdxBitmapFont;

public class LibgdxFonts
extends Fonts {
    private static GameFont DEFAULT_FONT;

    public GameFont defaultFont() {
        if (DEFAULT_FONT == null) {
            DEFAULT_FONT = new LibgdxBitmapFont();
        }
        return DEFAULT_FONT;
    }

    public GameFont newPlatformFont(FileHandle fileHandle) {
        if (fileHandle.path().endsWith(".ttf")) {
            LibgdxFileHandle gdxFileHandle = (LibgdxFileHandle)fileHandle;
            FreeTypeFontGenerator.FreeTypeFontParameter fontParameter = new FreeTypeFontGenerator.FreeTypeFontParameter();
            fontParameter.size = 12;
            fontParameter.flip = true;
            fontParameter.kerning = true;
            FreeTypeFontGenerator freeTypeFontGenerator = new FreeTypeFontGenerator(gdxFileHandle.fileHandle);
            return new LibgdxBitmapFont(freeTypeFontGenerator.generateFont(fontParameter));
        }
        return new LibgdxBitmapFont(fileHandle);
    }

    public GameFont newTrueTypeFont(FileHandle fileHandle) {
        return this.newPlatformFont(fileHandle);
    }

    public GameFont newBitmapFont(FileHandle fntFileHandle) {
        return new LibgdxBitmapFont(fntFileHandle);
    }
}

