/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.libgdx;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.LibgdxSpriteBatchWrapper;
import com.badlogic.gdx.graphics.g2d.PolygonSpriteBatch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector3;
import org.mini2Dx.core.Graphics;
import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.font.GameFont;
import org.mini2Dx.core.font.GameFontCache;
import org.mini2Dx.core.geom.Rectangle;
import org.mini2Dx.core.geom.Shape;
import org.mini2Dx.core.graphics.Color;
import org.mini2Dx.core.graphics.Mini2DxBlendFunction;
import org.mini2Dx.core.graphics.NinePatch;
import org.mini2Dx.core.graphics.ParticleEffect;
import org.mini2Dx.core.graphics.Shader;
import org.mini2Dx.core.graphics.Sprite;
import org.mini2Dx.core.graphics.SpriteCache;
import org.mini2Dx.core.graphics.Texture;
import org.mini2Dx.core.graphics.TextureFilter;
import org.mini2Dx.core.graphics.TextureRegion;
import org.mini2Dx.core.graphics.TilingDrawable;
import org.mini2Dx.gdx.math.EarClippingTriangulator;
import org.mini2Dx.gdx.math.MathUtils;
import org.mini2Dx.gdx.math.Matrix4;
import org.mini2Dx.libgdx.game.GameWrapper;
import org.mini2Dx.libgdx.graphics.LibgdxColor;
import org.mini2Dx.libgdx.graphics.LibgdxShader;
import org.mini2Dx.libgdx.graphics.LibgdxSprite;
import org.mini2Dx.libgdx.graphics.LibgdxTexture;
import org.mini2Dx.libgdx.graphics.LibgdxTextureRegion;
import org.mini2Dx.libgdx.graphics.ShapeTextureCache;

public class LibgdxGraphics
implements Graphics {
    private static final String LOGGING_TAG = LibgdxGraphics.class.getSimpleName();
    public final LibgdxSpriteBatchWrapper spriteBatch;
    private static final Vector3 cameraRotationPoint = new Vector3(0.0f, 0.0f, 0.0f);
    private static final Vector3 cameraRotationAxis = new Vector3(0.0f, 0.0f, 1.0f);
    private final GameWrapper gameWrapper;
    private final ShapeTextureCache colorTextureCache;
    private final ShapeRenderer shapeRenderer;
    private final PolygonSpriteBatch polygonSpriteBatch;
    private final EarClippingTriangulator triangulator = new EarClippingTriangulator();
    private LibgdxColor color;
    private LibgdxColor backgroundColor;
    private LibgdxColor tint;
    private LibgdxColor defaultTint;
    private OrthographicCamera camera;
    private GameFont font;
    private LibgdxShader defaultShader;
    private LibgdxShader currentShader;
    private float translationX;
    private float translationY;
    private float scaleX;
    private float scaleY;
    private float rotation;
    private float rotationX;
    private float rotationY;
    private int windowWidth;
    private int windowHeight;
    private int defaultBlendSrcFunc = 770;
    private int defaultBlendDstFunc = 771;
    private int lineHeight;
    private RenderState rendering;
    private boolean transformationsApplied;
    private Rectangle clip;
    private float[] triangleVertices = new float[6];
    private float[] polygonRenderData = new float[15];

    public LibgdxGraphics(GameWrapper gameWrapper, LibgdxSpriteBatchWrapper spriteBatch, PolygonSpriteBatch polygonSpriteBatch, ShapeRenderer shapeRenderer) {
        this.gameWrapper = gameWrapper;
        this.spriteBatch = spriteBatch;
        this.shapeRenderer = shapeRenderer;
        this.shapeRenderer.setAutoShapeType(true);
        this.polygonSpriteBatch = polygonSpriteBatch;
        this.windowWidth = Gdx.graphics.getWidth();
        this.windowHeight = Gdx.graphics.getHeight();
        this.defaultTint = new LibgdxColor(spriteBatch.getColor());
        this.font = Mdx.fonts.defaultFont();
        this.tint = this.defaultTint;
        this.lineHeight = 1;
        this.color = new LibgdxColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.backgroundColor = new LibgdxColor(0.0f, 0.0f, 0.0f, 1.0f);
        this.colorTextureCache = new ShapeTextureCache();
        this.translationX = 0.0f;
        this.translationY = 0.0f;
        this.scaleX = 1.0f;
        this.scaleY = 1.0f;
        this.rotation = 0.0f;
        this.rotationX = 0.0f;
        this.rotationY = 0.0f;
        this.camera = new OrthographicCamera();
    }

    public void preRender(int gameWidth, int gameHeight) {
        this.windowWidth = gameWidth;
        this.windowHeight = gameHeight;
        this.tint = this.defaultTint;
        this.spriteBatch.setColor(this.tint.rf(), this.tint.gf(), this.tint.bf(), this.tint.af());
        Gdx.gl.glClearColor(this.backgroundColor.rf(), this.backgroundColor.gf(), this.backgroundColor.bf(), 1.0f);
        Gdx.gl.glClear(17408);
        this.rendering = RenderState.NOT_RENDERING;
        if (this.defaultShader == null) {
            this.defaultShader = new LibgdxShader(SpriteBatch.createDefaultShader());
        }
    }

    public void postRender() {
        this.endRendering();
        this.resetTransformations();
        this.clearShader();
        this.clearBlendFunction();
    }

    public void clearContext() {
        this.clearContext(this.backgroundColor, true, true);
    }

    public void clearContext(Color color) {
        this.clearContext(color, true, true);
    }

    public void clearContext(Color color, boolean depthBufferBit, boolean colorBufferBit) {
        int mask = depthBufferBit && colorBufferBit ? 16640 : (depthBufferBit ? 256 : (colorBufferBit ? 16384 : 0));
        Gdx.gl.glClearColor(color.rf(), color.gf(), color.bf(), color.af());
        Gdx.gl.glClear(mask);
    }

    private void setupDepthBuffer() {
        if (this.clip != null) {
            Gdx.gl.glDepthFunc(513);
            Gdx.gl.glEnable(2929);
            Gdx.gl.glDepthMask(true);
            Gdx.gl.glColorMask(false, false, false, false);
            this.shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
            this.shapeRenderer.setColor(0.0f, 1.0f, 0.0f, 0.5f);
            this.shapeRenderer.rect(this.clip.getX(), this.clip.getY(), this.clip.getWidth(), this.clip.getHeight());
            this.shapeRenderer.end();
            Gdx.gl.glColorMask(true, true, true, true);
            Gdx.gl.glEnable(2929);
            Gdx.gl.glDepthFunc(514);
        }
    }

    private void beginRendering(RenderState newState) {
        if (newState == this.rendering) {
            return;
        }
        switch (this.rendering) {
            case NOT_RENDERING: {
                this.applyTransformations();
                Gdx.gl.glClearDepthf(1.0f);
                Gdx.gl.glClear(256);
                this.setupDepthBuffer();
                break;
            }
            case SHAPES: {
                this.shapeRenderer.end();
                break;
            }
            case POLYGONS: {
                this.polygonSpriteBatch.end();
                break;
            }
            case SPRITEBATCH: {
                this.spriteBatch.end();
            }
        }
        switch (newState) {
            case SHAPES: {
                this.shapeRenderer.begin();
                break;
            }
            case POLYGONS: {
                this.polygonSpriteBatch.begin();
                break;
            }
            case SPRITEBATCH: {
                this.spriteBatch.begin();
            }
        }
        this.rendering = newState;
    }

    private void endRendering() {
        switch (this.rendering) {
            case NOT_RENDERING: {
                return;
            }
            case SHAPES: {
                this.shapeRenderer.end();
                break;
            }
            case POLYGONS: {
                this.polygonSpriteBatch.end();
                break;
            }
            case SPRITEBATCH: {
                this.spriteBatch.end();
            }
        }
        this.undoTransformations();
        if (this.clip != null) {
            Gdx.gl.glClearDepthf(1.0f);
            Gdx.gl.glClear(256);
            Gdx.gl.glDisable(2929);
        }
        this.rendering = RenderState.NOT_RENDERING;
    }

    private void applyTransformations() {
        if (!this.transformationsApplied) {
            this.transformationsApplied = true;
            float viewportWidth = MathUtils.round((float)((float)this.windowWidth / this.scaleX));
            float viewportHeight = MathUtils.round((float)((float)this.windowHeight / this.scaleY));
            this.camera.setToOrtho(true, viewportWidth, viewportHeight);
            if (this.translationX != 0.0f || this.translationY != 0.0f) {
                this.camera.translate(this.translationX, this.translationY);
            }
            this.camera.update();
            if (this.rotation != 0.0f) {
                LibgdxGraphics.cameraRotationPoint.x = this.rotationX;
                LibgdxGraphics.cameraRotationPoint.y = this.rotationY;
                this.camera.rotateAround(cameraRotationPoint, cameraRotationAxis, -this.rotation);
            }
            this.camera.update();
            this.spriteBatch.setProjectionMatrix(this.camera.combined);
            this.shapeRenderer.setProjectionMatrix(this.camera.combined);
            this.polygonSpriteBatch.setProjectionMatrix(this.camera.combined);
        }
    }

    private void undoTransformations() {
        if (this.transformationsApplied) {
            this.transformationsApplied = false;
            if (this.rotation != 0.0f) {
                this.camera.rotateAround(cameraRotationPoint, cameraRotationAxis, this.rotation);
            }
            this.camera.update();
            if (this.translationX != 0.0f || this.translationY != 0.0f) {
                this.camera.translate(-this.translationX, -this.translationY);
            }
            this.camera.update();
        }
    }

    private void resetTransformations() {
        this.translationX = 0.0f;
        this.translationY = 0.0f;
        this.scaleX = 1.0f;
        this.scaleY = 1.0f;
        this.rotation = 0.0f;
        this.rotationX = 0.0f;
        this.rotationY = 0.0f;
    }

    public void drawLineSegment(float x1, float y1, float x2, float y2) {
        this.beginShapeRendering(ShapeRenderer.ShapeType.Filled);
        this.shapeRenderer.rectLine(x1, y1, x2, y2, (float)this.lineHeight);
    }

    public void drawRect(float x, float y, float width, float height) {
        int roundWidth = MathUtils.round((float)width);
        int roundHeight = MathUtils.round((float)height);
        this.beginShapeRendering(ShapeRenderer.ShapeType.Filled);
        this.shapeRenderer.rectLine(x, y, x + (float)roundWidth, y, (float)this.lineHeight);
        this.shapeRenderer.rectLine(x, y, x, y + (float)roundHeight, (float)this.lineHeight);
        this.shapeRenderer.rectLine(x + (float)roundWidth, y, x + (float)roundWidth, y + (float)roundHeight, (float)this.lineHeight);
        this.shapeRenderer.rectLine(x, y + (float)roundHeight, x + (float)roundWidth, y + (float)roundHeight, (float)this.lineHeight);
    }

    private void beginShapeRendering(ShapeRenderer.ShapeType shapeType) {
        this.beginRendering(RenderState.SHAPES);
        this.shapeRenderer.set(shapeType);
        this.shapeRenderer.setColor(this.color.rf(), this.color.gf(), this.color.bf(), this.color.af());
    }

    public void fillRect(float x, float y, float width, float height) {
        this.beginRendering(RenderState.SPRITEBATCH);
        this.spriteBatch.draw(this.colorTextureCache.getFilledRectangleTexture(this.color), x, y, 0.0f, 0.0f, width, height, 1.0f, 1.0f, 0.0f, 0, 0, 1, 1, false, false);
    }

    public void drawCircle(float centerX, float centerY, int radius) {
        this.beginShapeRendering(ShapeRenderer.ShapeType.Line);
        this.shapeRenderer.circle(centerX, centerY, (float)radius);
    }

    public void drawCircle(float centerX, float centerY, float radius) {
        this.drawCircle(centerX, centerY, MathUtils.round((float)radius));
    }

    public void fillCircle(float centerX, float centerY, int radius) {
        this.beginShapeRendering(ShapeRenderer.ShapeType.Filled);
        this.shapeRenderer.circle(centerX, centerY, (float)radius);
    }

    public void fillCircle(float centerX, float centerY, float radius) {
        this.fillCircle(centerX, centerY, MathUtils.round((float)radius));
    }

    public void drawTriangle(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.triangleVertices[0] = x1;
        this.triangleVertices[1] = y1;
        this.triangleVertices[2] = x2;
        this.triangleVertices[3] = y2;
        this.triangleVertices[4] = x3;
        this.triangleVertices[5] = y3;
        this.drawPolygon(this.triangleVertices);
    }

    public void fillTriangle(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.triangleVertices[0] = x1;
        this.triangleVertices[1] = y1;
        this.triangleVertices[2] = x2;
        this.triangleVertices[3] = y2;
        this.triangleVertices[4] = x3;
        this.triangleVertices[5] = y3;
        this.fillPolygon(this.triangleVertices, this.triangulator.computeTriangles((float[])this.triangleVertices).items);
    }

    public void drawPolygon(float[] vertices) {
        this.beginShapeRendering(ShapeRenderer.ShapeType.Line);
        this.shapeRenderer.polygon(vertices);
    }

    public void fillPolygon(float[] vertices, short[] triangles) {
        this.beginRendering(RenderState.POLYGONS);
        if (vertices.length * 5 > this.polygonRenderData.length) {
            this.polygonRenderData = new float[vertices.length * 5];
        }
        int totalPoints = vertices.length / 2;
        for (int i = 0; i < totalPoints; ++i) {
            int verticesIndex = i * 2;
            int renderIndex = i * 5;
            this.polygonRenderData[renderIndex] = vertices[verticesIndex];
            this.polygonRenderData[renderIndex + 1] = vertices[verticesIndex + 1];
            this.polygonRenderData[renderIndex + 2] = this.color.color.toFloatBits();
            this.polygonRenderData[renderIndex + 3] = vertices[verticesIndex];
            this.polygonRenderData[renderIndex + 4] = vertices[verticesIndex + 1];
        }
        this.polygonSpriteBatch.draw(this.colorTextureCache.getFilledRectangleTexture(this.color), this.polygonRenderData, 0, vertices.length * 5, triangles, 0, triangles.length);
    }

    public void drawString(String text, float x, float y) {
        if (this.font == null) {
            return;
        }
        this.beginRendering(RenderState.SPRITEBATCH);
        this.font.setColor((Color)this.color);
        this.font.draw((Graphics)this, text, x, y);
    }

    public void drawString(String text, float x, float y, float targetWidth) {
        this.drawString(text, x, y, targetWidth, 8);
    }

    public void drawString(String text, float x, float y, float targetWidth, int horizontalAlign) {
        if (this.font == null) {
            return;
        }
        this.beginRendering(RenderState.SPRITEBATCH);
        this.font.setColor((Color)this.color);
        this.font.draw((Graphics)this, text, x, y, targetWidth, horizontalAlign, true);
    }

    public void drawTexture(Texture texture, float x, float y) {
        this.drawTexture(texture, x, y, texture.getWidth(), texture.getHeight());
    }

    public void drawTexture(Texture texture, float x, float y, boolean flipY) {
        this.drawTexture(texture, x, y, texture.getWidth(), texture.getHeight(), flipY);
    }

    public void drawTexture(Texture texture, float x, float y, float width, float height) {
        this.drawTexture(texture, x, y, width, height, true);
    }

    public void drawTexture(Texture texture, float x, float y, float width, float height, boolean flipY) {
        this.beginRendering(RenderState.SPRITEBATCH);
        LibgdxTexture gdxTexture = (LibgdxTexture)texture;
        this.spriteBatch.draw(gdxTexture, x, y, 0.0f, 0.0f, width, height, 1.0f, 1.0f, 0.0f, 0, 0, texture.getWidth(), texture.getHeight(), false, flipY);
    }

    public void drawTextureRegion(TextureRegion textureRegion, float x, float y) {
        this.drawTextureRegion(textureRegion, x, y, textureRegion.getRegionWidth(), textureRegion.getRegionHeight());
    }

    public void drawTextureRegion(TextureRegion textureRegion, float x, float y, float width, float height) {
        this.drawTextureRegion(textureRegion, x, y, width, height, 0.0f);
    }

    public void drawTextureRegion(TextureRegion textureRegion, float x, float y, float width, float height, float rotation) {
        this.beginRendering(RenderState.SPRITEBATCH);
        LibgdxTextureRegion gdxTextureRegion = (LibgdxTextureRegion)textureRegion;
        this.spriteBatch.draw(gdxTextureRegion.textureRegion, x, y, 0.0f, 0.0f, width, height, 1.0f, 1.0f, rotation);
    }

    public void drawShape(Shape shape) {
        shape.draw((Graphics)this);
    }

    public void fillShape(Shape shape) {
        shape.fill((Graphics)this);
    }

    public void drawSprite(Sprite sprite) {
        LibgdxSprite gdxSprite = (LibgdxSprite)sprite;
        this.beginRendering(RenderState.SPRITEBATCH);
        gdxSprite.sprite.draw((Batch)this.spriteBatch);
    }

    public void drawSprite(Sprite sprite, float x, float y) {
        LibgdxSprite gdxSprite = (LibgdxSprite)sprite;
        this.beginRendering(RenderState.SPRITEBATCH);
        float oldX = sprite.getX();
        float oldY = sprite.getY();
        Color oldTint = sprite.getTint();
        if (this.tint != null) {
            sprite.setTint((Color)this.tint);
        }
        sprite.setPosition(x, y);
        gdxSprite.sprite.draw((Batch)this.spriteBatch);
        sprite.setPosition(oldX, oldY);
        sprite.setTint(oldTint);
    }

    public void drawSpriteCache(SpriteCache spriteCache, int cacheId) {
        spriteCache.draw((Graphics)this, cacheId);
    }

    public void drawParticleEffect(ParticleEffect effect) {
    }

    public void drawNinePatch(NinePatch ninePatch, float x, float y, float width, float height) {
        this.beginRendering(RenderState.SPRITEBATCH);
        ninePatch.render((Graphics)this, x, y, width, height);
    }

    public void drawTilingDrawable(TilingDrawable tilingDrawable, float x, float y, float width, float height) {
        tilingDrawable.draw((Graphics)this, x, y, width, height);
    }

    public void drawFontCache(GameFontCache fontCache) {
        this.beginRendering(RenderState.SPRITEBATCH);
        fontCache.draw((Graphics)this);
    }

    public void setClip(float x, float y, float width, float height) {
        this.endRendering();
        if (MathUtils.isEqual((float)0.0f, (float)x) && MathUtils.isEqual((float)0.0f, (float)y) && MathUtils.isEqual((float)this.getViewportWidth(), (float)width) && MathUtils.isEqual((float)this.getViewportHeight(), (float)height)) {
            this.clip = null;
        } else if (this.clip == null) {
            this.clip = new Rectangle(x, y, width, height);
        } else {
            this.clip.set(x, y, width, height);
        }
    }

    public void setClip(Rectangle clip) {
        this.setClip(clip.getX(), clip.getY(), clip.getWidth(), clip.getHeight());
    }

    public Rectangle removeClip() {
        if (this.clip == null) {
            return null;
        }
        this.endRendering();
        Rectangle result = this.clip;
        this.clip = null;
        return result;
    }

    public Rectangle peekClip() {
        Rectangle result = new Rectangle();
        this.peekClip(result);
        return result;
    }

    public void peekClip(Rectangle rectangle) {
        if (this.clip == null) {
            rectangle.set(0.0f, 0.0f, this.getViewportWidth(), this.getViewportHeight());
        } else {
            rectangle.set(this.clip);
        }
    }

    public void setTint(Color tint) {
        this.tint = (LibgdxColor)tint;
        this.spriteBatch.setColor(this.tint.color);
    }

    public void removeTint() {
        this.setTint(this.defaultTint);
    }

    public void enableBlending() {
        this.spriteBatch.enableBlending();
    }

    public void disableBlending() {
        this.spriteBatch.disableBlending();
    }

    public void setShader(Shader shader) {
        this.currentShader = (LibgdxShader)shader;
        this.spriteBatch.setShader(this.currentShader.shaderProgram);
    }

    public Shader getShader() {
        return this.currentShader;
    }

    public void clearShader() {
        this.setShader(this.defaultShader);
    }

    public void setBlendFunction(Mini2DxBlendFunction srcFunc, Mini2DxBlendFunction dstFunc) {
        int srcF = this.convertBlendFunction(srcFunc);
        int dstF = this.convertBlendFunction(dstFunc);
        this.spriteBatch.setBlendFunction(srcF, dstF);
    }

    private int convertBlendFunction(Mini2DxBlendFunction func) {
        switch (func) {
            default: {
                return 0;
            }
            case ONE: {
                return 1;
            }
            case SRC_COLOR: {
                return 768;
            }
            case ONE_MINUS_SRC_COLOR: {
                return 769;
            }
            case DST_COLOR: {
                return 774;
            }
            case ONE_MINUS_DST_COLOR: {
                return 775;
            }
            case SRC_ALPHA: {
                return 770;
            }
            case ONE_MINUS_SRC_ALPHA: {
                return 771;
            }
            case DST_ALPHA: {
                return 772;
            }
            case ONE_MINUS_DST_ALPHA: {
                return 773;
            }
            case SRC_ALPHA_SATURATE: 
        }
        return 776;
    }

    public void clearBlendFunction() {
        this.spriteBatch.setBlendFunction(this.defaultBlendSrcFunc, this.defaultBlendDstFunc);
    }

    public void flush() {
        this.spriteBatch.flush();
    }

    public void setFont(GameFont font) {
        if (font == null) {
            return;
        }
        this.font = font;
    }

    public void setLineHeight(int lineHeight) {
        if (lineHeight > 0) {
            this.lineHeight = lineHeight;
        }
    }

    public void setColor(Color color) {
        if (color == null) {
            return;
        }
        this.color = (LibgdxColor)color;
    }

    public void setBackgroundColor(Color backgroundColor) {
        if (backgroundColor != null) {
            this.backgroundColor = (LibgdxColor)backgroundColor;
        }
    }

    public void scale(float scaleX, float scaleY) {
        if (MathUtils.isEqual((float)1.0f, (float)scaleX) && MathUtils.isEqual((float)1.0f, (float)scaleY)) {
            return;
        }
        this.endRendering();
        this.scaleX *= scaleX;
        this.scaleY *= scaleY;
    }

    public void setScale(float scaleX, float scaleY) {
        if (MathUtils.isEqual((float)this.scaleX, (float)scaleX) && MathUtils.isEqual((float)this.scaleY, (float)scaleY)) {
            return;
        }
        this.endRendering();
        this.scaleX = scaleX;
        this.scaleY = scaleY;
    }

    public void clearScaling() {
        if (MathUtils.isEqual((float)this.scaleX, (float)1.0f) && MathUtils.isEqual((float)this.scaleY, (float)1.0f)) {
            return;
        }
        this.endRendering();
        this.scaleX = 1.0f;
        this.scaleY = 1.0f;
    }

    public void translate(float translateX, float translateY) {
        if (MathUtils.isZero((float)translateX) && MathUtils.isZero((float)translateY)) {
            return;
        }
        this.endRendering();
        this.translationX += translateX;
        this.translationY += translateY;
    }

    public void setTranslation(float translateX, float translateY) {
        if (MathUtils.isEqual((float)this.translationX, (float)translateX) && MathUtils.isEqual((float)this.translationY, (float)translateY)) {
            return;
        }
        this.endRendering();
        this.translationX = translateX;
        this.translationY = translateY;
    }

    public void rotate(float degrees, float x, float y) {
        if (MathUtils.isZero((float)degrees)) {
            return;
        }
        this.endRendering();
        this.rotation += degrees;
        this.rotation %= 360.0f;
        this.rotationX = x;
        this.rotationY = y;
    }

    public void setRotation(float degrees, float x, float y) {
        if (MathUtils.isEqual((float)this.rotation, (float)degrees) && MathUtils.isEqual((float)this.rotationX, (float)x) && MathUtils.isEqual((float)this.rotationY, (float)y)) {
            return;
        }
        this.endRendering();
        this.rotation = degrees;
        this.rotation %= 360.0f;
        this.rotationX = x;
        this.rotationY = y;
    }

    public Matrix4 getProjectionMatrix() {
        return new Matrix4(this.camera.combined.val);
    }

    public boolean isWindowReady() {
        return this.gameWrapper.isGameWindowReady();
    }

    public int getWindowWidth() {
        return this.windowWidth;
    }

    public int getWindowHeight() {
        return this.windowHeight;
    }

    public float getViewportWidth() {
        return this.camera.viewportWidth;
    }

    public float getViewportHeight() {
        return this.camera.viewportHeight;
    }

    public int getWindowSafeX() {
        return 0;
    }

    public int getWindowSafeY() {
        return 0;
    }

    public int getWindowSafeWidth() {
        return this.windowWidth;
    }

    public int getWindowSafeHeight() {
        return this.windowHeight;
    }

    public long getFrameId() {
        return Gdx.graphics.getFrameId();
    }

    public TextureFilter getMinFilter() {
        return this.spriteBatch.getMinFilter();
    }

    public void setMinFilter(TextureFilter filter) {
        this.spriteBatch.setMinFilter(filter);
    }

    public TextureFilter getMagFilter() {
        return this.spriteBatch.getMagFilter();
    }

    public void setMagFilter(TextureFilter filter) {
        this.spriteBatch.setMagFilter(filter);
    }

    public float getRotation() {
        return this.rotation;
    }

    public float getRotationX() {
        return this.rotationX;
    }

    public float getRotationY() {
        return this.rotationY;
    }

    public float getTranslationX() {
        return this.translationX;
    }

    public float getTranslationY() {
        return this.translationY;
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public Color getTint() {
        return this.tint;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public Color getColor() {
        return this.color;
    }

    public int getLineHeight() {
        return this.lineHeight;
    }

    public GameFont getFont() {
        return this.font;
    }

    static enum RenderState {
        NOT_RENDERING,
        SHAPES,
        POLYGONS,
        SPRITEBATCH;

    }
}

