/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.libgdx;

import com.badlogic.gdx.graphics.LibgdxTextureRegionWrapper;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import org.mini2Dx.core.GraphicsUtils;
import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.files.FileHandle;
import org.mini2Dx.core.graphics.Color;
import org.mini2Dx.core.graphics.CustomCursor;
import org.mini2Dx.core.graphics.FrameBuffer;
import org.mini2Dx.core.graphics.NinePatch;
import org.mini2Dx.core.graphics.ParticleEffect;
import org.mini2Dx.core.graphics.PixmapFormat;
import org.mini2Dx.core.graphics.Shader;
import org.mini2Dx.core.graphics.Sprite;
import org.mini2Dx.core.graphics.SpriteCache;
import org.mini2Dx.core.graphics.TextureAtlas;
import org.mini2Dx.core.graphics.TextureRegion;
import org.mini2Dx.libgdx.files.LibgdxFileHandle;
import org.mini2Dx.libgdx.graphics.LibgdxColor;
import org.mini2Dx.libgdx.graphics.LibgdxCustomCursor;
import org.mini2Dx.libgdx.graphics.LibgdxFrameBuffer;
import org.mini2Dx.libgdx.graphics.LibgdxNinePatch;
import org.mini2Dx.libgdx.graphics.LibgdxPixmap;
import org.mini2Dx.libgdx.graphics.LibgdxReadOnlyColor;
import org.mini2Dx.libgdx.graphics.LibgdxShader;
import org.mini2Dx.libgdx.graphics.LibgdxSprite;
import org.mini2Dx.libgdx.graphics.LibgdxSpriteCache;
import org.mini2Dx.libgdx.graphics.LibgdxTexture;
import org.mini2Dx.libgdx.graphics.LibgdxTextureAtlas;
import org.mini2Dx.libgdx.graphics.LibgdxTextureRegion;

public class LibgdxGraphicsUtils
extends GraphicsUtils {
    public Color newColor(int rgba8888) {
        return new LibgdxColor(rgba8888);
    }

    public Color newColor(int r, int g, int b, int a) {
        return new LibgdxColor(r, g, b, a);
    }

    public Color newColor(float r, float g, float b, float a) {
        return new LibgdxColor(r, g, b, a);
    }

    public Color newColor(byte r, byte g, byte b, byte a) {
        return new LibgdxColor(r, g, b, a);
    }

    public Color newColor(Color color) {
        return new LibgdxColor(color.rf(), color.gf(), color.bf(), color.af());
    }

    public Color newReadOnlyColor(int rgba8888) {
        return new LibgdxReadOnlyColor(rgba8888);
    }

    public Color newReadOnlyColor(int r, int g, int b, int a) {
        return new LibgdxReadOnlyColor(r, g, b, a);
    }

    public Color newReadOnlyColor(float r, float g, float b, float a) {
        return new LibgdxReadOnlyColor(r, g, b, a);
    }

    public Color newReadOnlyColor(byte r, byte g, byte b, byte a) {
        return new LibgdxReadOnlyColor(r, g, b, a);
    }

    public Color newReadOnlyColor(Color color) {
        return new LibgdxReadOnlyColor(color.rf(), color.gf(), color.bf(), color.af());
    }

    public org.mini2Dx.core.graphics.Pixmap newPixmap(int width, int height, PixmapFormat format) {
        return new LibgdxPixmap(new Pixmap(width, height, LibgdxPixmap.toGdxPixmapFormat(format)));
    }

    public org.mini2Dx.core.graphics.Pixmap newPixmap(FileHandle file) {
        LibgdxFileHandle gdxFileHandle = (LibgdxFileHandle)file;
        return new LibgdxPixmap(new Pixmap(gdxFileHandle.fileHandle));
    }

    public org.mini2Dx.core.graphics.Texture newTexture(FileHandle file) {
        LibgdxFileHandle gdxFileHandle = (LibgdxFileHandle)file;
        return new LibgdxTexture(gdxFileHandle.fileHandle);
    }

    public org.mini2Dx.core.graphics.Texture newTexture(FileHandle file, PixmapFormat format) {
        LibgdxFileHandle gdxFileHandle = (LibgdxFileHandle)file;
        return new LibgdxTexture(gdxFileHandle.fileHandle, LibgdxPixmap.toGdxPixmapFormat(format), false);
    }

    public org.mini2Dx.core.graphics.Texture newTexture(org.mini2Dx.core.graphics.Pixmap pixmap) {
        LibgdxPixmap gdxPixmap = (LibgdxPixmap)pixmap;
        return new LibgdxTexture(gdxPixmap.pixmap);
    }

    public org.mini2Dx.core.graphics.Texture newTexture(org.mini2Dx.core.graphics.Pixmap pixmap, PixmapFormat format) {
        LibgdxPixmap gdxPixmap = (LibgdxPixmap)pixmap;
        return new LibgdxTexture(gdxPixmap.pixmap, LibgdxPixmap.toGdxPixmapFormat(format), false);
    }

    public org.mini2Dx.core.graphics.Texture newTexture(byte[] fileData) {
        Pixmap pixmap = new Pixmap(fileData, 0, fileData.length);
        return new LibgdxTexture(pixmap);
    }

    public TextureRegion newTextureRegion(org.mini2Dx.core.graphics.Texture texture) {
        LibgdxTexture gdxTexture = (LibgdxTexture)texture;
        return new LibgdxTextureRegion(new LibgdxTextureRegionWrapper(gdxTexture));
    }

    public TextureRegion newTextureRegion(org.mini2Dx.core.graphics.Texture texture, int width, int height) {
        LibgdxTexture gdxTexture = (LibgdxTexture)texture;
        return new LibgdxTextureRegion(new LibgdxTextureRegionWrapper(gdxTexture, width, height));
    }

    public TextureRegion newTextureRegion(org.mini2Dx.core.graphics.Texture texture, int x, int y, int width, int height) {
        LibgdxTexture gdxTexture = (LibgdxTexture)texture;
        return new LibgdxTextureRegion(new LibgdxTextureRegionWrapper((Texture)gdxTexture, x, y, width, height));
    }

    public TextureRegion newTextureRegion(TextureRegion textureRegion) {
        LibgdxTextureRegion gdxTextureRegion = (LibgdxTextureRegion)textureRegion;
        return new LibgdxTextureRegion(gdxTextureRegion);
    }

    public TextureRegion newTextureRegion(TextureRegion textureRegion, int width, int height) {
        return this.newTextureRegion(textureRegion, textureRegion.getRegionX(), textureRegion.getRegionY(), width, height);
    }

    public TextureRegion newTextureRegion(TextureRegion textureRegion, int x, int y, int width, int height) {
        LibgdxTextureRegion gdxTextureRegion = (LibgdxTextureRegion)textureRegion;
        return new LibgdxTextureRegion(gdxTextureRegion, x, y, width, height);
    }

    public Sprite newSprite(org.mini2Dx.core.graphics.Texture texture) {
        LibgdxTexture gdxTexture = (LibgdxTexture)texture;
        return new LibgdxSprite(gdxTexture);
    }

    public Sprite newSprite(org.mini2Dx.core.graphics.Texture texture, int width, int height) {
        LibgdxTexture gdxTexture = (LibgdxTexture)texture;
        return new LibgdxSprite(gdxTexture, width, height);
    }

    public Sprite newSprite(org.mini2Dx.core.graphics.Texture texture, int x, int y, int width, int height) {
        LibgdxTexture gdxTexture = (LibgdxTexture)texture;
        return new LibgdxSprite(gdxTexture, x, y, width, height);
    }

    public Sprite newSprite(TextureRegion textureRegion) {
        return new LibgdxSprite(textureRegion);
    }

    public Sprite newSprite(TextureRegion textureRegion, int width, int height) {
        return new LibgdxSprite(textureRegion, 0, 0, width, height);
    }

    public Sprite newSprite(TextureRegion textureRegion, int x, int y, int width, int height) {
        return new LibgdxSprite(textureRegion, x, y, width, height);
    }

    public Sprite newSprite(Sprite sprite) {
        return new LibgdxSprite(sprite);
    }

    public TextureAtlas newTextureAtlas(FileHandle packFile) {
        return this.newTextureAtlas(packFile, false);
    }

    public TextureAtlas newTextureAtlas(FileHandle packFile, boolean flip) {
        return this.newTextureAtlas(packFile, packFile.parent(), flip);
    }

    public TextureAtlas newTextureAtlas(FileHandle packFile, FileHandle imagesDir) {
        return this.newTextureAtlas(packFile, imagesDir, false);
    }

    public TextureAtlas newTextureAtlas(FileHandle packFile, FileHandle imagesDir, boolean flip) {
        return new LibgdxTextureAtlas(packFile, imagesDir, flip);
    }

    public ParticleEffect newParticleEffect() {
        return null;
    }

    public ParticleEffect newParticleEffect(FileHandle effectFile, FileHandle imagesDir) {
        return null;
    }

    public ParticleEffect newParticleEffect(FileHandle effectFile, TextureAtlas atlas) {
        return null;
    }

    public NinePatch newNinePatch(org.mini2Dx.core.graphics.Texture texture, int left, int right, int top, int bottom) {
        LibgdxTexture gdxTexture = (LibgdxTexture)texture;
        return new LibgdxNinePatch(gdxTexture, left, right, top, bottom);
    }

    public NinePatch newNinePatch(TextureRegion region, int left, int right, int top, int bottom) {
        LibgdxTextureRegion gdxTextureRegion = (LibgdxTextureRegion)region;
        return new LibgdxNinePatch(gdxTextureRegion, left, right, top, bottom);
    }

    public Shader newShader(String path) {
        LibgdxFileHandle vShader = (LibgdxFileHandle)Mdx.files.internal(path + ".vert.glsl");
        LibgdxFileHandle fShader = (LibgdxFileHandle)Mdx.files.internal(path + ".frag.glsl");
        return new LibgdxShader(new ShaderProgram(vShader.fileHandle, fShader.fileHandle));
    }

    public FrameBuffer newFrameBuffer(int width, int height) {
        return new LibgdxFrameBuffer(width, height);
    }

    public CustomCursor newCustomCursor(org.mini2Dx.core.graphics.Pixmap upPixmap, org.mini2Dx.core.graphics.Pixmap downPixmap, int xHotspot, int yHotspot) {
        return new LibgdxCustomCursor(upPixmap, downPixmap, xHotspot, yHotspot);
    }

    public SpriteCache newSpriteCache() {
        return new LibgdxSpriteCache();
    }
}

