/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.libgdx;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.controllers.AdvancedController;
import com.badlogic.gdx.controllers.Controller;
import com.badlogic.gdx.controllers.Controllers;
import org.mini2Dx.core.Input;
import org.mini2Dx.core.input.GamePad;
import org.mini2Dx.core.input.nswitch.SwitchDualJoyConGamePad;
import org.mini2Dx.core.input.nswitch.SwitchJoyConLGamePad;
import org.mini2Dx.core.input.nswitch.SwitchJoyConRGamePad;
import org.mini2Dx.core.input.ps4.PS4GamePad;
import org.mini2Dx.core.input.xbox.XboxGamePad;
import org.mini2Dx.gdx.InputProcessor;
import org.mini2Dx.gdx.utils.Array;
import org.mini2Dx.gdx.utils.ObjectMap;
import org.mini2Dx.libgdx.input.LibgdxAdvancedGamePad;
import org.mini2Dx.libgdx.input.LibgdxGamePad;
import org.mini2Dx.libgdx.input.LibgdxInputProcessor;
import org.mini2Dx.libgdx.input.LibgdxPS4GamePad;
import org.mini2Dx.libgdx.input.LibgdxXboxGamePad;

public class LibgdxInput
implements Input {
    private final Array<GamePad> gamePads = new Array();
    private final ObjectMap<String, LibgdxGamePad> gamePadsById = new ObjectMap();
    private LibgdxInputProcessor gdxInputProcessor = null;

    public void updateGamePads() {
        boolean firstRun = this.gamePads.size == 0;
        for (int i = 0; i < Controllers.getControllers().size; ++i) {
            LibgdxGamePad gamePad;
            AdvancedController advancedController;
            Controller controller = (Controller)Controllers.getControllers().get(i);
            if (firstRun) {
                if (controller instanceof AdvancedController) {
                    advancedController = (AdvancedController)controller;
                    gamePad = new LibgdxAdvancedGamePad(advancedController);
                } else {
                    gamePad = new LibgdxGamePad(controller);
                }
            } else if (controller instanceof AdvancedController) {
                String instanceId;
                advancedController = (AdvancedController)controller;
                String string = instanceId = advancedController.getUniqueId() != null ? advancedController.getUniqueId() : advancedController.getName();
                gamePad = this.gamePadsById.containsKey((Object)instanceId) ? (LibgdxGamePad)this.gamePadsById.get((Object)instanceId) : new LibgdxGamePad(controller);
            } else {
                gamePad = this.gamePadsById.containsKey((Object)controller.getName()) ? (LibgdxGamePad)this.gamePadsById.get((Object)controller.getName()) : new LibgdxGamePad(controller);
            }
            if (this.gamePadsById.containsKey((Object)gamePad.getInstanceId())) continue;
            this.gamePads.add((Object)gamePad);
            this.gamePadsById.put((Object)gamePad.getInstanceId(), (Object)gamePad);
            gamePad.init();
        }
    }

    public void setInputProcessor(InputProcessor inputProcessor) {
        if (this.gdxInputProcessor == null) {
            this.gdxInputProcessor = new LibgdxInputProcessor(inputProcessor);
            Gdx.input.setInputProcessor((com.badlogic.gdx.InputProcessor)this.gdxInputProcessor);
        } else {
            this.gdxInputProcessor.setInputProcessor(inputProcessor);
        }
    }

    public void setOnScreenKeyboardVisible(boolean visible) {
        Gdx.input.setOnscreenKeyboardVisible(visible);
    }

    public Array<GamePad> getGamePads() {
        if (this.gamePads.size == 0) {
            this.updateGamePads();
        }
        return this.gamePads;
    }

    public PS4GamePad newPS4GamePad(GamePad gamePad) {
        return new LibgdxPS4GamePad(gamePad);
    }

    public SwitchDualJoyConGamePad newSwitchDualJoyConGamePad(GamePad gamePad) {
        return null;
    }

    public SwitchJoyConLGamePad newSwitchJoyConLGamePad(GamePad gamePad) {
        return null;
    }

    public SwitchJoyConRGamePad newSwitchJoyConRGamePad(GamePad gamePad) {
        return null;
    }

    public XboxGamePad newXboxGamePad(GamePad gamePad) {
        return new LibgdxXboxGamePad(gamePad);
    }

    public int getX() {
        return Gdx.input.getX();
    }

    public int getY() {
        return Gdx.input.getY();
    }

    public boolean isKeyJustPressed(int key) {
        return Gdx.input.isKeyJustPressed(key);
    }

    public boolean isKeyDown(int key) {
        return Gdx.input.isKeyPressed(key);
    }

    public boolean isKeyUp(int key) {
        return !Gdx.input.isKeyPressed(key);
    }

    public boolean justTouched() {
        return Gdx.input.justTouched();
    }
}

