/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.libgdx;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.mini2Dx.core.TaskExecutor;
import org.mini2Dx.core.executor.AsyncFuture;
import org.mini2Dx.core.executor.AsyncResult;
import org.mini2Dx.core.executor.FrameSpreadTask;
import org.mini2Dx.gdx.utils.Array;
import org.mini2Dx.libgdx.executor.LibgdxAsyncResult;

public class LibgdxTaskExecutor
implements TaskExecutor {
    private static final int DEFAULT_MAX_FRAME_TASKS_PER_FRAME = 32;
    private final ExecutorService executorService;
    private final Array<FrameSpreadTask> spreadTasks = new Array(false, 16);
    private int maxFrameTasksPerFrame;

    public LibgdxTaskExecutor(int threads) {
        this.executorService = Executors.newFixedThreadPool(threads);
        this.maxFrameTasksPerFrame = 32;
    }

    public void update(float delta) {
        int taskCount = 0;
        for (int i = 0; i < this.spreadTasks.size; ++i) {
            if (((FrameSpreadTask)this.spreadTasks.get(i)).updateTask()) {
                this.spreadTasks.removeIndex(i);
                --i;
            }
            if (++taskCount >= this.maxFrameTasksPerFrame) break;
        }
    }

    public void execute(Runnable runnable) {
        this.executorService.execute(runnable);
    }

    public AsyncFuture submit(Runnable runnable) {
        final Future<?> future = this.executorService.submit(runnable);
        return new AsyncFuture(){

            public boolean isFinished() {
                return future.isDone() || future.isCancelled();
            }
        };
    }

    public <T> AsyncResult<T> submit(Callable<T> callable) {
        return new LibgdxAsyncResult<T>(this.executorService.submit(callable));
    }

    public void submit(FrameSpreadTask task) {
        this.spreadTasks.add((Object)task);
    }

    public void setMaxFrameTasksPerFrame(int max) {
        this.maxFrameTasksPerFrame = max;
    }

    public void dispose() {
        this.executorService.shutdown();
    }
}

