/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.libgdx.executor;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.executor.AsyncResult;

public class LibgdxAsyncResult<T>
implements AsyncResult<T> {
    private static final String LOGGING_TAG = LibgdxAsyncResult.class.getSimpleName();
    private final Future<T> future;
    private T result;

    public LibgdxAsyncResult(Future<T> future) {
        this.future = future;
    }

    public T getResult() {
        if (this.result == null) {
            try {
                this.result = this.future.get(100L, TimeUnit.NANOSECONDS);
            }
            catch (TimeoutException e) {
                this.result = null;
            }
            catch (Exception e) {
                Mdx.log.error(LOGGING_TAG, e.getMessage(), e);
                this.result = null;
            }
        }
        return this.result;
    }

    public boolean isFinished() {
        return this.future.isDone() || this.future.isCancelled();
    }
}

