/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.libgdx.files;

import com.badlogic.gdx.files.FileHandle;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.files.FileType;

public class LibgdxFileHandle
implements org.mini2Dx.core.files.FileHandle {
    public final FileHandle fileHandle;

    public LibgdxFileHandle(FileHandle fileHandle) {
        this.fileHandle = fileHandle;
    }

    public String path() {
        return this.fileHandle.path();
    }

    public String normalize() {
        String path = this.path();
        while (path.contains("..")) {
            path = path.replaceAll("[^\\/]+\\/\\.\\.\\/", "");
        }
        while (path.contains("./")) {
            path = path.replaceAll("\\.\\/", "");
        }
        return path;
    }

    public org.mini2Dx.core.files.FileHandle normalizedHandle() {
        switch (this.type()) {
            default: {
                return Mdx.files.internal(this.normalize());
            }
            case EXTERNAL: {
                return Mdx.files.external(this.normalize());
            }
            case LOCAL: 
        }
        return Mdx.files.local(this.normalize());
    }

    public String name() {
        return this.fileHandle.name();
    }

    public String extension() {
        return this.fileHandle.extension();
    }

    public String nameWithoutExtension() {
        return this.fileHandle.nameWithoutExtension();
    }

    public String pathWithoutExtension() {
        return this.fileHandle.pathWithoutExtension();
    }

    public FileType type() {
        switch (this.fileHandle.type()) {
            default: {
                return FileType.INTERNAL;
            }
            case External: 
            case Absolute: {
                return FileType.EXTERNAL;
            }
            case Local: 
        }
        return FileType.LOCAL;
    }

    public InputStream read() throws IOException {
        return this.fileHandle.read();
    }

    public BufferedInputStream read(int bufferSize) throws IOException {
        return this.fileHandle.read(bufferSize);
    }

    public Reader reader() throws IOException {
        return this.fileHandle.reader();
    }

    public Reader reader(String charset) throws IOException {
        return this.fileHandle.reader(charset);
    }

    public BufferedReader reader(int bufferSize) throws IOException {
        return this.fileHandle.reader(bufferSize);
    }

    public BufferedReader reader(int bufferSize, String charset) throws IOException {
        return this.fileHandle.reader(bufferSize, charset);
    }

    public String readString() throws IOException {
        return this.fileHandle.readString();
    }

    public String readString(String charset) throws IOException {
        return this.fileHandle.readString(charset);
    }

    public byte[] readBytes() throws IOException {
        return this.fileHandle.readBytes();
    }

    public int readBytes(byte[] bytes, int offset, int size) throws IOException {
        return this.fileHandle.readBytes(bytes, offset, size);
    }

    public OutputStream write(boolean append) throws IOException {
        return this.fileHandle.write(append);
    }

    public OutputStream write(boolean append, int bufferSize) throws IOException {
        return this.fileHandle.write(append, bufferSize);
    }

    public void write(InputStream input, boolean append) throws IOException {
        this.fileHandle.write(input, append);
    }

    public Writer writer(boolean append) throws IOException {
        return this.fileHandle.writer(append);
    }

    public Writer writer(boolean append, String charset) throws IOException {
        return this.fileHandle.writer(append, charset);
    }

    public void writeString(String string, boolean append) throws IOException {
        this.fileHandle.writeString(string, append);
    }

    public void writeString(String string, boolean append, String charset) throws IOException {
        this.fileHandle.writeString(string, append, charset);
    }

    public void writeBytes(byte[] bytes, boolean append) throws IOException {
        this.fileHandle.writeBytes(bytes, append);
    }

    public void writeBytes(byte[] bytes, int offset, int length, boolean append) throws IOException {
        this.fileHandle.writeBytes(bytes, offset, length, append);
    }

    private static org.mini2Dx.core.files.FileHandle[] gdxFileArrayToMdxHandles(FileHandle[] gdxList) {
        org.mini2Dx.core.files.FileHandle[] list = new org.mini2Dx.core.files.FileHandle[gdxList.length];
        for (int i = 0; i < list.length; ++i) {
            list[i] = new LibgdxFileHandle(gdxList[i]);
        }
        return list;
    }

    public org.mini2Dx.core.files.FileHandle[] list() throws IOException {
        FileHandle[] gdxList = this.fileHandle.list();
        return LibgdxFileHandle.gdxFileArrayToMdxHandles(gdxList);
    }

    public org.mini2Dx.core.files.FileHandle[] list(FileFilter filter) throws IOException {
        FileHandle[] gdxList = this.fileHandle.list(filter);
        return LibgdxFileHandle.gdxFileArrayToMdxHandles(gdxList);
    }

    public org.mini2Dx.core.files.FileHandle[] list(FilenameFilter filter) throws IOException {
        FileHandle[] gdxList = this.fileHandle.list(filter);
        return LibgdxFileHandle.gdxFileArrayToMdxHandles(gdxList);
    }

    public org.mini2Dx.core.files.FileHandle[] list(String suffix) throws IOException {
        FileHandle[] gdxList = this.fileHandle.list(suffix);
        return LibgdxFileHandle.gdxFileArrayToMdxHandles(gdxList);
    }

    public boolean isDirectory() {
        return this.fileHandle.isDirectory();
    }

    public org.mini2Dx.core.files.FileHandle child(String name) {
        return new LibgdxFileHandle(this.fileHandle.child(name));
    }

    public org.mini2Dx.core.files.FileHandle sibling(String name) {
        return new LibgdxFileHandle(this.fileHandle.sibling(name));
    }

    public org.mini2Dx.core.files.FileHandle parent() {
        return new LibgdxFileHandle(this.fileHandle.parent());
    }

    public void mkdirs() throws IOException {
        this.fileHandle.mkdirs();
    }

    public boolean exists() {
        return this.fileHandle.exists();
    }

    public boolean delete() throws IOException {
        return this.fileHandle.delete();
    }

    public boolean deleteDirectory() throws IOException {
        return this.fileHandle.deleteDirectory();
    }

    public void emptyDirectory() throws IOException {
        this.fileHandle.emptyDirectory();
    }

    public void emptyDirectory(boolean preserveTree) throws IOException {
        this.fileHandle.emptyDirectory(preserveTree);
    }

    public void copyTo(org.mini2Dx.core.files.FileHandle dest) throws IOException {
        LibgdxFileHandle gdxDest = (LibgdxFileHandle)dest;
        this.fileHandle.copyTo(gdxDest.fileHandle);
    }

    public void moveTo(org.mini2Dx.core.files.FileHandle dest) throws IOException {
        LibgdxFileHandle gdxDest = (LibgdxFileHandle)dest;
        this.fileHandle.moveTo(gdxDest.fileHandle);
    }

    public long length() {
        return this.fileHandle.length();
    }

    public long lastModified() {
        return this.fileHandle.lastModified();
    }
}

