/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.libgdx.font;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.utils.Array;
import org.mini2Dx.core.Graphics;
import org.mini2Dx.core.assets.AssetManager;
import org.mini2Dx.core.files.FileHandle;
import org.mini2Dx.core.font.FontGlyphLayout;
import org.mini2Dx.core.font.GameFont;
import org.mini2Dx.core.font.GameFontCache;
import org.mini2Dx.core.graphics.Color;
import org.mini2Dx.core.graphics.TextureRegion;
import org.mini2Dx.libgdx.LibgdxGraphics;
import org.mini2Dx.libgdx.files.LibgdxFileHandle;
import org.mini2Dx.libgdx.font.BitmapFontGlyphLayout;
import org.mini2Dx.libgdx.font.LibgdxBitmapFontCache;
import org.mini2Dx.libgdx.graphics.LibgdxColor;
import org.mini2Dx.libgdx.graphics.LibgdxTextureRegion;

public class LibgdxBitmapFont
implements GameFont {
    public final BitmapFont bitmapFont;
    private final BitmapFontGlyphLayout sharedGlyphLayout;
    private final Color tmpColor;

    public LibgdxBitmapFont() {
        this.bitmapFont = new BitmapFont(true);
        this.sharedGlyphLayout = (BitmapFontGlyphLayout)this.newGlyphLayout();
        this.tmpColor = new LibgdxColor(this.bitmapFont.getColor());
    }

    public LibgdxBitmapFont(FileHandle fileHandle) {
        this.bitmapFont = new BitmapFont(((LibgdxFileHandle)fileHandle).fileHandle, true);
        this.sharedGlyphLayout = (BitmapFontGlyphLayout)this.newGlyphLayout();
        this.tmpColor = new LibgdxColor(this.bitmapFont.getColor());
    }

    public LibgdxBitmapFont(BitmapFont.BitmapFontData data, TextureRegion region, boolean integer) {
        this(data, region != null ? org.mini2Dx.gdx.utils.Array.with((Object[])new TextureRegion[]{region}) : null, integer);
    }

    public LibgdxBitmapFont(BitmapFont.BitmapFontData data, org.mini2Dx.gdx.utils.Array<TextureRegion> pageRegions, boolean integer) {
        this.bitmapFont = new BitmapFont(data, LibgdxBitmapFont.convert(pageRegions), integer);
        this.sharedGlyphLayout = (BitmapFontGlyphLayout)this.newGlyphLayout();
        this.tmpColor = new LibgdxColor(this.bitmapFont.getColor());
    }

    public LibgdxBitmapFont(BitmapFont bitmapFont) {
        this.bitmapFont = bitmapFont;
        this.sharedGlyphLayout = (BitmapFontGlyphLayout)this.newGlyphLayout();
        this.tmpColor = new LibgdxColor(bitmapFont.getColor());
    }

    public boolean loadInternal() {
        return true;
    }

    public boolean loadExternal() {
        return true;
    }

    public boolean load(AssetManager assetManager) {
        return true;
    }

    public void draw(Graphics g, String str, float x, float y) {
        this.bitmapFont.draw((Batch)((LibgdxGraphics)g).spriteBatch, (CharSequence)str, x, y);
    }

    public void draw(Graphics g, String str, float x, float y, float targetWidth) {
        this.draw(g, str, x, y, targetWidth, 8, true);
    }

    public void draw(Graphics g, String str, float x, float y, float targetWidth, int horizontalAlignment, boolean wrap) {
        this.bitmapFont.draw((Batch)((LibgdxGraphics)g).spriteBatch, (CharSequence)str, x, y, targetWidth, horizontalAlignment, wrap);
    }

    public FontGlyphLayout newGlyphLayout() {
        return new BitmapFontGlyphLayout(this);
    }

    public FontGlyphLayout getSharedGlyphLayout() {
        return this.sharedGlyphLayout;
    }

    public GameFontCache newCache() {
        return new LibgdxBitmapFontCache(this, this.useIntegerPositions());
    }

    public Color getColor() {
        return this.tmpColor;
    }

    public void setColor(Color color) {
        this.bitmapFont.setColor(color.rf(), color.gf(), color.bf(), color.af());
        this.tmpColor.set(color);
    }

    public float getLineHeight() {
        return this.bitmapFont.getLineHeight();
    }

    public float getCapHeight() {
        return this.bitmapFont.getCapHeight();
    }

    public boolean useIntegerPositions() {
        return this.bitmapFont.usesIntegerPositions();
    }

    public void dispose() {
        this.bitmapFont.dispose();
    }

    private static Array<com.badlogic.gdx.graphics.g2d.TextureRegion> convert(org.mini2Dx.gdx.utils.Array<TextureRegion> pageRegions) {
        Array result = new Array();
        for (int i = 0; i < pageRegions.size; ++i) {
            LibgdxTextureRegion gdxTextureRegion = (LibgdxTextureRegion)pageRegions.get(i);
            result.add((Object)gdxTextureRegion.textureRegion);
        }
        return result;
    }
}

