/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.libgdx.font;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFontCache;
import org.mini2Dx.core.Graphics;
import org.mini2Dx.core.font.GameFont;
import org.mini2Dx.core.font.GameFontCache;
import org.mini2Dx.core.graphics.Color;
import org.mini2Dx.libgdx.LibgdxGraphics;
import org.mini2Dx.libgdx.font.LibgdxBitmapFont;
import org.mini2Dx.libgdx.graphics.LibgdxColor;

public class LibgdxBitmapFontCache
implements GameFontCache {
    private final LibgdxBitmapFont bitmapFont;
    private final BitmapFontCache bitmapFontCache;
    private final LibgdxColor tmpColor;

    public LibgdxBitmapFontCache(LibgdxBitmapFont font) {
        this(font, font.useIntegerPositions());
    }

    public LibgdxBitmapFontCache(LibgdxBitmapFont font, boolean integer) {
        this.bitmapFont = font;
        this.bitmapFontCache = new BitmapFontCache(font.bitmapFont, integer);
        this.tmpColor = new LibgdxColor(this.bitmapFontCache.getColor());
    }

    public void addText(CharSequence str, float x, float y) {
        this.bitmapFontCache.addText(str, x, y);
    }

    public void addText(CharSequence str, float x, float y, float targetWidth, int halign, boolean wrap) {
        this.bitmapFontCache.addText(str, x, y, targetWidth, halign, wrap);
    }

    public void clear() {
        this.bitmapFontCache.clear();
    }

    public void draw(Graphics g) {
        LibgdxGraphics gdxGraphics = (LibgdxGraphics)g;
        this.bitmapFontCache.draw((Batch)gdxGraphics.spriteBatch);
    }

    public Color getColor() {
        return this.tmpColor;
    }

    public void setColor(Color color) {
        LibgdxColor gdxColor = (LibgdxColor)color;
        this.bitmapFontCache.setColor(gdxColor.color);
        this.tmpColor.set(color);
    }

    public void setAllColors(Color color) {
        LibgdxColor gdxColor = (LibgdxColor)color;
        this.bitmapFontCache.setColors(gdxColor.color);
        this.tmpColor.set(color);
    }

    public void setAllAlphas(float alpha) {
        this.bitmapFontCache.setAlphas(alpha);
    }

    public void setText(CharSequence str, float x, float y) {
        this.bitmapFontCache.setText(str, x, y);
    }

    public void setText(CharSequence str, float x, float y, float targetWidth, int halign, boolean wrap) {
        this.bitmapFontCache.setText(str, x, y, targetWidth, halign, wrap);
    }

    public void translate(float x, float y) {
        this.bitmapFontCache.translate(x, y);
    }

    public void setPosition(float x, float y) {
        this.bitmapFontCache.setPosition(x, y);
    }

    public GameFont getFont() {
        return this.bitmapFont;
    }
}

