/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.libgdx.game;

import com.badlogic.gdx.graphics.g2d.LibgdxSpriteBatchWrapper;
import com.badlogic.gdx.graphics.g2d.PolygonSpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import org.mini2Dx.core.Graphics;
import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.Platform;
import org.mini2Dx.core.game.GameContainer;
import org.mini2Dx.core.reflect.jvm.JvmReflection;
import org.mini2Dx.libgdx.LibgdxAudio;
import org.mini2Dx.libgdx.LibgdxFiles;
import org.mini2Dx.libgdx.LibgdxFonts;
import org.mini2Dx.libgdx.LibgdxGraphics;
import org.mini2Dx.libgdx.LibgdxGraphicsUtils;
import org.mini2Dx.libgdx.LibgdxInput;
import org.mini2Dx.libgdx.LibgdxLogger;
import org.mini2Dx.libgdx.LibgdxTaskExecutor;
import org.mini2Dx.libgdx.game.ApplicationListener;
import org.mini2Dx.natives.OsInformation;

public abstract class GameWrapper
implements ApplicationListener {
    private final GameContainer gameContainer;
    private final String gameIdentifier;

    public GameWrapper(GameContainer gc, String gameIdentifier) {
        this.gameContainer = gc;
        this.gameIdentifier = gameIdentifier;
    }

    public abstract void initialise(String var1);

    protected Graphics createGraphicsContext() {
        LibgdxSpriteBatchWrapper spriteBatch = new LibgdxSpriteBatchWrapper();
        PolygonSpriteBatch polygonSpriteBatch = new PolygonSpriteBatch();
        ShapeRenderer shapeRenderer = new ShapeRenderer();
        return new LibgdxGraphics(this, spriteBatch, polygonSpriteBatch, shapeRenderer);
    }

    public void create() {
        Mdx.platform = GameWrapper.getPlatform();
        Mdx.gameIdentifier = this.gameIdentifier;
        this.initialise(this.gameIdentifier);
        Mdx.audio = new LibgdxAudio();
        Mdx.executor = new LibgdxTaskExecutor(Math.max(2, Runtime.getRuntime().availableProcessors()));
        Mdx.files = new LibgdxFiles();
        Mdx.fonts = new LibgdxFonts();
        Mdx.graphics = new LibgdxGraphicsUtils();
        Mdx.graphicsContext = this.createGraphicsContext();
        Mdx.input = new LibgdxInput();
        Mdx.log = new LibgdxLogger();
        Mdx.reflect = new JvmReflection();
        this.gameContainer.start(Mdx.graphicsContext);
    }

    public void resize(int width, int height) {
        if (this.gameContainer == null) {
            return;
        }
        this.gameContainer.resize(width, height);
    }

    @Override
    public void update(float delta) {
        if (this.gameContainer == null) {
            return;
        }
        this.gameContainer.preUpdate(delta);
        this.gameContainer.update(delta);
    }

    @Override
    public void interpolate(float alpha) {
        if (this.gameContainer == null) {
            return;
        }
        this.gameContainer.interpolate(alpha);
    }

    public void render() {
        if (this.gameContainer == null) {
            return;
        }
        this.gameContainer.render();
    }

    public void pause() {
        if (this.gameContainer == null) {
            return;
        }
        this.gameContainer.onPause();
    }

    public void resume() {
        if (this.gameContainer == null) {
            return;
        }
        this.gameContainer.onResume();
    }

    public void dispose() {
        if (this.gameContainer == null) {
            return;
        }
        this.gameContainer.dispose();
        Mdx.executor.dispose();
    }

    public abstract boolean isGameWindowReady();

    public static Platform getPlatform() {
        switch (OsInformation.getOs()) {
            case WINDOWS: {
                return Platform.WINDOWS;
            }
            case MAC: {
                return Platform.MAC;
            }
            case ANDROID: {
                return Platform.ANDROID;
            }
            case IOS: {
                return Platform.IOS;
            }
        }
        return Platform.LINUX;
    }
}

