/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.libgdx.graphics;

import org.mini2Dx.core.graphics.Color;
import org.mini2Dx.gdx.math.MathUtils;

public class LibgdxColor
implements Color {
    public com.badlogic.gdx.graphics.Color color;

    public LibgdxColor(int rgba8888) {
        this(new com.badlogic.gdx.graphics.Color(rgba8888));
    }

    public LibgdxColor(int r, int g, int b, int a) {
        this(new com.badlogic.gdx.graphics.Color((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f));
    }

    public LibgdxColor(float r, float g, float b, float a) {
        this(new com.badlogic.gdx.graphics.Color(r, g, b, a));
    }

    public LibgdxColor(byte r, byte g, byte b, byte a) {
        this.color = new com.badlogic.gdx.graphics.Color((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f);
    }

    public LibgdxColor(com.badlogic.gdx.graphics.Color color) {
        this.color = color;
    }

    public Color copy() {
        return new LibgdxColor(this.color.cpy());
    }

    public Color set(Color color) {
        return this.set(color.getRAsFloat(), color.getGAsFloat(), color.getBAsFloat(), color.getAAsFloat());
    }

    public Color set(float r, float g, float b, float a) {
        this.color.set(r, g, b, a);
        return this;
    }

    public Color set(byte r, byte g, byte b, byte a) {
        return this.set((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f);
    }

    public Color add(Color color) {
        return this.add(color.getRAsFloat(), color.getGAsFloat(), color.getBAsFloat(), color.getAAsFloat());
    }

    public Color add(float r, float g, float b, float a) {
        this.color.add(r, g, b, a);
        return this;
    }

    public Color add(byte r, byte g, byte b, byte a) {
        return this.add((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f);
    }

    public Color multiply(Color color) {
        return this.multiply(color.getRAsFloat(), color.getGAsFloat(), color.getBAsFloat(), color.getAAsFloat());
    }

    public Color multiply(float r, float g, float b, float a) {
        this.color.mul(r, g, b, a);
        return this;
    }

    public Color multiply(byte r, byte g, byte b, byte a) {
        return this.multiply((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f);
    }

    public Color multiply(float multiplier) {
        this.color.mul(multiplier);
        return this;
    }

    public Color subtract(Color color) {
        return this.subtract(color.getRAsFloat(), color.getGAsFloat(), color.getBAsFloat(), color.getAAsFloat());
    }

    public Color subtract(float r, float g, float b, float a) {
        this.color.sub(r, g, b, a);
        return this;
    }

    public Color subtract(byte r, byte g, byte b, byte a) {
        return this.subtract((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f);
    }

    public Color lerp(Color color, float t) {
        return this.lerp(color.getRAsFloat(), color.getGAsFloat(), color.getBAsFloat(), color.getAAsFloat(), t);
    }

    public Color lerp(float r, float g, float b, float a, float t) {
        this.color.lerp(r, g, b, a, t);
        return this;
    }

    public Color lerp(byte r, byte g, byte b, byte a, float t) {
        return this.lerp((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f, t);
    }

    public float getRAsFloat() {
        return this.color.r;
    }

    public float getGAsFloat() {
        return this.color.g;
    }

    public float getBAsFloat() {
        return this.color.b;
    }

    public float getAAsFloat() {
        return this.color.a;
    }

    public byte getRAsByte() {
        return (byte)MathUtils.round((float)(this.color.r * 255.0f));
    }

    public byte getGAsByte() {
        return (byte)MathUtils.round((float)(this.color.g * 255.0f));
    }

    public byte getBAsByte() {
        return (byte)MathUtils.round((float)(this.color.b * 255.0f));
    }

    public byte getAAsByte() {
        return (byte)MathUtils.round((float)(this.color.a * 255.0f));
    }

    public void setR(float r) {
        this.color.r = r;
    }

    public void setG(float g) {
        this.color.g = g;
    }

    public void setB(float b) {
        this.color.b = b;
    }

    public void setA(float a) {
        this.color.a = a;
    }

    public void setR(byte r) {
        this.color.r = (float)r / 255.0f;
    }

    public void setG(byte g) {
        this.color.g = (float)g / 255.0f;
    }

    public void setB(byte b) {
        this.color.b = (float)b / 255.0f;
    }

    public void setA(byte a) {
        this.color.a = (float)a / 255.0f;
    }

    public boolean equals(Color color) {
        if (color instanceof LibgdxColor) {
            LibgdxColor gdxColor = (LibgdxColor)color;
            return this.color.equals((Object)gdxColor.color);
        }
        if (!MathUtils.isEqual((float)this.getRAsFloat(), (float)color.getRAsFloat())) {
            return false;
        }
        if (!MathUtils.isEqual((float)this.getGAsFloat(), (float)color.getGAsFloat())) {
            return false;
        }
        if (!MathUtils.isEqual((float)this.getBAsFloat(), (float)color.getBAsFloat())) {
            return false;
        }
        return MathUtils.isEqual((float)this.getAAsFloat(), (float)color.getAAsFloat());
    }

    public float rf() {
        return this.getRAsFloat();
    }

    public float gf() {
        return this.getGAsFloat();
    }

    public float bf() {
        return this.getBAsFloat();
    }

    public float af() {
        return this.getAAsFloat();
    }

    public float rb() {
        return this.getRAsByte();
    }

    public float gb() {
        return this.getGAsByte();
    }

    public float bb() {
        return this.getBAsByte();
    }

    public float ab() {
        return this.getAAsByte();
    }

    public int argb8888() {
        return com.badlogic.gdx.graphics.Color.argb8888((com.badlogic.gdx.graphics.Color)this.color);
    }

    public int rgba8888() {
        return com.badlogic.gdx.graphics.Color.rgba8888((com.badlogic.gdx.graphics.Color)this.color);
    }

    public int rgba4444() {
        return com.badlogic.gdx.graphics.Color.rgba4444((com.badlogic.gdx.graphics.Color)this.color);
    }

    public int rgb888() {
        return com.badlogic.gdx.graphics.Color.rgb888((com.badlogic.gdx.graphics.Color)this.color);
    }

    public int rgb565() {
        return com.badlogic.gdx.graphics.Color.rgb565((com.badlogic.gdx.graphics.Color)this.color);
    }

    public int bgr565() {
        return (int)(this.color.b * 31.0f) << 11 | (int)(this.color.g * 63.0f) << 5 | (int)(this.color.r * 31.0f);
    }

    public int bgra4444() {
        return (int)(this.color.b * 15.0f) << 12 | (int)(this.color.g * 15.0f) << 8 | (int)(this.color.r * 15.0f) << 4 | (int)(this.color.a * 15.0f);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LibgdxColor that = (LibgdxColor)o;
        return this.color.equals((Object)that.color);
    }

    public int hashCode() {
        return this.color.hashCode();
    }
}

