/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.libgdx.graphics;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Cursor;
import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.graphics.CustomCursor;
import org.mini2Dx.core.graphics.Pixmap;
import org.mini2Dx.libgdx.graphics.LibgdxPixmap;

public class LibgdxCustomCursor
extends CustomCursor {
    private final Cursor upCursor;
    private final Cursor downCursor;

    public LibgdxCustomCursor(Pixmap upPixmap, Pixmap downPixmap, int xHotspot, int yHotspot) {
        super(upPixmap, downPixmap, xHotspot, yHotspot);
        switch (Mdx.platform) {
            case WINDOWS: 
            case MAC: 
            case LINUX: {
                LibgdxPixmap gdxUpPixmap = (LibgdxPixmap)upPixmap;
                LibgdxPixmap gdxDownPixmap = (LibgdxPixmap)downPixmap;
                this.upCursor = Gdx.graphics.newCursor(gdxUpPixmap.pixmap, xHotspot, yHotspot);
                this.downCursor = Gdx.graphics.newCursor(gdxDownPixmap.pixmap, xHotspot, yHotspot);
                Gdx.graphics.setCursor(this.upCursor);
                break;
            }
            default: {
                this.upCursor = null;
                this.downCursor = null;
            }
        }
    }

    public boolean keyDown(int keycode) {
        return false;
    }

    public boolean keyUp(int keycode) {
        return false;
    }

    public boolean keyTyped(char character) {
        return false;
    }

    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        if (this.downCursor != null) {
            Gdx.graphics.setCursor(this.downCursor);
        }
        return false;
    }

    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        if (this.upCursor != null) {
            Gdx.graphics.setCursor(this.upCursor);
        }
        return false;
    }

    public boolean touchDragged(int screenX, int screenY, int pointer) {
        return false;
    }

    public boolean mouseMoved(int screenX, int screenY) {
        return false;
    }

    public boolean scrolled(int amount) {
        return false;
    }
}

