/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.libgdx.graphics;

import com.badlogic.gdx.graphics.Pixmap;
import org.mini2Dx.core.graphics.Color;
import org.mini2Dx.core.graphics.Pixmap;
import org.mini2Dx.core.graphics.PixmapBlending;
import org.mini2Dx.core.graphics.PixmapFilter;
import org.mini2Dx.core.graphics.PixmapFormat;
import org.mini2Dx.libgdx.graphics.LibgdxColor;

public class LibgdxPixmap
implements Pixmap {
    public final com.badlogic.gdx.graphics.Pixmap pixmap;

    public LibgdxPixmap(com.badlogic.gdx.graphics.Pixmap pixmap) {
        this.pixmap = pixmap;
    }

    public void fill() {
        this.pixmap.fill();
    }

    public void drawLine(int x, int y, int x2, int y2) {
        this.pixmap.drawLine(x, y, x2, y2);
    }

    public void drawRectangle(int x, int y, int width, int height) {
        this.pixmap.drawRectangle(x, y, width, height);
    }

    public void drawPixmap(Pixmap pixmap, int x, int y) {
        LibgdxPixmap gdxPixmap = (LibgdxPixmap)pixmap;
        this.pixmap.drawPixmap(gdxPixmap.pixmap, x, y);
    }

    public void drawPixmap(Pixmap pixmap, int x, int y, int srcx, int srcy, int srcWidth, int srcHeight) {
        LibgdxPixmap gdxPixmap = (LibgdxPixmap)pixmap;
        this.pixmap.drawPixmap(gdxPixmap.pixmap, x, y, srcx, srcy, srcWidth, srcHeight);
    }

    public void drawPixmap(Pixmap pixmap, int srcx, int srcy, int srcWidth, int srcHeight, int dstx, int dsty, int dstWidth, int dstHeight) {
        LibgdxPixmap gdxPixmap = (LibgdxPixmap)pixmap;
        this.pixmap.drawPixmap(gdxPixmap.pixmap, srcx, srcy, srcWidth, srcHeight, dstx, dsty, dstWidth, dstHeight);
    }

    public void fillRectangle(int x, int y, int width, int height) {
        this.pixmap.fillRectangle(x, y, width, height);
    }

    public void drawCircle(int x, int y, int radius) {
        this.pixmap.drawCircle(x, y, radius);
    }

    public void fillCircle(int x, int y, int radius) {
        this.pixmap.fillCircle(x, y, radius);
    }

    public void fillTriangle(int x1, int y1, int x2, int y2, int x3, int y3) {
        this.pixmap.fillTriangle(x1, y1, x2, y2, x3, y3);
    }

    public void drawPixel(int x, int y) {
        this.pixmap.drawPixel(x, y);
    }

    public void drawPixel(int x, int y, Color color) {
        this.pixmap.drawPixel(x, y, color.rgba8888());
    }

    public int getPixel(int x, int y) {
        return this.pixmap.getPixel(x, y);
    }

    public byte[] getPixels() {
        return null;
    }

    public int getWidth() {
        return this.pixmap.getWidth();
    }

    public int getHeight() {
        return this.pixmap.getHeight();
    }

    public PixmapFormat getFormat() {
        switch (this.pixmap.getFormat()) {
            case Alpha: {
                return PixmapFormat.ALPHA;
            }
            case Intensity: {
                return PixmapFormat.INTENSITY;
            }
            case LuminanceAlpha: {
                return PixmapFormat.LUMINANCE_ALPHA;
            }
            case RGB565: {
                return PixmapFormat.RGB565;
            }
            case RGBA4444: {
                return PixmapFormat.RGBA4444;
            }
            case RGB888: {
                return PixmapFormat.RGB888;
            }
        }
        return PixmapFormat.RGBA8888;
    }

    public PixmapBlending getBlending() {
        switch (this.pixmap.getBlending()) {
            default: {
                return PixmapBlending.NONE;
            }
            case SourceOver: 
        }
        return PixmapBlending.SOURCE_OVER;
    }

    public void setBlending(PixmapBlending blending) {
        switch (blending) {
            default: {
                this.pixmap.setBlending(Pixmap.Blending.None);
                break;
            }
            case SOURCE_OVER: {
                this.pixmap.setBlending(Pixmap.Blending.SourceOver);
            }
        }
    }

    public PixmapFilter getFilter() {
        switch (this.pixmap.getFilter()) {
            default: {
                return PixmapFilter.NEAREST_NEIGHBOUR;
            }
            case BiLinear: 
        }
        return PixmapFilter.BILINEAR;
    }

    public void setFilter(PixmapFilter filter) {
        switch (filter) {
            default: {
                this.pixmap.setFilter(Pixmap.Filter.NearestNeighbour);
                break;
            }
            case BILINEAR: {
                this.pixmap.setFilter(Pixmap.Filter.BiLinear);
            }
        }
    }

    public void setColor(Color color) {
        LibgdxColor gdxColor = (LibgdxColor)color;
        this.pixmap.setColor(gdxColor.color);
    }

    public void dispose() {
        this.pixmap.dispose();
    }

    public static Pixmap.Format toGdxPixmapFormat(PixmapFormat format) {
        switch (format) {
            case ALPHA: {
                return Pixmap.Format.Alpha;
            }
            case INTENSITY: {
                return Pixmap.Format.Intensity;
            }
            case LUMINANCE_ALPHA: {
                return Pixmap.Format.LuminanceAlpha;
            }
            case RGB565: {
                return Pixmap.Format.RGB565;
            }
            case RGBA4444: {
                return Pixmap.Format.RGBA4444;
            }
            case RGB888: {
                return Pixmap.Format.RGB888;
            }
        }
        return Pixmap.Format.RGBA8888;
    }
}

