/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.libgdx.graphics;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import org.mini2Dx.core.graphics.Shader;
import org.mini2Dx.core.graphics.ShaderType;
import org.mini2Dx.core.graphics.Texture;
import org.mini2Dx.gdx.math.Matrix4;
import org.mini2Dx.gdx.math.Vector2;
import org.mini2Dx.gdx.math.Vector3;
import org.mini2Dx.libgdx.graphics.LibgdxTexture;

public class LibgdxShader
implements Shader {
    private static int AUTO_BIND_ID = 1;
    public final ShaderProgram shaderProgram;
    private final com.badlogic.gdx.math.Matrix4 tmpMatrix4 = new com.badlogic.gdx.math.Matrix4();

    public LibgdxShader(ShaderProgram shaderProgram) {
        this.shaderProgram = shaderProgram;
    }

    public void begin() {
        this.shaderProgram.begin();
    }

    public void end() {
        this.shaderProgram.end();
    }

    public boolean hasParameter(String name) {
        return this.shaderProgram.hasAttribute(name) || this.shaderProgram.hasUniform(name);
    }

    public void setParameter(String name, Texture texture) {
        int n;
        this.setParameter(name, AUTO_BIND_ID, texture);
        if (AUTO_BIND_ID + 1 >= 34018) {
            n = 1;
        } else {
            int n2 = AUTO_BIND_ID;
            n = n2;
            AUTO_BIND_ID = n2 + 1;
        }
        AUTO_BIND_ID = n;
    }

    public void setParameter(String name, int bindId, Texture texture) {
        LibgdxTexture libgdxTexture = (LibgdxTexture)texture;
        libgdxTexture.bind(bindId);
        Gdx.gl.glActiveTexture(33984);
        this.shaderProgram.setUniformi(name, bindId);
    }

    public void setParameterf(String name, float value) {
        this.shaderProgram.setUniformf(name, value);
    }

    public void setParameterf(String name, float value1, float value2) {
        this.shaderProgram.setUniformf(name, value1, value2);
    }

    public void setParameterf(String name, float value1, float value2, float value3) {
        this.shaderProgram.setUniformf(name, value1, value2, value3);
    }

    public void setParameterf(String name, float value1, float value2, float value3, float value4) {
        if (this.shaderProgram.hasAttribute(name)) {
            this.shaderProgram.setAttributef(name, value1, value2, value3, value4);
        } else {
            this.shaderProgram.setUniformf(name, value1, value2, value3, value4);
        }
    }

    public void setParameterf(String name, Vector2 vec) {
        this.shaderProgram.setUniformf(name, vec.x, vec.y);
    }

    public void setParameterf(String name, Vector3 vec) {
        this.shaderProgram.setUniformf(name, vec.x, vec.y, vec.z);
    }

    public void setParameteri(String name, int value) {
        this.shaderProgram.setUniformi(name, value);
    }

    public void setParameterMatrix(String name, Matrix4 matrix) {
        this.tmpMatrix4.set(matrix.getValues());
        this.shaderProgram.setUniformMatrix(name, this.tmpMatrix4);
    }

    public void setParameterMatrix(String name, Matrix4 matrix, boolean transpose) {
        this.tmpMatrix4.set(matrix.getValues());
        this.shaderProgram.setUniformMatrix(name, this.tmpMatrix4, transpose);
    }

    public String getLog() {
        return this.shaderProgram.getLog();
    }

    public boolean isCompiled() {
        return this.shaderProgram.isCompiled();
    }

    public ShaderType getShaderType() {
        return ShaderType.GLSL;
    }

    public void dispose() {
        this.shaderProgram.dispose();
    }
}

