/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.libgdx.graphics;

import com.badlogic.gdx.graphics.Texture;
import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.geom.Rectangle;
import org.mini2Dx.core.graphics.Color;
import org.mini2Dx.core.graphics.Pixmap;
import org.mini2Dx.core.graphics.PixmapFormat;
import org.mini2Dx.core.graphics.Sprite;
import org.mini2Dx.core.graphics.TextureRegion;
import org.mini2Dx.libgdx.graphics.LibgdxColor;
import org.mini2Dx.libgdx.graphics.LibgdxPixmap;
import org.mini2Dx.libgdx.graphics.LibgdxTexture;
import org.mini2Dx.libgdx.graphics.LibgdxTextureRegion;

public class LibgdxSprite
implements Sprite {
    public final com.badlogic.gdx.graphics.g2d.Sprite sprite;
    private final LibgdxColor color;
    private final Rectangle boundingRectangle = new Rectangle();

    public LibgdxSprite() {
        this.sprite = new com.badlogic.gdx.graphics.g2d.Sprite();
        this.color = new LibgdxColor(this.sprite.getColor());
        this.setBoundingRectangle();
    }

    public LibgdxSprite(org.mini2Dx.core.graphics.Texture texture) {
        this(texture, texture.getWidth(), texture.getHeight());
    }

    public LibgdxSprite(org.mini2Dx.core.graphics.Texture texture, int srcWidth, int srcHeight) {
        this(texture, 0, 0, srcWidth, srcHeight);
    }

    public LibgdxSprite(org.mini2Dx.core.graphics.Texture texture, int srcX, int srcY, int srcWidth, int srcHeight) {
        LibgdxTexture libgdxTexture = (LibgdxTexture)texture;
        this.sprite = new com.badlogic.gdx.graphics.g2d.Sprite((Texture)libgdxTexture);
        this.color = new LibgdxColor(this.sprite.getColor());
        this.flip(false, true);
        this.setBoundingRectangle();
    }

    public LibgdxSprite(TextureRegion region) {
        LibgdxTextureRegion libgdxTextureRegion = (LibgdxTextureRegion)region;
        this.sprite = new com.badlogic.gdx.graphics.g2d.Sprite((com.badlogic.gdx.graphics.g2d.TextureRegion)libgdxTextureRegion.textureRegion);
        this.color = new LibgdxColor(this.sprite.getColor());
        this.setFlip(region.isFlipX(), region.isFlipY());
        this.setBoundingRectangle();
    }

    public LibgdxSprite(TextureRegion region, int srcX, int srcY, int srcWidth, int srcHeight) {
        LibgdxTextureRegion libgdxTextureRegion = (LibgdxTextureRegion)region;
        this.sprite = new com.badlogic.gdx.graphics.g2d.Sprite((com.badlogic.gdx.graphics.g2d.TextureRegion)libgdxTextureRegion.textureRegion, srcX, srcY, srcWidth, srcHeight);
        this.color = new LibgdxColor(this.sprite.getColor());
        this.setFlip(region.isFlipX(), region.isFlipY());
        this.setBoundingRectangle();
    }

    public LibgdxSprite(Sprite sprite) {
        this();
        this.set(sprite);
    }

    private void setBoundingRectangle() {
        com.badlogic.gdx.math.Rectangle boundingRectangle = this.sprite.getBoundingRectangle();
        this.boundingRectangle.set(boundingRectangle.x, boundingRectangle.y, boundingRectangle.width, boundingRectangle.height);
    }

    public void set(Sprite sprite) {
        this.sprite.set(((LibgdxSprite)sprite).sprite);
        this.color.color = ((LibgdxSprite)sprite).sprite.getColor();
        this.setBoundingRectangle();
    }

    public void setBounds(float x, float y, float width, float height) {
        this.sprite.setBounds(x, y, width, height);
    }

    public void setSize(float width, float height) {
        this.sprite.setSize(width, height);
    }

    public void setPosition(float x, float y) {
        this.sprite.setPosition(x, y);
    }

    public void setOriginBasedPosition(float x, float y) {
        this.sprite.setOriginBasedPosition(x, y);
    }

    public void setCenterX(float x) {
        this.sprite.setCenterX(x);
    }

    public void setCenterY(float y) {
        this.sprite.setCenterY(y);
    }

    public void setCenter(float x, float y) {
        this.sprite.setCenter(x, y);
    }

    public void translateX(float xAmount) {
        this.sprite.translateX(xAmount);
    }

    public void translateY(float yAmount) {
        this.sprite.translateY(yAmount);
    }

    public void translate(float xAmount, float yAmount) {
        this.sprite.translate(xAmount, yAmount);
    }

    public void setOrigin(float originX, float originY) {
        this.sprite.setOrigin(originX, originY);
    }

    public void setOriginCenter() {
        this.sprite.setOriginCenter();
    }

    public float getRotation() {
        return this.sprite.getRotation();
    }

    public void setRotation(float degrees) {
        this.sprite.setRotation(degrees);
    }

    public void rotate(float degrees) {
        this.sprite.rotate(degrees);
    }

    public void rotate90(boolean clockwise) {
        this.sprite.rotate90(clockwise);
    }

    public void setScale(float scaleXY) {
        this.sprite.setScale(scaleXY);
    }

    public void setScale(float scaleX, float scaleY) {
        this.sprite.setScale(scaleX, scaleY);
    }

    public void scale(float amount) {
        this.sprite.setScale(amount);
    }

    public float[] getVertices() {
        return this.sprite.getVertices();
    }

    public Rectangle getBoundingRectangle() {
        return this.boundingRectangle;
    }

    public float getX() {
        return this.sprite.getX();
    }

    public void setX(float x) {
        this.sprite.setX(x);
    }

    public float getY() {
        return this.sprite.getY();
    }

    public void setY(float y) {
        this.sprite.setY(y);
    }

    public float getWidth() {
        return this.sprite.getWidth();
    }

    public float getHeight() {
        return this.sprite.getHeight();
    }

    public float getOriginX() {
        return this.sprite.getOriginX();
    }

    public float getOriginY() {
        return this.sprite.getOriginY();
    }

    public float getScaleX() {
        return this.sprite.getScaleX();
    }

    public float getScaleY() {
        return this.sprite.getScaleY();
    }

    public Color getTint() {
        return this.color;
    }

    public void setTint(Color tint) {
        this.sprite.setColor(tint.rf(), tint.gf(), tint.bf(), tint.af());
    }

    public void setRegion(org.mini2Dx.core.graphics.Texture texture) {
        this.sprite.setRegion((Texture)((LibgdxTexture)texture));
    }

    public void setRegion(int x, int y, int width, int height) {
        this.sprite.setRegion(x, y, width, height);
    }

    public void setRegion(float u, float v, float u2, float v2) {
        this.sprite.setRegion(u, v, u2, v2);
    }

    public void setRegion(TextureRegion region) {
        this.sprite.setRegion((com.badlogic.gdx.graphics.g2d.TextureRegion)((LibgdxTextureRegion)region).textureRegion);
    }

    public void setRegion(TextureRegion region, int x, int y, int width, int height) {
        this.sprite.setRegion((com.badlogic.gdx.graphics.g2d.TextureRegion)((LibgdxTextureRegion)region).textureRegion, x, y, width, height);
    }

    public org.mini2Dx.core.graphics.Texture getTexture() {
        return (LibgdxTexture)this.sprite.getTexture();
    }

    public void setTexture(org.mini2Dx.core.graphics.Texture texture) {
        this.sprite.setTexture((Texture)((LibgdxTexture)texture));
    }

    public float getU() {
        return this.sprite.getU();
    }

    public void setU(float u) {
        this.sprite.setU(u);
    }

    public float getV() {
        return this.sprite.getV();
    }

    public void setV(float v) {
        this.sprite.setV(v);
    }

    public float getU2() {
        return this.sprite.getU2();
    }

    public void setU2(float u2) {
        this.sprite.setU2(u2);
    }

    public float getV2() {
        return this.sprite.getV2();
    }

    public void setV2(float v2) {
        this.sprite.setV2(v2);
    }

    public int getRegionX() {
        return this.sprite.getRegionX();
    }

    public void setRegionX(int x) {
        this.sprite.setRegionX(x);
    }

    public int getRegionY() {
        this.setFlipY(!this.isFlipY());
        int result = this.sprite.getRegionY();
        this.setFlipY(!this.isFlipY());
        return result;
    }

    public void setRegionY(int y) {
        this.setFlipY(!this.isFlipY());
        this.sprite.setRegionY(y);
        this.setFlipY(!this.isFlipY());
    }

    public int getRegionWidth() {
        return this.sprite.getRegionWidth();
    }

    public void setRegionWidth(int width) {
        this.sprite.setRegionWidth(width);
    }

    public int getRegionHeight() {
        return this.sprite.getRegionHeight();
    }

    public void setRegionHeight(int height) {
        this.sprite.setRegionHeight(height);
    }

    public void flip(boolean x, boolean y) {
        this.sprite.flip(x, y);
    }

    public void setFlip(boolean x, boolean y) {
        boolean performX = false;
        boolean performY = false;
        if (this.isFlipX() != x) {
            performX = true;
        }
        if (this.isFlipY() != y) {
            performY = true;
        }
        this.flip(performX, performY);
    }

    public boolean isFlipX() {
        return this.sprite.isFlipX();
    }

    public float getAlpha() {
        return this.sprite.getColor().a;
    }

    public void setAlpha(float a) {
        this.sprite.setAlpha(a);
    }

    public void setFlipX(boolean flipX) {
        if (flipX == this.isFlipX()) {
            return;
        }
        this.flip(true, false);
    }

    public boolean isFlipY() {
        return !this.sprite.isFlipY();
    }

    public void setFlipY(boolean flipY) {
        if (flipY == this.isFlipY()) {
            return;
        }
        this.flip(false, true);
    }

    public void scroll(float xAmount, float yAmount) {
        this.sprite.scroll(xAmount, yAmount);
    }

    public Pixmap toPixmap() {
        LibgdxTexture texture = (LibgdxTexture)this.getTexture();
        if (!texture.getTextureData().isPrepared()) {
            texture.getTextureData().prepare();
        }
        com.badlogic.gdx.graphics.Pixmap texturePixmap = texture.getTextureData().consumePixmap();
        LibgdxPixmap result = (LibgdxPixmap)Mdx.graphics.newPixmap(this.getRegionWidth(), this.getRegionHeight(), PixmapFormat.RGBA8888);
        result.pixmap.drawPixmap(texturePixmap, 0, 0, this.getRegionX(), this.getRegionY(), this.getRegionWidth(), this.getRegionHeight());
        return result;
    }

    public TextureRegion[][] split(int tileWidth, int tileHeight) {
        int x = this.getRegionX();
        int y = this.getRegionY();
        int width = this.getRegionWidth();
        int height = this.getRegionHeight();
        int rows = height / tileHeight;
        int columns = width / tileWidth;
        int startX = x;
        TextureRegion[][] result = new TextureRegion[rows][columns];
        int row = 0;
        while (row < rows) {
            x = startX;
            int col = 0;
            while (col < columns) {
                result[row][col] = Mdx.graphics.newTextureRegion(this.getTexture(), x, y, tileWidth, tileHeight);
                ++col;
                x += tileWidth;
            }
            ++row;
            y += tileHeight;
        }
        return result;
    }
}

