/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.libgdx.graphics;

import com.badlogic.gdx.graphics.Texture;
import org.mini2Dx.core.Graphics;
import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.graphics.Color;
import org.mini2Dx.core.graphics.Colors;
import org.mini2Dx.core.graphics.Shader;
import org.mini2Dx.core.graphics.Sprite;
import org.mini2Dx.core.graphics.SpriteCache;
import org.mini2Dx.core.graphics.TextureRegion;
import org.mini2Dx.libgdx.LibgdxGraphics;
import org.mini2Dx.libgdx.graphics.LibgdxColor;
import org.mini2Dx.libgdx.graphics.LibgdxShader;
import org.mini2Dx.libgdx.graphics.LibgdxSprite;
import org.mini2Dx.libgdx.graphics.LibgdxTextureRegion;

public class LibgdxSpriteCache
implements SpriteCache {
    private com.badlogic.gdx.graphics.g2d.SpriteCache gdxCache;
    private int indexCounter;
    private Shader currentCustomShader;
    private Color currentCustomColor = Colors.WHITE().copy();
    private boolean isDrawing;

    public LibgdxSpriteCache() {
        this.gdxCache = new com.badlogic.gdx.graphics.g2d.SpriteCache();
        this.gdxCache.setColor(((LibgdxColor)this.currentCustomColor).color);
    }

    public int add(Sprite sprite) {
        this.gdxCache.add(((LibgdxSprite)sprite).sprite);
        return this.indexCounter++;
    }

    public int add(org.mini2Dx.core.graphics.Texture texture, float x, float y) {
        return this.add(texture, x, y, 0, 0, texture.getWidth(), texture.getHeight());
    }

    public int add(org.mini2Dx.core.graphics.Texture texture, float x, float y, int srcX, int srcY, int srcWidth, int srcHeight) {
        return this.add(texture, x, y, srcX, srcY, srcWidth, srcHeight, false, false);
    }

    public int add(org.mini2Dx.core.graphics.Texture texture, float x, float y, int srcX, int srcY, int srcWidth, int srcHeight, boolean flipX, boolean flipY) {
        return this.add(texture, x, y, srcX, srcY, srcWidth, srcHeight, 1.0f, 1.0f, false, false);
    }

    public int add(org.mini2Dx.core.graphics.Texture texture, float x, float y, int srcX, int srcY, int srcWidth, int srcHeight, float scaleX, float scaleY, boolean flipX, boolean flipY) {
        return this.add(texture, x, y, srcX, srcY, srcWidth, srcHeight, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, false, false);
    }

    public int add(org.mini2Dx.core.graphics.Texture texture, float x, float y, int srcX, int srcY, int srcWidth, int srcHeight, float scaleX, float scaleY, float originX, float originY, float rotation, boolean flipX, boolean flipY) {
        this.gdxCache.add((Texture)texture, x, y, originX, originY, (float)srcWidth * scaleX, (float)srcHeight * scaleY, scaleX, scaleY, rotation, srcX, srcY, srcWidth, srcHeight, flipX, flipY);
        return this.indexCounter++;
    }

    public int add(TextureRegion region, float x, float y) {
        return this.add(region, x, y, 1.0f, 1.0f);
    }

    public int add(TextureRegion region, float x, float y, float scaleX, float scaleY) {
        return this.add(region, x, y, scaleX, scaleY, 0.0f, 0.0f, 0.0f);
    }

    public int add(TextureRegion region, float x, float y, float scaleX, float scaleY, float originX, float originY, float rotation) {
        return this.add(region, x, y, scaleX, scaleY, 0.0f, 0.0f, 0.0f, false, false);
    }

    public int add(TextureRegion region, float x, float y, float scaleX, float scaleY, float originX, float originY, float rotation, boolean flipX, boolean flipY) {
        region.flip(flipX, flipY);
        this.gdxCache.add((com.badlogic.gdx.graphics.g2d.TextureRegion)((LibgdxTextureRegion)region).textureRegion, x, y, originX, originY, (float)region.getRegionWidth() * scaleX, (float)region.getRegionHeight() * scaleY, scaleX, scaleY, rotation);
        region.flip(flipX, flipY);
        return this.indexCounter++;
    }

    public void clear() {
        this.gdxCache.clear();
        this.indexCounter = 0;
    }

    public void dispose() {
        this.gdxCache.dispose();
    }

    public void draw(Graphics g, int cacheID) {
        this.gdxCache.getProjectionMatrix().set(((LibgdxGraphics)Mdx.graphicsContext).spriteBatch.getProjectionMatrix());
        this.gdxCache.getTransformMatrix().set(((LibgdxGraphics)Mdx.graphicsContext).spriteBatch.getTransformMatrix());
        this.gdxCache.begin();
        this.gdxCache.draw(cacheID);
        this.gdxCache.end();
    }

    public void draw(Graphics g, int cacheID, int offset, int length) {
        this.gdxCache.getProjectionMatrix().set(((LibgdxGraphics)Mdx.graphicsContext).spriteBatch.getProjectionMatrix());
        this.gdxCache.getTransformMatrix().set(((LibgdxGraphics)Mdx.graphicsContext).spriteBatch.getTransformMatrix());
        this.gdxCache.begin();
        this.gdxCache.draw(cacheID, offset, length);
        this.gdxCache.end();
    }

    public void beginCache() {
        this.gdxCache.beginCache();
        this.isDrawing = true;
    }

    public void beginCache(int cacheID) {
        this.gdxCache.beginCache(cacheID);
        this.isDrawing = true;
    }

    public int endCache() {
        this.isDrawing = false;
        return this.gdxCache.endCache();
    }

    public Color getColor() {
        return this.currentCustomColor.copy();
    }

    public void setColor(Color tint) {
        this.currentCustomColor.set(tint);
        this.gdxCache.setColor(((LibgdxColor)tint).color);
    }

    public void setColor(float r, float g, float b, float a) {
        this.currentCustomColor.set(r, g, b, a);
        this.gdxCache.setColor(r, g, b, a);
    }

    public Shader getCustomShader() {
        return this.currentCustomShader;
    }

    public void setCustomShader(Shader shader) {
        this.currentCustomShader = shader;
        this.gdxCache.setShader(((LibgdxShader)shader).shaderProgram);
    }

    public boolean isDrawing() {
        return this.isDrawing;
    }
}

