/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.libgdx.graphics;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.TextureData;
import org.mini2Dx.core.graphics.Pixmap;
import org.mini2Dx.core.graphics.TextureAddressMode;
import org.mini2Dx.core.graphics.TextureFilter;
import org.mini2Dx.libgdx.graphics.LibgdxPixmap;

public class LibgdxTexture
extends Texture
implements org.mini2Dx.core.graphics.Texture {
    public LibgdxTexture(String internalPath) {
        super(internalPath);
    }

    public LibgdxTexture(FileHandle file) {
        super(file);
    }

    public LibgdxTexture(FileHandle file, boolean useMipMaps) {
        super(file, useMipMaps);
    }

    public LibgdxTexture(FileHandle file, Pixmap.Format format, boolean useMipMaps) {
        super(file, format, useMipMaps);
    }

    public LibgdxTexture(com.badlogic.gdx.graphics.Pixmap pixmap) {
        super(pixmap);
    }

    public LibgdxTexture(com.badlogic.gdx.graphics.Pixmap pixmap, boolean useMipMaps) {
        super(pixmap, useMipMaps);
    }

    public LibgdxTexture(com.badlogic.gdx.graphics.Pixmap pixmap, Pixmap.Format format, boolean useMipMaps) {
        super(pixmap, format, useMipMaps);
    }

    public LibgdxTexture(int width, int height, Pixmap.Format format) {
        super(width, height, format);
    }

    public LibgdxTexture(TextureData data) {
        super(data);
    }

    protected LibgdxTexture(int glTarget, int glHandle, TextureData data) {
        super(glTarget, glHandle, data);
    }

    public void draw(Pixmap pixmap, int x, int y) {
        LibgdxPixmap gdxPixmap = (LibgdxPixmap)pixmap;
        this.draw(gdxPixmap.pixmap, x, y);
    }

    public TextureAddressMode getUAddressMode() {
        switch (super.getUWrap()) {
            case MirroredRepeat: {
                return TextureAddressMode.MIRROR;
            }
            case Repeat: {
                return TextureAddressMode.WRAP;
            }
        }
        return TextureAddressMode.CLAMP;
    }

    public void setUAddressMode(TextureAddressMode mode) {
        this.setAddressMode(mode, this.getVAddressMode());
    }

    public TextureAddressMode getVAddressMode() {
        switch (super.getVWrap()) {
            case MirroredRepeat: {
                return TextureAddressMode.MIRROR;
            }
            case Repeat: {
                return TextureAddressMode.WRAP;
            }
        }
        return TextureAddressMode.CLAMP;
    }

    public void setVAddressMode(TextureAddressMode mode) {
        this.setAddressMode(this.getUAddressMode(), mode);
    }

    public void setAddressMode(TextureAddressMode u, TextureAddressMode v) {
        Texture.TextureWrap vWrap;
        Texture.TextureWrap uWrap;
        switch (u) {
            case MIRROR: {
                uWrap = Texture.TextureWrap.MirroredRepeat;
                break;
            }
            case WRAP: {
                uWrap = Texture.TextureWrap.Repeat;
                break;
            }
            default: {
                uWrap = Texture.TextureWrap.ClampToEdge;
            }
        }
        switch (v) {
            case MIRROR: {
                vWrap = Texture.TextureWrap.MirroredRepeat;
                break;
            }
            case WRAP: {
                vWrap = Texture.TextureWrap.Repeat;
                break;
            }
            default: {
                vWrap = Texture.TextureWrap.ClampToEdge;
            }
        }
        super.setWrap(uWrap, vWrap);
    }

    public TextureFilter getMinTextureFilter() {
        switch (super.getMinFilter()) {
            case Nearest: {
                break;
            }
            case Linear: {
                break;
            }
            case MipMap: {
                break;
            }
            case MipMapNearestNearest: {
                break;
            }
            case MipMapLinearNearest: {
                break;
            }
            case MipMapNearestLinear: {
                break;
            }
        }
        return TextureFilter.LINEAR;
    }

    public TextureFilter getMagTextureFilter() {
        switch (super.getMagFilter()) {
            case Nearest: {
                break;
            }
            case Linear: {
                break;
            }
            case MipMap: {
                break;
            }
            case MipMapNearestNearest: {
                break;
            }
            case MipMapLinearNearest: {
                break;
            }
            case MipMapNearestLinear: {
                break;
            }
        }
        return TextureFilter.LINEAR;
    }

    public void setTextureFilter(TextureFilter minFilter, TextureFilter magFilter) {
    }
}

