/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.libgdx.graphics;

import com.badlogic.gdx.graphics.LibgdxTextureRegionWrapper;
import org.mini2Dx.core.Mdx;
import org.mini2Dx.core.graphics.Pixmap;
import org.mini2Dx.core.graphics.PixmapFormat;
import org.mini2Dx.core.graphics.Texture;
import org.mini2Dx.core.graphics.TextureRegion;
import org.mini2Dx.libgdx.graphics.LibgdxPixmap;
import org.mini2Dx.libgdx.graphics.LibgdxTexture;

public class LibgdxTextureRegion
implements TextureRegion {
    public final LibgdxTextureRegionWrapper textureRegion;

    public LibgdxTextureRegion(LibgdxTextureRegionWrapper textureRegion) {
        this.textureRegion = textureRegion;
        this.setFlip(false, false);
    }

    public LibgdxTextureRegion(LibgdxTextureRegion textureRegion) {
        this.textureRegion = new LibgdxTextureRegionWrapper(textureRegion.textureRegion);
    }

    public LibgdxTextureRegion(LibgdxTextureRegion textureRegion, int x, int y, int width, int height) {
        this.textureRegion = new LibgdxTextureRegionWrapper(textureRegion.textureRegion, x, y, width, height);
    }

    public void setRegion(Texture texture) {
        LibgdxTexture gdxTexture = (LibgdxTexture)texture;
        this.textureRegion.setRegion(gdxTexture);
    }

    public void setRegion(int x, int y, int width, int height) {
        this.textureRegion.setRegion(x, y, width, height);
    }

    public void setRegion(float u, float v, float u2, float v2) {
        this.textureRegion.setRegion(u, v, u2, v2);
    }

    public void setRegion(TextureRegion region) {
        LibgdxTextureRegion gdxTextureRegion = (LibgdxTextureRegion)region;
        this.textureRegion.setRegion(gdxTextureRegion.textureRegion);
    }

    public void setRegion(TextureRegion region, int x, int y, int width, int height) {
        LibgdxTextureRegion gdxTextureRegion = (LibgdxTextureRegion)region;
        this.textureRegion.setRegion(gdxTextureRegion.textureRegion, x, y, width, height);
    }

    public Texture getTexture() {
        return (LibgdxTexture)this.textureRegion.getTexture();
    }

    public void setTexture(Texture texture) {
        LibgdxTexture gdxTexture = (LibgdxTexture)texture;
        this.textureRegion.setTexture(gdxTexture);
    }

    public float getU() {
        return this.textureRegion.getU();
    }

    public void setU(float u) {
        this.textureRegion.setU(u);
    }

    public float getV() {
        return this.textureRegion.getV();
    }

    public void setV(float v) {
        this.textureRegion.setV(v);
    }

    public float getU2() {
        return this.textureRegion.getU2();
    }

    public void setU2(float u2) {
        this.textureRegion.setU2(u2);
    }

    public float getV2() {
        return this.textureRegion.getV2();
    }

    public void setV2(float v2) {
        this.textureRegion.setV2(v2);
    }

    public int getRegionX() {
        return this.textureRegion.getRegionX();
    }

    public void setRegionX(int x) {
        this.textureRegion.setRegionX(x);
    }

    public int getRegionY() {
        return this.textureRegion.getRegionY();
    }

    public void setRegionY(int y) {
        this.textureRegion.setRegionY(y);
    }

    public int getRegionWidth() {
        return this.textureRegion.getRegionWidth();
    }

    public void setRegionWidth(int width) {
        this.textureRegion.setRegionWidth(width);
    }

    public int getRegionHeight() {
        return this.textureRegion.getRegionHeight();
    }

    public void setRegionHeight(int height) {
        this.textureRegion.setRegionHeight(height);
    }

    public void flip(boolean x, boolean y) {
        this.textureRegion.flip(x, y);
    }

    public void setFlip(boolean flipX, boolean flipY) {
        this.setFlipX(flipX);
        this.setFlipY(flipY);
    }

    public boolean isFlipX() {
        return this.textureRegion.isFlipX();
    }

    public void setFlipX(boolean flipX) {
        this.textureRegion.setFlipX(flipX);
    }

    public boolean isFlipY() {
        return this.textureRegion.isFlipY();
    }

    public void setFlipY(boolean flipY) {
        this.textureRegion.setFlipY(flipY);
    }

    public void scroll(float xAmount, float yAmount) {
        this.textureRegion.scroll(xAmount, yAmount);
    }

    public Pixmap toPixmap() {
        LibgdxTexture texture = (LibgdxTexture)this.getTexture();
        if (!texture.getTextureData().isPrepared()) {
            texture.getTextureData().prepare();
        }
        com.badlogic.gdx.graphics.Pixmap texturePixmap = texture.getTextureData().consumePixmap();
        LibgdxPixmap result = (LibgdxPixmap)Mdx.graphics.newPixmap(this.getRegionWidth(), this.getRegionHeight(), PixmapFormat.RGBA8888);
        result.pixmap.drawPixmap(texturePixmap, 0, 0, this.getRegionX(), this.getRegionY(), this.getRegionWidth(), this.getRegionHeight());
        return result;
    }

    public TextureRegion[][] split(int tileWidth, int tileHeight) {
        int x = this.getRegionX();
        int y = this.getRegionY();
        int width = this.getRegionWidth();
        int height = this.getRegionHeight();
        int rows = height / tileHeight;
        int columns = width / tileWidth;
        int startX = x;
        TextureRegion[][] result = new TextureRegion[rows][columns];
        int row = 0;
        while (row < rows) {
            x = startX;
            int col = 0;
            while (col < columns) {
                result[row][col] = Mdx.graphics.newTextureRegion(this.getTexture(), x, y, tileWidth, tileHeight);
                ++col;
                x += tileWidth;
            }
            ++row;
            y += tileHeight;
        }
        return result;
    }
}

