/*
 * Decompiled with CFR 0.152.
 */
package org.mini2Dx.libgdx.input;

import com.badlogic.gdx.controllers.AdvancedController;
import com.badlogic.gdx.controllers.Controller;
import org.mini2Dx.gdx.math.MathUtils;
import org.mini2Dx.libgdx.input.LibgdxGamePad;

public class LibgdxAdvancedGamePad
extends LibgdxGamePad {
    public final AdvancedController advancedController;
    protected float vibrateStrength = 0.0f;

    public LibgdxAdvancedGamePad(AdvancedController controller) {
        super((Controller)controller);
        this.advancedController = controller;
    }

    @Override
    public String getInstanceId() {
        if (this.advancedController.getUniqueId() != null) {
            return this.advancedController.getUniqueId();
        }
        return super.getInstanceId();
    }

    @Override
    public boolean isPlayerIndicesSupported() {
        return this.advancedController.supportsPlayerIndex();
    }

    @Override
    public int getPlayerIndex() {
        return this.advancedController.getPlayerIndex();
    }

    @Override
    public void setPlayerIndex(int playerIndex) {
        this.advancedController.setPlayerIndex(playerIndex);
    }

    @Override
    public boolean isVibrateSupported() {
        return this.advancedController.canVibrate();
    }

    @Override
    public boolean isVibrating() {
        return this.advancedController.isVibrating() && this.vibrateStrength > 0.0f;
    }

    @Override
    public float getVibrationStrength() {
        return this.vibrateStrength;
    }

    @Override
    public void startVibration(float strength) {
        this.vibrateStrength = MathUtils.clamp((float)strength, (float)0.0f, (float)1.0f);
        this.advancedController.startVibration(this.vibrateStrength);
    }

    @Override
    public void stopVibration() {
        this.vibrateStrength = 0.0f;
        this.advancedController.stopVibration();
    }
}

